/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.LatentHeatOfEvaporation;
import ucar.visad.quantities.SpecificHeatCapacityOfDryAirAtConstantPressure;
import visad.Data;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.TypeException;
import visad.VisADException;

public class AdiabaticEquivalentTemperature
extends AirTemperature {
    private static AdiabaticEquivalentTemperature INSTANCE;
    protected static Real lOverCSubP;

    private AdiabaticEquivalentTemperature() throws VisADException {
        this("AdiabaticEquivalentTemperature");
    }

    protected AdiabaticEquivalentTemperature(String name) throws VisADException {
        super(name);
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)AdiabaticEquivalentTemperature.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<AdiabaticEquivalentTemperature> clazz = AdiabaticEquivalentTemperature.class;
        synchronized (AdiabaticEquivalentTemperature.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new AdiabaticEquivalentTemperature();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Data create(Data temperature, Data mixingRatio) throws TypeException, VisADException, RemoteException {
        if (lOverCSubP != null) return Util.clone(VisADMath.multiply(temperature, VisADMath.exp(VisADMath.multiply(lOverCSubP, VisADMath.divide(mixingRatio, temperature)))), AdiabaticEquivalentTemperature.getRealType());
        Class<AdiabaticEquivalentTemperature> clazz = AdiabaticEquivalentTemperature.class;
        synchronized (AdiabaticEquivalentTemperature.class) {
            if (lOverCSubP != null) return Util.clone(VisADMath.multiply(temperature, VisADMath.exp(VisADMath.multiply(lOverCSubP, VisADMath.divide(mixingRatio, temperature)))), AdiabaticEquivalentTemperature.getRealType());
            lOverCSubP = (Real)VisADMath.divide(LatentHeatOfEvaporation.newReal(), SpecificHeatCapacityOfDryAirAtConstantPressure.newReal());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Util.clone(VisADMath.multiply(temperature, VisADMath.exp(VisADMath.multiply(lOverCSubP, VisADMath.divide(mixingRatio, temperature)))), AdiabaticEquivalentTemperature.getRealType());
        }
    }
}

