/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.physics;

import java.rmi.RemoteException;
import ucar.visad.ScalarQuantity;
import visad.Data;
import visad.ErrorEstimate;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SI;
import visad.Set;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class TimeInterval
extends ScalarQuantity {
    public static final Unit SECOND;
    public static final Unit DEFAULT_UNIT;
    public static final Unit MINUTE;
    public static final Unit HOUR;
    public static final Unit DAY;
    public static final Unit YEAR;
    private static volatile TimeInterval instance;

    protected TimeInterval(String name) throws VisADException {
        this(name, DEFAULT_UNIT);
    }

    protected TimeInterval(String name, Unit unit) throws VisADException {
        this(name, unit, (Set)null);
    }

    protected TimeInterval(String name, Unit unit, Set set) throws VisADException {
        super(name, unit, set);
    }

    private TimeInterval() throws VisADException {
        super(RealType.TimeInterval);
    }

    public static TimeInterval instance() {
        return instance;
    }

    public static Real NewReal(double amount, Unit unit) throws VisADException {
        return TimeInterval.NewReal(amount, unit, null);
    }

    public static Real NewReal(double amount, Unit unit, ErrorEstimate error) throws VisADException {
        return instance.newReal(amount, unit, error);
    }

    public static void Vet(Data data) throws TypeException, VisADException, RemoteException {
        instance.vet(data);
    }

    public static void Vet(MathType type) throws TypeException, VisADException {
        instance.vet(type);
    }

    static {
        Unit a;
        Unit d;
        Unit h;
        Unit min;
        DEFAULT_UNIT = SECOND = SI.second;
        try {
            min = SECOND.scale(60.0).clone("min");
            h = min.scale(60.0).clone("h");
            d = h.scale(24.0).clone("d");
            a = SECOND.scale(3.15569259747E7).clone("a");
            instance = new TimeInterval();
        }
        catch (Exception e) {
            min = null;
            h = null;
            d = null;
            a = null;
            System.err.println("TimeInterval.<clinit>(): Couldn't initialize class: " + e);
            System.exit(1);
        }
        MINUTE = min;
        HOUR = h;
        DAY = d;
        YEAR = a;
    }
}

