/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.physics;

import java.rmi.RemoteException;
import ucar.visad.ScalarQuantity;
import ucar.visad.physics.Length;
import ucar.visad.physics.TimeInterval;
import visad.Data;
import visad.ErrorEstimate;
import visad.MathType;
import visad.Real;
import visad.Set;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class Speed
extends ScalarQuantity {
    public static final Unit METERS_PER_SECOND;
    public static final Unit DEFAULT_UNIT;
    public static final Unit MILES_PER_HOUR;
    public static final Unit FEET_PER_SECOND;
    public static final Unit KNOT;
    private static Speed instance;

    private Speed(Unit unit) throws VisADException {
        this("Speed", unit);
    }

    protected Speed(String name) throws VisADException {
        this(name, DEFAULT_UNIT);
    }

    protected Speed(String name, Unit unit) throws VisADException {
        this(name, unit, (Set)null);
    }

    protected Speed(String name, Unit unit, Set set) throws VisADException {
        super(name, unit, set);
    }

    public static ScalarQuantity instance() {
        return instance;
    }

    public static Real NewReal(double amount, Unit unit) throws VisADException {
        return Speed.NewReal(amount, unit, null);
    }

    public static Real NewReal(double amount, Unit unit, ErrorEstimate error) throws VisADException {
        return instance.newReal(amount, unit, error);
    }

    public static void Vet(Data data) throws TypeException, VisADException, RemoteException {
        instance.vet(data);
    }

    public static void Vet(MathType type) throws TypeException, VisADException {
        instance.vet(type);
    }

    static {
        Unit kt;
        Unit fps;
        Unit mph;
        Unit mps;
        try {
            mps = Length.METER.divide(TimeInterval.SECOND);
            mph = Length.MILE.divide(TimeInterval.HOUR);
            fps = Length.FOOT.divide(TimeInterval.SECOND).clone("fps");
            kt = Length.NAUTICAL_MILE.divide(TimeInterval.HOUR).clone("kt");
            instance = new Speed(mps);
        }
        catch (Exception e) {
            mps = null;
            mph = null;
            fps = null;
            kt = null;
            System.err.println("Speed.<clinit>(): Couldn't initialize class: " + e);
            System.exit(1);
        }
        METERS_PER_SECOND = mps;
        MILES_PER_HOUR = mph;
        DEFAULT_UNIT = METERS_PER_SECOND;
        FEET_PER_SECOND = fps;
        KNOT = kt;
    }
}

