/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.physics;

import java.rmi.RemoteException;
import ucar.visad.ScalarQuantity;
import visad.BaseUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.ErrorEstimate;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SI;
import visad.Set;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class Length
extends ScalarQuantity {
    public static final Unit METER;
    public static final Unit MILE;
    public static final Unit NAUTICAL_MILE;
    public static final Unit FOOT;
    public static final Unit DEFAULT_UNIT;
    private static Length instance;

    private Length(Unit unit) throws VisADException {
        this("Length", unit);
    }

    protected Length(String name) throws VisADException {
        this(name, DEFAULT_UNIT);
    }

    protected Length(String name, Unit unit) throws VisADException {
        this(name, unit, (Set)null);
    }

    protected Length(String name, Unit unit, Set set) throws VisADException {
        this(RealType.getRealType(name, unit, set, 0));
    }

    protected Length(RealType type) throws VisADException {
        super(type);
    }

    protected Length(RealType realType, CoordinateSystem coordSys, Set domain) throws TypeException, VisADException {
        super(realType, coordSys, domain);
    }

    public static ScalarQuantity instance() {
        return instance;
    }

    public static Real NewReal(double amount, Unit unit) throws VisADException {
        return Length.NewReal(amount, unit, null);
    }

    public static Real NewReal(double amount, Unit unit, ErrorEstimate error) throws VisADException {
        return instance.newReal(amount, unit, error);
    }

    public static void Vet(Data data) throws TypeException, VisADException, RemoteException {
        instance.vet(data);
    }

    public static void Vet(MathType type) throws TypeException, VisADException {
        instance.vet(type);
    }

    static {
        Unit nmi;
        Unit ft;
        Unit mi;
        BaseUnit m;
        try {
            m = SI.meter;
            mi = ((Unit)m).scale(1609.344).clone("mi");
            ft = ((Unit)m).scale(0.3048).clone("ft");
            nmi = ((Unit)m).scale(1852.0).clone("nmi");
            instance = new Length(m);
        }
        catch (Exception e) {
            m = null;
            mi = null;
            ft = null;
            nmi = null;
            System.err.println("Length.<clinit>(): Couldn't initialize class: " + e);
            System.exit(1);
        }
        DEFAULT_UNIT = METER = m;
        MILE = mi;
        FOOT = ft;
        NAUTICAL_MILE = nmi;
    }
}

