/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import ucar.unidata.util.Misc;
import ucar.visad.display.Displayable;
import ucar.visad.display.SelectorDisplayable;
import ucar.visad.display.SelectorPoint;
import visad.ActionImpl;
import visad.ConstantMap;
import visad.Display;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.VisADException;

public class ZSelector
extends SelectorDisplayable {
    private SelectorPoint zSelector;

    public ZSelector(double x, double y, double z) throws VisADException, RemoteException {
        this.init(x, y, z, Color.blue);
    }

    public ZSelector(double x, double y, double z, Color color) throws VisADException, RemoteException {
        this.init(x, y, z, color);
    }

    public ZSelector(ZSelector that) throws VisADException, RemoteException {
        super(that);
    }

    private void init(double x, double y, double z, Color color) throws VisADException, RemoteException {
        Real[] reals = new Real[]{new Real(RealType.ZAxis, z)};
        this.zSelector = new SelectorPoint("height selector", new RealTuple(reals));
        this.zSelector.addConstantMap(new ConstantMap(x, Display.XAxis));
        this.zSelector.addConstantMap(new ConstantMap(y, Display.YAxis));
        this.zSelector.setVisible(true);
        this.zSelector.addAction(new ActionImpl("Z Selector Listener"){
            Real lastZPosition;
            boolean first;
            {
                this.lastZPosition = null;
                this.first = true;
            }

            @Override
            public void doAction() {
                try {
                    if (!Misc.equals(ZSelector.this.getZSelectorPosition(), this.lastZPosition) || this.first) {
                        ZSelector.this.notifyListenersOfMove();
                        this.lastZPosition = ZSelector.this.getZSelectorPosition();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.first) {
                    this.first = false;
                }
            }
        });
        this.zSelector.setManipulable(true);
        this.zSelector.setPointSize(this.getPointSize());
        this.setColor(color);
        this.addDisplayable(this.zSelector);
    }

    public Real getZSelectorPosition() throws VisADException, RemoteException {
        return (Real)this.zSelector.getPoint().getComponent(0);
    }

    public Real getPosition() throws VisADException, RemoteException {
        return (Real)this.zSelector.getPoint().getComponent(0);
    }

    public void setZValue(double newZValue) throws VisADException, RemoteException {
        RealTuple newPoint = new RealTuple(new Real[]{new Real(RealType.ZAxis, newZValue)});
        if (!newPoint.equals(this.zSelector.getPoint())) {
            this.setOkToFireEvents(false);
            this.zSelector.setPoint(newPoint);
            this.setOkToFireEvents(true);
        }
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new ZSelector(this);
    }
}

