/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Dimension;
import java.rmi.RemoteException;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.ScalarMapSet;
import visad.AxisScale;
import visad.Display;
import visad.ProjectionControl;
import visad.RealType;
import visad.ScalarMap;
import visad.Unit;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;

public class XYDisplay
extends DisplayMaster {
    private RealType yAxisType;
    private RealType xAxisType;
    private ScalarMap yAxisMap;
    private ScalarMap xAxisMap;
    private ScalarMap xMap;
    private ScalarMap yMap;
    private boolean haveInitialized = false;
    private String name;
    private boolean clipOn = true;
    private boolean gridLinesVisible = false;

    public XYDisplay() throws VisADException, RemoteException {
        this("XYDisplay");
    }

    public XYDisplay(String name) throws VisADException, RemoteException {
        this(name, RealType.XAxis, RealType.YAxis);
    }

    public XYDisplay(boolean offscreen, Dimension dimension) throws VisADException, RemoteException {
        this("XYDisplay", RealType.XAxis, RealType.YAxis, offscreen, dimension);
    }

    public XYDisplay(String name, RealType xAxisType, RealType yAxisType) throws VisADException, RemoteException {
        this(name, xAxisType, yAxisType, false, null);
    }

    public XYDisplay(String name, RealType xAxisType, RealType yAxisType, boolean offScreen, Dimension dimension) throws VisADException, RemoteException {
        super(XYDisplay.makeDisplayImpl(name, offScreen, dimension), 1, offScreen ? (dimension == null ? new Dimension(600, 300) : dimension) : null);
        this.name = name;
        this.yAxisType = yAxisType;
        this.xAxisType = xAxisType;
        this.initializeClass();
    }

    private static DisplayImplJ3D makeDisplayImpl(String name, boolean offScreen, Dimension dimension) throws VisADException, RemoteException {
        TwoDDisplayRendererJ3D renderer = new TwoDDisplayRendererJ3D();
        if (dimension == null) {
            dimension = new Dimension(600, 300);
        }
        if (offScreen) {
            return new DisplayImplJ3D(name, (DisplayRendererJ3D)renderer, dimension.width, dimension.height);
        }
        return new DisplayImplJ3D(name, (DisplayRendererJ3D)renderer);
    }

    private void initializeClass() throws VisADException, RemoteException {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        rend.addKeyboardBehavior(new KeyboardBehaviorJ3D(rend));
        this.setSpatialScalarMaps();
    }

    private void setSpatialScalarMaps() throws VisADException, RemoteException {
        this.setDisplayInactive();
        ScalarMapSet mapSet = new ScalarMapSet();
        if (!this.haveInitialized) {
            this.xMap = new ScalarMap(RealType.XAxis, Display.XAxis);
            this.xMap.setRange(-1.0, 1.0);
            mapSet.add(this.xMap);
            this.yMap = new ScalarMap(RealType.YAxis, Display.YAxis);
            this.yMap.setRange(-1.0, 1.0);
            mapSet.add(this.yMap);
            this.haveInitialized = true;
        }
        if (this.xAxisMap == null || !this.xAxisMap.getScalar().equals(this.xAxisType)) {
            if (this.xAxisMap != null) {
                this.removeScalarMap(this.xAxisMap);
            }
            this.xAxisMap = new ScalarMap(this.xAxisType, Display.XAxis);
            mapSet.add(this.xAxisMap);
            this.xMap.setScaleEnable(false);
        }
        if (this.yAxisMap == null || !this.yAxisMap.getScalar().equals(this.yAxisType)) {
            if (this.yAxisMap != null) {
                this.removeScalarMap(this.yAxisMap);
            }
            this.yAxisMap = new ScalarMap(this.yAxisType, Display.YAxis);
            mapSet.add(this.yAxisMap);
            this.yMap.setScaleEnable(false);
        }
        this.addScalarMaps(mapSet);
        this.setDisplayActive();
    }

    public void setXAxisType(RealType xType) throws VisADException, RemoteException {
        this.xAxisType = xType;
        this.setSpatialScalarMaps();
    }

    public void setYAxisType(RealType yType) throws VisADException, RemoteException {
        this.yAxisType = yType;
        this.setSpatialScalarMaps();
    }

    public RealType getXAxisType() {
        return this.xAxisType;
    }

    public RealType getYAxisType() {
        return this.yAxisType;
    }

    public void setAxisTypes(RealType xType, RealType yType) throws VisADException, RemoteException {
        this.xAxisType = xType;
        this.yAxisType = yType;
        this.setSpatialScalarMaps();
    }

    public AxisScale getXAxisScale() {
        return this.xAxisMap == null ? null : this.xAxisMap.getAxisScale();
    }

    public AxisScale getYAxisScale() {
        return this.yAxisMap == null ? null : this.yAxisMap.getAxisScale();
    }

    public void showAxisScales(boolean show) {
        try {
            this.getDisplay().getGraphicsModeControl().setScaleEnable(show);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setXRange(double min, double max) {
        try {
            if (this.xAxisMap != null) {
                this.xAxisMap.setRange(min, max);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setYRange(double min, double max) {
        try {
            if (this.yAxisMap != null) {
                this.yAxisMap.setRange(min, max);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void autoScaleXAxis() {
        if (this.xAxisMap != null) {
            this.xAxisMap.resetAutoScale();
        }
    }

    public void autoScaleYAxis() {
        if (this.yAxisMap != null) {
            this.yAxisMap.resetAutoScale();
        }
    }

    public void setXDisplayUnit(Unit newUnit) {
        try {
            if (this.xAxisMap != null) {
                this.xAxisMap.setOverrideUnit(newUnit);
            }
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }

    public void setYDisplayUnit(Unit newUnit) {
        try {
            if (this.yAxisMap != null) {
                this.yAxisMap.setOverrideUnit(newUnit);
            }
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }

    public Unit getXDisplayUnit() {
        Unit u = null;
        if (this.xAxisMap != null && (u = this.xAxisMap.getOverrideUnit()) == null) {
            u = ((RealType)this.xAxisMap.getScalar()).getDefaultUnit();
        }
        return u;
    }

    public Unit getYDisplayUnit() {
        Unit u = null;
        if (this.yAxisMap != null && (u = this.yAxisMap.getOverrideUnit()) == null) {
            u = ((RealType)this.yAxisMap.getScalar()).getDefaultUnit();
        }
        return u;
    }

    public void setAspect(double x, double y) {
        try {
            ProjectionControl pc = this.getDisplay().getProjectionControl();
            pc.setAspectCartesian(new double[]{x, y});
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void enableClipping(boolean clip) {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        try {
            dr.setClip(0, clip, 1.0f, 0.0f, 0.0f, -1.01f);
            dr.setClip(1, clip, -1.0f, 0.0f, 0.0f, -1.01f);
            dr.setClip(2, clip, 0.0f, 1.0f, 0.0f, -1.01f);
            dr.setClip(3, clip, 0.0f, -1.0f, 0.0f, -1.01f);
            dr.setClip(4, clip, 0.0f, 0.0f, 1.0f, -1.01f);
            dr.setClip(5, clip, 0.0f, 0.0f, -1.0f, -1.01f);
            this.clipOn = clip;
        }
        catch (VisADException ve) {
            System.err.println("Couldn't set clipping " + ve);
        }
    }

    public void setGridLinesVisible(boolean yesorno) {
        AxisScale scale = this.getXAxisScale();
        if (scale != null) {
            scale.setGridLinesVisible(yesorno);
        }
        if ((scale = this.getYAxisScale()) != null) {
            scale.setGridLinesVisible(yesorno);
        }
        this.gridLinesVisible = yesorno;
    }

    public boolean getGridLinesVisible() {
        return this.gridLinesVisible;
    }
}

