/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Dimension;
import java.rmi.RemoteException;
import ucar.visad.display.XYDisplay;
import visad.Real;
import visad.RealType;
import visad.VisADException;

public class XSDisplay
extends XYDisplay {
    public static final String CURSOR_YVALUE = "cursorYValue";
    public static final String CURSOR_XVALUE = "cursorXValue";
    private volatile Real cursorYValue;
    private volatile Real cursorXValue;

    public XSDisplay() throws VisADException, RemoteException {
        this(false, null);
    }

    public XSDisplay(boolean offScreen, Dimension dimension) throws VisADException, RemoteException {
        super("Cross section Display", RealType.XAxis, RealType.YAxis, offScreen, dimension);
    }

    public XSDisplay(String name, RealType xType, RealType yType) throws VisADException, RemoteException {
        this(name, xType, yType, false, null);
    }

    public XSDisplay(String name, RealType xType, RealType yType, boolean offScreen, Dimension dimension) throws VisADException, RemoteException {
        super(name, xType, yType, offScreen, dimension);
    }

    protected void setCursorYValue(Real yxalue) throws VisADException, RemoteException {
        Real oldYValue = this.cursorYValue;
        this.cursorYValue = yxalue;
        this.firePropertyChange(CURSOR_YVALUE, oldYValue, this.cursorYValue);
    }

    public Real getCursorYValue() {
        return this.cursorYValue;
    }

    protected void setCursorXValue(Real xvalue) throws VisADException, RemoteException {
        Real oldval = xvalue;
        this.cursorXValue = xvalue;
        this.firePropertyChange(CURSOR_XVALUE, oldval, this.cursorXValue);
    }

    public Real getCursorXValue() {
        return this.cursorXValue;
    }
}

