/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.WindBarbRenderer;
import ucar.visad.display.FlowDisplayable;
import visad.DataRenderer;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.bom.BarbRendererJ2D;
import visad.java2d.DisplayRendererJ2D;

public class WindBarbDisplayable
extends FlowDisplayable {
    public WindBarbDisplayable(String name, RealTupleType rTT) throws VisADException, RemoteException {
        this(name, rTT, false);
    }

    public WindBarbDisplayable(String name, RealTupleType rTT, boolean useSpeedForColor) throws VisADException, RemoteException {
        super(name, rTT, 0.1f, useSpeedForColor);
    }

    @Override
    protected DataRenderer getDataRenderer() {
        DataRenderer br = this.getDisplay().getDisplayRenderer() instanceof DisplayRendererJ2D ? new BarbRendererJ2D() : new WindBarbRenderer(this.speedUnit);
        return br;
    }

    @Override
    public void setRGBRealType(RealType realType) throws RemoteException, VisADException {
        super.setRGBRealType(realType);
    }

    @Override
    public void setFlowRange(double min, double max) throws VisADException, RemoteException {
        if (this.isCartesianWind()) {
            this.flowXMap.setRange(-1.0, 1.0);
            this.flowYMap.setRange(-1.0, 1.0);
        } else {
            this.flowXMap.setRange(0.0, 360.0);
            this.flowYMap.setRange(0.0, 1.0);
        }
    }

    @Override
    public boolean get3DFlow() {
        return false;
    }
}

