/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.visad.display.Displayable;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.RGBDisplayable;
import visad.ConstantMap;
import visad.Display;
import visad.FieldImpl;
import visad.RealType;
import visad.TupleType;
import visad.VisADException;

public class VolumeDisplayable
extends RGBDisplayable
implements GridDisplayable {
    public VolumeDisplayable(String name) throws VisADException, RemoteException {
        this(name, null, null);
    }

    public VolumeDisplayable(String name, RealType rgbRealType, float[][] colorPalette) throws VisADException, RemoteException {
        super(name, null, colorPalette, true);
        this.addConstantMap(new ConstantMap(1.0, Display.TextureEnable));
    }

    protected VolumeDisplayable(VolumeDisplayable that) throws VisADException, RemoteException {
        super(that);
    }

    @Override
    public void loadData(FieldImpl field) throws VisADException, RemoteException {
        this.loadData(field, 0);
    }

    public void loadData(FieldImpl field, int rgbIndex) throws VisADException, RemoteException {
        TupleType tt = GridUtil.getParamType(field);
        RealType ffldType = tt.getRealComponents()[rgbIndex];
        if (this.getRGBRealType() == null || !ffldType.equals(this.getRGBRealType())) {
            this.setRGBRealType(ffldType);
        }
        this.setData(field);
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new VolumeDisplayable(this);
    }

    @Override
    public void setColoredByAnother(boolean yesno) {
    }
}

