/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.visad.display.Displayable;
import ucar.visad.display.RGBDisplayable;
import visad.ConstantMap;
import visad.Display;
import visad.FieldImpl;
import visad.RealType;
import visad.VisADException;

public class TrackDisplayable
extends RGBDisplayable {
    public static String LINE_WIDTH = "lineWidth";
    private FieldImpl track = null;
    private float myLineWidth = 1.0f;

    public TrackDisplayable(String name) throws VisADException, RemoteException {
        super(name, null, true);
        this.setLineWidth(this.myLineWidth);
    }

    public void setTrack(FieldImpl track) throws VisADException, RemoteException {
        RealType[] types = GridUtil.getParamType(track).getRealComponents();
        RealType ffldType = types[0];
        RealType rgbRealType = this.getRGBRealType();
        if (rgbRealType == null || !ffldType.equals(rgbRealType)) {
            super.setRGBRealType(ffldType);
        }
        if (types.length > 1) {
            RealType newSelectType = types.length > 1 ? types[1] : this.getRGBRealType();
            RealType selectRealType = this.getSelectRealType();
            if (selectRealType == null || !newSelectType.equals(selectRealType)) {
                this.setSelectRealType(newSelectType);
            }
        }
        this.track = track;
        this.setData(this.track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLineWidth(float lineWidth) throws VisADException, RemoteException {
        float oldValue;
        TrackDisplayable trackDisplayable = this;
        synchronized (trackDisplayable) {
            oldValue = this.myLineWidth;
            this.addConstantMaps(new ConstantMap[]{new ConstantMap(lineWidth, Display.LineWidth), new ConstantMap(lineWidth, Display.PointSize)});
            this.myLineWidth = lineWidth;
        }
        this.firePropertyChange(LINE_WIDTH, new Float(oldValue), new Float(this.myLineWidth));
    }

    @Override
    public float getLineWidth() {
        return this.myLineWidth;
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return this;
    }

    @Override
    public boolean getUseRGBTypeForSelect() {
        return false;
    }
}

