/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Font;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.DataRenderer;
import visad.Display;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.ScalarType;
import visad.TextControl;
import visad.Unit;
import visad.VisADException;
import visad.bom.ScreenLockedRendererJ3D;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java3d.DefaultRendererJ3D;
import visad.util.HersheyFont;

public class TextDisplayable
extends LineDrawing {
    private TextControl textControl;
    private ScalarType textType;
    private ScalarMap textMap;
    NumberFormat labelFormat = new DecimalFormat("#########");
    Object labelFont = null;
    private double rotation = 0.0;
    private double characterRotation = 0.0;
    private float textSize = 1.0f;
    private TextControl.Justification justification = TextControl.Justification.CENTER;
    private TextControl.Justification verticalJustification = TextControl.Justification.BOTTOM;
    private boolean screenLocked = false;
    private boolean useSphere = false;

    public TextDisplayable() throws VisADException, RemoteException {
        this("Display_Text");
    }

    public TextDisplayable(String name) throws VisADException, RemoteException {
        this(name, null);
    }

    public TextDisplayable(ScalarType textType) throws VisADException, RemoteException {
        this(textType.getName(), textType);
    }

    public TextDisplayable(String name, ScalarType textType) throws VisADException, RemoteException {
        this(name, textType, false);
    }

    public TextDisplayable(String name, ScalarType textType, boolean screenLocked) throws VisADException, RemoteException {
        super(name);
        this.screenLocked = screenLocked;
        if (textType != null) {
            this.setTextType(textType);
        }
    }

    protected TextDisplayable(TextDisplayable that) throws RemoteException, VisADException {
        super(that);
        this.textType = that.textType;
        this.labelFormat = that.labelFormat;
        this.labelFont = that.labelFont;
        this.rotation = that.rotation;
        this.characterRotation = that.characterRotation;
        this.textSize = that.textSize;
        this.justification = that.justification;
        this.verticalJustification = that.verticalJustification;
        this.screenLocked = that.screenLocked;
        if (this.textType != null) {
            this.setTextScalarMap(this.textType);
        }
    }

    public void setTextType(ScalarType textType) throws RemoteException, VisADException {
        this.textType = textType;
        this.setTextScalarMap(textType);
    }

    public ScalarType getTextType() {
        return this.textType;
    }

    public void setNumberFormat(NumberFormat format) throws VisADException, RemoteException {
        if (this.textControl != null && format != null) {
            this.textControl.setNumberFormat(format);
        }
        this.labelFormat = format;
    }

    @Override
    public void setVisible(boolean visible) throws RemoteException, VisADException {
        super.setVisible(visible);
        if (this.textControl != null) {
            this.textControl.setAutoSize(visible);
        }
    }

    public NumberFormat getNumberFormat() {
        return this.labelFormat;
    }

    public void setScreenLocked(boolean locked) throws VisADException, RemoteException {
        this.screenLocked = locked;
        if (this.textControl != null) {
            this.textControl.setAutoSize(!this.screenLocked);
        }
    }

    public boolean getScreenLocked() {
        return this.screenLocked;
    }

    public void setTextSize(float size) throws VisADException, RemoteException {
        if (this.textControl != null && size != this.textSize) {
            this.textControl.setSize(size);
        }
        this.textSize = size;
    }

    public float getTextSize() {
        return this.textControl != null ? (float)this.textControl.getSize() : this.textSize;
    }

    public void setSphere(boolean sphere) throws VisADException, RemoteException {
        if (this.textControl != null && this.useSphere != sphere) {
            this.textControl.setSphere(sphere);
        }
        this.useSphere = sphere;
    }

    public boolean getSphere() {
        return this.useSphere;
    }

    public void setJustification(TextControl.Justification justification) throws VisADException, RemoteException {
        if (this.textControl != null && this.justification != justification) {
            this.textControl.setJustification(justification);
        }
        this.justification = justification;
    }

    public TextControl.Justification getJustification() {
        return this.justification;
    }

    public void setVerticalJustification(TextControl.Justification verticalJustification) throws VisADException, RemoteException {
        if (this.textControl != null && this.verticalJustification != verticalJustification) {
            this.textControl.setVerticalJustification(verticalJustification);
        }
        this.verticalJustification = verticalJustification;
    }

    public TextControl.Justification getverticalJustification() {
        return this.verticalJustification;
    }

    public void setFont(Object font) throws VisADException, RemoteException {
        if (!(font instanceof Font) && !(font instanceof HersheyFont) && font != null) {
            throw new VisADException("Font must be java.awt.Font or HersheyFont");
        }
        if (this.textControl != null) {
            this.textControl.setFont(font);
        }
        this.labelFont = font;
    }

    public void setRotation(double rotation) throws VisADException, RemoteException {
        if (this.textControl != null) {
            this.textControl.setRotation(rotation);
        }
        this.rotation = rotation;
    }

    public void setCharacterRotation(double rotation) throws VisADException, RemoteException {
        if (this.textControl != null) {
            this.textControl.setCharacterRotation(rotation);
        }
        this.characterRotation = rotation;
    }

    public Font getFont() {
        if (this.labelFont instanceof Font) {
            return (Font)this.labelFont;
        }
        return null;
    }

    public HersheyFont getHersheyFont() {
        if (this.labelFont instanceof HersheyFont) {
            return (HersheyFont)this.labelFont;
        }
        return null;
    }

    private void setTextScalarMap(ScalarType textType) throws VisADException, RemoteException {
        ScalarMap oldTextMap = this.textMap;
        this.textMap = new ScalarMap(textType, Display.Text);
        this.textMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    TextDisplayable.this.textControl = (TextControl)TextDisplayable.this.textMap.getControl();
                    if (TextDisplayable.this.textControl != null) {
                        TextDisplayable.this.textControl.setJustification(TextDisplayable.this.justification);
                        TextDisplayable.this.textControl.setVerticalJustification(TextDisplayable.this.verticalJustification);
                        TextDisplayable.this.textControl.setSize(TextDisplayable.this.textSize);
                        TextDisplayable.this.textControl.setAutoSize(!TextDisplayable.this.screenLocked && TextDisplayable.this.getVisible());
                        TextDisplayable.this.textControl.setNumberFormat(TextDisplayable.this.labelFormat);
                        TextDisplayable.this.textControl.setRotation(TextDisplayable.this.rotation);
                        TextDisplayable.this.textControl.setCharacterRotation(TextDisplayable.this.characterRotation);
                        TextDisplayable.this.textControl.setFont(TextDisplayable.this.labelFont);
                        TextDisplayable.this.textControl.setSphere(TextDisplayable.this.useSphere);
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) {
            }
        });
        if (textType instanceof RealType) {
            this.applyDisplayUnit(this.textMap, (RealType)textType);
        }
        this.replaceScalarMap(oldTextMap, this.textMap);
        this.fireScalarMapSetChange();
    }

    @Override
    public void setDisplayUnit(Unit unit) throws VisADException, RemoteException {
        if (!(this.textType instanceof RealType)) {
            return;
        }
        this.checkUnit((RealType)this.textType, unit);
        super.setDisplayUnit(unit);
        this.applyDisplayUnit(this.textMap, (RealType)this.textType);
    }

    @Override
    public synchronized Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new TextDisplayable(this);
    }

    @Override
    protected DataRenderer getDataRenderer() throws VisADException {
        DefaultRendererJ2D renderer = this.getDisplay().getDisplayRenderer() instanceof DisplayRendererJ2D ? new DefaultRendererJ2D() : (this.screenLocked ? new ScreenLockedRendererJ3D() : new DefaultRendererJ3D());
        return renderer;
    }
}

