/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.media.j3d.Transform3D;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.GempakUtil;
import ucar.unidata.data.gis.KmlUtil;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.idv.JythonManager;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.ui.symbol.ColorMap;
import ucar.unidata.ui.symbol.LabelSymbol;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.unidata.ui.symbol.RotateInfo;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.TextSymbol;
import ucar.unidata.ui.symbol.ValueSymbol;
import ucar.unidata.ui.symbol.WeatherSymbol;
import ucar.unidata.ui.symbol.WindBarbSymbol;
import ucar.unidata.ui.symbol.WindVectorSymbol;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.WrapperException;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.ShapeUtility;
import ucar.visad.Util;
import ucar.visad.WindBarb;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.Display;
import visad.DisplayException;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RangeControl;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Scalar;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.ShadowType;
import visad.ShapeControl;
import visad.Text;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADQuadArray;
import visad.VisADTriangleArray;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;
import visad.georef.LatLonPoint;

public class StationModelDisplayable
extends DisplayableData {
    private static int INDEX_LAT = -1000;
    private static int INDEX_LON = -1001;
    private static int INDEX_ALT = -1002;
    private static int INDEX_TIME = -1003;
    public static final float OFFSET_SCALE = 20.0f;
    private Hashtable<String, Integer> nameToIndex;
    private boolean shouldUseAltitude = true;
    private boolean rotateShapes = false;
    private Transform3D transform = new Transform3D();
    private double[] currentRotation;
    private Point2D workPoint = new Point2D.Double();
    private Rectangle2D workRect = new Rectangle2D.Float();
    private Rectangle2D workShapeBounds = new Rectangle2D.Float();
    private float[] workOffsetArray = new float[]{0.0f, 0.0f, 0.0f};
    private Data[] workDataArray = new Data[]{null, null};
    private float[] workUV = new float[]{0.0f, 0.0f};
    float[][] workFlowValues = new float[][]{{0.0f}, {0.0f}, {0.0f}};
    float[][] workSpatialValues = new float[][]{{0.0f}, {0.0f}, {0.0f}};
    private boolean[][] workRangeSelect = new boolean[][]{{true}, {true}, {true}};
    private Hashtable<String, List> namesToList = new Hashtable();
    private Hashtable<String, String> haveNotified = null;
    private boolean tryMerge = true;
    private Hashtable codeToOperands = new Hashtable();
    private String convertCode = null;
    private String fmtCode = null;
    PythonInterpreter interp;
    private Hashtable shapeCache = new Hashtable();
    private Color myColor;
    private JythonManager jythonManager;
    ScalarMap wxMap = null;
    RealType wxType = null;
    ShapeControl shapeControl = null;
    ScalarMap timeSelectMap = null;
    RealType timeSelectType = null;
    private RangeControl timeSelectControl;
    private double lowSelectedRange = Double.NaN;
    private double highSelectedRange = Double.NaN;
    private double minSelect = Double.NaN;
    private double maxSelect = Double.NaN;
    VisADGeometryArray[] shapes = null;
    private static int count = 0;
    private StationModel stationModel;
    private FieldImpl stationData = null;
    private int shapeIndex;
    private List shapeList;
    private float scale = 1.0f;
    private double[] displayScaleFactor;
    private int[] varIndices;
    private static int instance = 0;
    private static Object INSTANCE_MUTEX = new Object();
    private Object DATA_MUTEX = new Object();
    private boolean isTimeSequence = false;
    private Real missingAlt;
    private int obCounter = 0;
    private int timeCounter = 0;
    private int geometryArrayCounter = 0;
    private boolean writingKmz = false;
    private ZipOutputStream kmzZos;
    private int kmzObCounter = 0;
    private Element kmlRoot;
    private Element kmlDoc;
    private int kmzIconHeight = 40;
    private int kmzIconWidth = 40;
    private Color iconColor;
    private File kmzFile;
    private boolean kmzShowExampleDialog = true;
    private long codeTime = 0L;

    public StationModelDisplayable() throws VisADException, RemoteException {
        this("Station Model");
    }

    public StationModelDisplayable(String name) throws VisADException, RemoteException {
        this(new StationModel(name));
    }

    public StationModelDisplayable(String name, JythonManager jythonManager) throws VisADException, RemoteException {
        this(name, new StationModel(name), jythonManager);
    }

    public StationModelDisplayable(StationModel model) throws VisADException, RemoteException {
        this(model, null);
    }

    public StationModelDisplayable(StationModel model, JythonManager jythonManager) throws VisADException, RemoteException {
        this(model.getName(), model, jythonManager);
    }

    public StationModelDisplayable(String name, StationModel stationModel) throws VisADException, RemoteException {
        this(name, stationModel, null);
    }

    public StationModelDisplayable(String name, StationModel stationModel, JythonManager jythonManager) throws VisADException, RemoteException {
        super(name);
        this.missingAlt = new Real(RealType.Altitude, 0.0);
        this.jythonManager = jythonManager;
        this.stationModel = stationModel;
        this.setUpScalarMaps();
    }

    protected StationModelDisplayable(StationModelDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.stationModel = that.stationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStationData(FieldImpl stationData) throws VisADException, RemoteException {
        Object object = this.DATA_MUTEX;
        synchronized (object) {
            this.setDisplayInactive();
            try {
                FieldImpl d = this.makeNewDataWithShapes(stationData);
                if (d != null && !d.isMissing()) {
                    this.setData(d);
                } else {
                    this.setData(new Real(0.0));
                }
            }
            finally {
                this.setDisplayActive();
            }
            this.stationData = stationData;
        }
    }

    @Override
    public void setColor(Color c) throws VisADException, RemoteException {
        super.setColor(c);
        this.myColor = c;
        if (this.stationData != null) {
            this.setStationData(this.stationData);
        }
    }

    public Color getColor() {
        return this.myColor;
    }

    @Override
    public void toFront() throws RemoteException, VisADException {
        super.toFront();
        DisplayMaster master = this.getDisplayMaster();
        if (master != null) {
            this.setScale(master.getDisplayScale());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpScalarMaps() throws VisADException, RemoteException {
        int myInstance;
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            myInstance = instance++;
        }
        this.wxType = RealType.getRealType("Station_Model_" + myInstance);
        this.wxMap = new ScalarMap(this.wxType, Display.Shape);
        this.wxMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    StationModelDisplayable.this.shapeControl = (ShapeControl)StationModelDisplayable.this.wxMap.getControl();
                    if (StationModelDisplayable.this.shapeControl != null) {
                        StationModelDisplayable.this.setShapesInControl(StationModelDisplayable.this.shapes);
                        StationModelDisplayable.this.shapeControl.setAutoScale(false);
                        StationModelDisplayable.this.shapeControl.setScale(StationModelDisplayable.this.scale);
                        StationModelDisplayable.this.shapeControl.setAutoScale(true);
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
            }
        });
        this.addScalarMap(this.wxMap);
        this.timeSelectType = RealType.getRealType("Station_Model_Time" + myInstance, CommonUnit.secondsSinceTheEpoch);
        this.timeSelectMap = new ScalarMap(this.timeSelectType, Display.SelectRange);
        this.timeSelectMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    StationModelDisplayable.this.timeSelectControl = (RangeControl)StationModelDisplayable.this.timeSelectMap.getControl();
                    if (StationModelDisplayable.this.hasSelectedRange() && StationModelDisplayable.this.timeSelectControl != null) {
                        StationModelDisplayable.this.timeSelectControl.setRange(new double[]{StationModelDisplayable.this.lowSelectedRange, StationModelDisplayable.this.highSelectedRange});
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
                if (event.getId() == 1 && StationModelDisplayable.this.hasSelectMinMax()) {
                    StationModelDisplayable.this.timeSelectMap.setRange(StationModelDisplayable.this.minSelect, StationModelDisplayable.this.maxSelect);
                }
            }
        });
        this.addScalarMap(this.timeSelectMap);
    }

    private void setShapesInControl(VisADGeometryArray[] shapes) throws VisADException, RemoteException {
        if (this.shapeControl != null) {
            if (shapes == null || shapes.length == 0) {
                shapes = ShapeUtility.createShape("NONE");
            }
            this.shapeControl.setShapeSet(new Integer1DSet(shapes.length));
            this.shapeControl.setShapes(shapes);
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new StationModelDisplayable(this);
    }

    public void setStationModel(StationModel model) throws VisADException, RemoteException {
        this.setStationModel(model, true);
    }

    public void setStationModel(StationModel model, boolean update) throws VisADException, RemoteException {
        this.tryMerge = true;
        this.stationModel = model;
        if (this.stationData != null && update) {
            this.makeNewDataWithShapes(this.stationData);
        }
    }

    public StationModel getStationModel() {
        return this.stationModel;
    }

    private FieldImpl makeNewDataWithShapes(FieldImpl data) throws VisADException, RemoteException {
        double[] aspect;
        if (data == null) {
            return null;
        }
        DisplayMaster master = this.getDisplayMaster();
        this.displayScaleFactor = null;
        if (master != null && (aspect = master.getDisplayAspect()) != null && aspect.length > 2) {
            this.displayScaleFactor = new double[]{1.0 / aspect[0], 1.0 / aspect[1], 1.0 / aspect[2]};
        }
        FieldImpl newFI = null;
        if (this.rotateShapes) {
            this.currentRotation = master.getRotation();
            double[] m = master.getMouseBehavior().make_matrix(this.currentRotation[0], this.currentRotation[1], this.currentRotation[2], 1.0, 0.0, 0.0, 0.0);
            this.transform = new Transform3D(m);
            this.transform.invert();
        }
        this.haveNotified = null;
        this.isTimeSequence = GridUtil.isTimeSequence(data);
        boolean numTimes = false;
        this.shapeIndex = 0;
        this.shapeList = new Vector();
        this.nameToIndex = new Hashtable();
        this.obCounter = 0;
        this.timeCounter = 0;
        this.geometryArrayCounter = 0;
        try {
            if (this.isTimeSequence) {
                boolean haveChecked = false;
                Set timeSet = data.getDomainSet();
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    ++this.timeCounter;
                    FieldImpl sample = (FieldImpl)data.getSample(i);
                    FieldImpl shapeFI = this.makeShapesFromPointObsField(sample);
                    if (shapeFI == null) continue;
                    if (newFI == null) {
                        FunctionType functionType = new FunctionType(((FunctionType)data.getType()).getDomain(), shapeFI.getType());
                        newFI = new FieldImpl(functionType, timeSet);
                    }
                    newFI.setSample(i, shapeFI, false, !haveChecked);
                    if (haveChecked) continue;
                    haveChecked = true;
                }
            } else {
                newFI = this.makeShapesFromPointObsField(data);
            }
        }
        catch (Exception exc) {
            this.logException("making shapes", exc);
            return null;
        }
        try {
            this.shapes = new VisADGeometryArray[this.shapeList.size()];
            this.shapes = this.shapeList.toArray(this.shapes);
            this.setShapesInControl(this.shapes);
        }
        catch (Exception t) {
            throw new VisADException("Unable to covert vector to VisADGeometry array");
        }
        return newFI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeKmzFile(File f, FieldImpl data, String name, int kmzIconWidth, int kmzIconHeight, Color bgColor) throws Exception {
        try {
            this.kmzShowExampleDialog = true;
            this.kmzIconWidth = kmzIconWidth;
            this.kmzIconHeight = kmzIconHeight;
            this.iconColor = bgColor;
            this.kmzObCounter = 0;
            this.kmzFile = f;
            this.writingKmz = true;
            this.kmlRoot = KmlUtil.kml(name);
            this.kmlDoc = KmlUtil.document(this.kmlRoot, name);
            this.isTimeSequence = GridUtil.isTimeSequence(data);
            this.currentRotation = null;
            if (this.isTimeSequence) {
                Set timeSet = data.getDomainSet();
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    this.makeShapesFromPointObsField((FieldImpl)data.getSample(i));
                }
            } else {
                this.makeShapesFromPointObsField(data);
            }
            if (!this.writingKmz) {
                boolean timeSet = false;
                return timeSet;
            }
            this.kmzZos.putNextEntry(new ZipEntry("observations.kml"));
            byte[] bytes = XmlUtil.toString((Node)this.kmlRoot, false).getBytes();
            this.kmzZos.write(bytes, 0, bytes.length);
            this.kmzZos.closeEntry();
        }
        finally {
            this.writingKmz = false;
            if (this.kmzZos != null) {
                this.kmzZos.close();
            }
            this.kmzZos = null;
            this.kmzFile = null;
        }
        return true;
    }

    private FieldImpl makeShapesFromPointObsField(FieldImpl data) throws Exception {
        Set set = data.getDomainSet();
        Data tmp = data.getSample(0);
        if (tmp.isMissing()) {
            return null;
        }
        PointOb firstOb = (PointOb)data.getSample(0);
        FunctionType fieldType = (FunctionType)data.getType();
        RealTupleType domain = fieldType.getDomain();
        boolean useAltitude = this.getShouldUseAltitude();
        MathType llType = useAltitude ? firstOb.getEarthLocation().getType() : RealTupleType.LatitudeLongitudeTuple;
        Real indexReal = new Real(this.wxType, 0.0);
        Real timeReal = new Real(this.timeSelectType, 0.0);
        TupleType tt = new TupleType(new MathType[]{this.wxType, llType, this.timeSelectType});
        FunctionType retType = new FunctionType(domain, tt);
        ArrayList<Tuple> dataList = new ArrayList<Tuple>();
        ArrayList<MetSymbol> symbols = new ArrayList<MetSymbol>();
        ArrayList<Point2D> pointOnSymbols = new ArrayList<Point2D>();
        ArrayList<String> offsetFlipPoints = new ArrayList<String>();
        Iterator iter = this.stationModel.iterator();
        while (iter.hasNext()) {
            MetSymbol metSymbol = (MetSymbol)iter.next();
            if (!metSymbol.getActive()) continue;
            symbols.add(metSymbol);
            Rectangle symbolBounds = metSymbol.getBounds();
            String symbolPoint = metSymbol.getRectPoint();
            Point2D pointOnSymbol = Glyph.getPointOnRect(symbolPoint, symbolBounds);
            pointOnSymbol.setLocation(pointOnSymbol.getX() / 20.0, pointOnSymbol.getY() / 20.0);
            pointOnSymbols.add(pointOnSymbol);
            offsetFlipPoints.add(Glyph.flipY(symbolPoint));
        }
        boolean total = false;
        long t1 = System.currentTimeMillis();
        Trace.call1("SMD.makeShapes loop", " #obs:" + set.getLength() + " #vars:" + ((Tuple)firstOb.getData()).getLength());
        String[] typeNames = null;
        int length = set.getLength();
        TupleType dataTupleType = null;
        for (int obIdx = 0; obIdx < length; ++obIdx) {
            LatLonPoint oldOne;
            Real alt;
            LatLonPoint location;
            List<VisADGeometryArray> obShapes;
            PointOb ob = (PointOb)data.getSample(obIdx);
            ++this.obCounter;
            if (typeNames == null) {
                Tuple obData = (Tuple)ob.getData();
                TupleType tType = (TupleType)obData.getType();
                typeNames = this.getTypeNames(tType);
            }
            if ((obShapes = this.makeShapes(ob, typeNames, symbols, pointOnSymbols, offsetFlipPoints)) == null) continue;
            this.geometryArrayCounter += obShapes.size();
            if (this.writingKmz) {
                this.processKmz(ob, obShapes);
            }
            LatLonPoint latLonPoint = location = useAltitude ? ob.getEarthLocation() : ob.getEarthLocation().getLatLonPoint();
            if (useAltitude && (alt = (oldOne = location).getAltitude()).isMissing()) {
                location = new EarthLocationLite(oldOne.getLatitude(), oldOne.getLongitude(), this.missingAlt);
            }
            DateTime obTime = ob.getDateTime();
            Real time = timeReal.cloneButValue(obTime.getValue(this.timeSelectType.getDefaultUnit()));
            for (int j = 0; j < obShapes.size(); ++j) {
                Data[] dataArray = new Data[]{indexReal.cloneButValue(this.shapeIndex++), location, time};
                if (dataTupleType == null) {
                    dataTupleType = Tuple.buildTupleType(dataArray);
                }
                Tuple t = new Tuple(dataTupleType, dataArray, false, false);
                dataList.add(t);
                this.shapeList.add(obShapes.get(j));
            }
        }
        Trace.call2("SMD.makeShapes loop");
        long t2 = System.currentTimeMillis();
        FieldImpl fi = null;
        if (!dataList.isEmpty()) {
            Data[] dArray = new Data[dataList.size()];
            try {
                dArray = dataList.toArray(dArray);
            }
            catch (Exception t) {
                throw new VisADException("Unable to convert vector to data array");
            }
            Integer1DSet index = new Integer1DSet((MathType)domain, dArray.length);
            fi = new FieldImpl(retType, index);
            fi.setSamples(dArray, false, false);
        } else {
            fi = new FieldImpl(retType, new Integer1DSet((MathType)domain, 1));
            fi.setSample(0, (Data)new Tuple(tt), false);
        }
        return fi;
    }

    private void processKmz(PointOb ob, List<VisADGeometryArray> obShapes) throws Exception {
        BufferedImage image = new BufferedImage(this.kmzIconWidth, this.kmzIconHeight, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        if (this.iconColor != null) {
            g.setColor(this.iconColor);
            g.fillRect(0, 0, this.kmzIconWidth, this.kmzIconHeight);
        }
        g.setStroke(new BasicStroke(2.0f));
        this.paint(g, obShapes);
        if (this.kmzShowExampleDialog) {
            this.writingKmz = GuiUtils.showOkCancelDialog(null, null, GuiUtils.vbox(new JLabel("Example:"), new JLabel(new ImageIcon(image))), null);
            this.kmzShowExampleDialog = false;
            if (!this.writingKmz) {
                return;
            }
        }
        if (this.kmzZos == null) {
            this.kmzZos = new ZipOutputStream(new FileOutputStream(this.kmzFile));
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageUtils.writeImageToFile(image, "icon.png", bos, 1.0f);
        String file = "kmzicon" + this.kmzObCounter + ".png";
        this.kmzZos.putNextEntry(new ZipEntry(file));
        byte[] bytes = bos.toByteArray();
        this.kmzZos.write(bytes, 0, bytes.length);
        this.kmzZos.closeEntry();
        String styleId = "obicon" + this.kmzObCounter;
        StringBuffer descSB = new StringBuffer();
        descSB.append("<h3>Observation</h3>");
        descSB.append("<table>");
        Tuple tuple = (Tuple)ob.getData();
        TupleType tType = (TupleType)tuple.getType();
        String[] names = this.getTypeNames(tType);
        Data[] datum = tuple.getComponents();
        for (int i = 0; i < names.length; ++i) {
            descSB.append("<tr><td align=right><b>");
            descSB.append(names[i]);
            descSB.append(":</b></td><td>");
            if (datum[i] instanceof Real) {
                String us;
                Real r = (Real)datum[i];
                if (r.isMissing()) {
                    descSB.append("--");
                } else {
                    descSB.append("" + r);
                }
                Unit u = r.getUnit();
                if (u != null && (us = u.toString()).length() > 0) {
                    descSB.append(" [" + us + "]");
                }
            } else {
                descSB.append(datum[i] + "");
            }
            descSB.append("</td></tr>");
        }
        descSB.append("</table>");
        EarthLocation el = ob.getEarthLocation();
        Element placemark = KmlUtil.placemark(this.kmlDoc, "", descSB.toString(), el.getLatitude().getValue(CommonUnit.degree), el.getLongitude().getValue(CommonUnit.degree), el.getAltitude() != null ? el.getAltitude().getValue() : 0.0, styleId);
        KmlUtil.timestamp(placemark, Util.makeDate(ob.getDateTime()));
        KmlUtil.iconstyle(this.kmlDoc, styleId, file, 2.0);
        ++this.kmzObCounter;
    }

    private List<VisADGeometryArray> makeShapes(PointOb ob, String[] typeNames, List<MetSymbol> symbols, List<Point2D> pointOnSymbols, List offsetFlipPoints) throws VisADException, RemoteException {
        List lineShapes = null;
        List triangleShapes = null;
        List quadShapes = null;
        Tuple data = (Tuple)ob.getData();
        TupleType tType = (TupleType)data.getType();
        MetSymbol metSymbol = null;
        this.workDataArray[0] = null;
        this.workDataArray[1] = null;
        try {
            for (int symbolIdx = 0; symbolIdx < symbols.size(); ++symbolIdx) {
                Data scaleData;
                metSymbol = symbols.get(symbolIdx);
                Point2D pointOnSymbol = pointOnSymbols.get(symbolIdx);
                float shapeScaleFactor = 0.05f;
                String[] paramIds = metSymbol.getParamIds();
                boolean ok = true;
                if (!(metSymbol instanceof LabelSymbol) && !metSymbol.doAllObs()) {
                    int max = Math.min(this.workDataArray.length, paramIds.length);
                    for (int paramIdx = 0; paramIdx < max; ++paramIdx) {
                        String paramId = paramIds[paramIdx];
                        if (paramId.startsWith("=")) {
                            this.workDataArray[paramIdx] = this.evaluateCode(ob, paramId.substring(1), tType, typeNames, data, metSymbol, metSymbol.getDisplayUnit());
                        } else if (paramId.startsWith("value:")) {
                            String tok = paramId.substring(6);
                            this.workDataArray[paramIdx] = Util.toReal(tok);
                        } else {
                            this.workDataArray[paramIdx] = this.getComponent(ob, data, tType, typeNames, paramId);
                        }
                        if (this.workDataArray[paramIdx] != null) continue;
                        ok = false;
                        break;
                    }
                }
                if (!ok) continue;
                Rectangle symbolBounds = metSymbol.getBounds();
                VisADGeometryArray[] shapes = null;
                VisADGeometryArray shape = null;
                if (metSymbol.doAllObs()) {
                    shapes = metSymbol.makeShapes(ob);
                } else if (metSymbol instanceof TextSymbol) {
                    TextSymbol textSymbol = (TextSymbol)metSymbol;
                    Font font = textSymbol.getFont();
                    String stringValue = null;
                    Scalar scalar = (Scalar)this.workDataArray[0];
                    if (scalar != null && scalar instanceof Real && metSymbol instanceof ValueSymbol) {
                        ValueSymbol vs = (ValueSymbol)metSymbol;
                        try {
                            double value = vs.getDisplayUnit() == null || ((Real)scalar).getUnit() == null ? ((Real)scalar).getValue() : ((Real)scalar).getValue(vs.getDisplayUnit());
                            stringValue = Double.isNaN(value) ? null : vs.formatNumber(value);
                        }
                        catch (Exception ue) {
                            throw new WrapperException("Incompatible units " + ((Real)scalar).getUnit() + " & " + vs.getDisplayUnit(), ue);
                        }
                    } else if (metSymbol instanceof LabelSymbol) {
                        stringValue = ((LabelSymbol)metSymbol).getText();
                    } else if (metSymbol instanceof TextSymbol) {
                        stringValue = scalar instanceof Text ? ((Text)scalar).getValue() : ((TextSymbol)metSymbol).format((Real)scalar);
                    }
                    if (stringValue != null) {
                        if (font != null) {
                            shapeScaleFactor = 0.1f;
                        }
                        int fontSize = textSymbol.getFontSize();
                        String key = font + "_" + fontSize + "_" + stringValue;
                        shape = (VisADGeometryArray)this.shapeCache.get(key);
                        if (shape == null) {
                            VisADGeometryArray visADGeometryArray = shape = font == null ? ShapeUtility.shapeText(stringValue, fontSize, true) : ShapeUtility.shapeFont(stringValue, font, true);
                            if (shape != null) {
                                if (font != null && fontSize != 12) {
                                    shape = ShapeUtility.setSize(shape, (float)fontSize / 12.0f);
                                }
                                this.shapeCache.put(key, shape.clone());
                            }
                        } else {
                            shape = (VisADGeometryArray)shape.clone();
                        }
                    }
                } else if (metSymbol instanceof WeatherSymbol) {
                    double value = Double.NaN;
                    try {
                        value = this.workDataArray[0] instanceof Text ? new Double(this.workDataArray[0].toString()).doubleValue() : ((Real)this.workDataArray[0]).getValue();
                    }
                    catch (Exception stringValue) {
                        // empty catch block
                    }
                    if (!Double.isNaN(value)) {
                        String[] idc = metSymbol.getParamIds();
                        if (idc != null && idc[0].equals("WNUM")) {
                            int code = (int)value;
                            String dd = GempakUtil.pt_wcod(code);
                            value = GempakUtil.pt_wsym(dd);
                        }
                        shape = ((WeatherSymbol)metSymbol).getLines((int)value);
                    }
                } else if (metSymbol instanceof WindBarbSymbol) {
                    boolean isNorth = ob.getEarthLocation().getLatitude().getValue(CommonUnit.degree) < 0.0;
                    String name = metSymbol.getClass().getName();
                    String key = "wind_" + pointOnSymbol + "_" + isNorth + "_" + this.workDataArray[0] + "_" + this.workDataArray[1] + "_" + name;
                    if (shapes != null) {
                        shapes = ShapeUtility.clone(shapes);
                    } else {
                        float speed;
                        try {
                            speed = (float)((Real)this.workDataArray[0]).getValue(CommonUnit.meterPerSecond);
                        }
                        catch (Exception e) {
                            speed = (float)((Real)this.workDataArray[0]).getValue();
                        }
                        Real vOrSpeed = (Real)this.workDataArray[1];
                        if (Unit.canConvert(vOrSpeed.getUnit(), CommonUnit.meterPerSecond)) {
                            this.workUV[0] = speed;
                            this.workUV[1] = (float)vOrSpeed.getValue(CommonUnit.meterPerSecond);
                        } else {
                            float direction;
                            try {
                                direction = (float)vOrSpeed.getValue(CommonUnit.degree);
                            }
                            catch (Exception e) {
                                direction = (float)vOrSpeed.getValue();
                            }
                            this.windVector(speed, direction, this.workUV);
                        }
                        this.workFlowValues[0][0] = this.workUV[0];
                        this.workFlowValues[1][0] = this.workUV[1];
                        this.workFlowValues[2][0] = 0.0f;
                        if (Float.isNaN(this.workUV[0]) || Float.isNaN(this.workUV[1])) continue;
                        DisplayMaster master = this.getDisplayMaster();
                        if (master instanceof NavigatedDisplay && this.renderer != null && this.addRefsInvoked()) {
                            NavigatedDisplay navDisplay = (NavigatedDisplay)master;
                            double[] boxCoords = navDisplay.getSpatialCoordinates(ob.getEarthLocation(), new double[3]);
                            float[][] spatial_locs = new float[][]{{(float)boxCoords[0]}, {(float)boxCoords[1]}, {(float)boxCoords[2]}};
                            if (this.renderer != null) {
                                ShadowType.adjustFlowToEarth(0, this.workFlowValues, spatial_locs, this.getScale(), this.renderer, true);
                            }
                        }
                        this.workSpatialValues[0][0] = (float)pointOnSymbol.getX();
                        this.workSpatialValues[1][0] = (float)(-pointOnSymbol.getY());
                        try {
                            shapes = metSymbol instanceof WindVectorSymbol ? ((WindVectorSymbol)metSymbol).makeVector(this.workFlowValues, 0.5f, this.workSpatialValues, null, this.workRangeSelect) : WindBarb.staticMakeFlow(this.workFlowValues, 2.5f, this.workSpatialValues, null, this.workRangeSelect, isNorth);
                            this.shapeCache.put(key, ShapeUtility.clone(shapes));
                        }
                        catch (Exception navDisplay) {}
                    }
                } else {
                    shapes = metSymbol.makeShapes(this.workDataArray, ob);
                }
                if (shape != null) {
                    shapes = new VisADGeometryArray[]{shape};
                } else if (shapes == null) continue;
                String scaleParam = metSymbol.getScaleParam();
                if (scaleParam != null && (scaleData = this.getComponent(ob, data, tType, typeNames, scaleParam)) != null) {
                    boolean valueOk = true;
                    double value = 0.0;
                    if (scaleData instanceof Real) {
                        Unit scaleUnit = metSymbol.getScaleUnit();
                        value = scaleUnit != null ? ((Real)scaleData).getValue(scaleUnit) : ((Real)scaleData).getValue();
                    } else {
                        try {
                            value = Double.parseDouble(scaleData.toString());
                        }
                        catch (NumberFormatException nfe) {
                            valueOk = false;
                        }
                    }
                    if (valueOk) {
                        Range dataRange = metSymbol.getScaleDataRange();
                        Range scaleRange = metSymbol.getScaleRange();
                        double percent = dataRange.getPercent(value);
                        if (percent < 0.0) {
                            percent = 0.0;
                        } else if (percent > 1.0) {
                            percent = 1.0;
                        }
                        shapeScaleFactor = (float)((double)shapeScaleFactor * scaleRange.getValueOfPercent(percent));
                    }
                }
                shapeScaleFactor = (float)((double)shapeScaleFactor * metSymbol.getScale());
                Rectangle2D shapeBounds = null;
                for (int shapeIndex = 0; shapeIndex < shapes.length; ++shapeIndex) {
                    if (shapes[shapeIndex] == null) continue;
                    double lat = 90.0 - ob.getEarthLocation().getLatitude().getValue(CommonUnit.degree);
                    double lon = ob.getEarthLocation().getLongitude().getValue(CommonUnit.degree);
                    for (int i = 0; i < RotateInfo.TYPES.length; ++i) {
                        RotateInfo info = metSymbol.getRotateInfo(RotateInfo.TYPES[i]);
                        String rotateParam = info.getParam();
                        if (rotateParam == null) continue;
                        double angle = 0.0;
                        if (rotateParam.startsWith("angle:")) {
                            angle = Math.toRadians(Double.parseDouble(rotateParam.substring(6)));
                        } else {
                            Data rotateData = this.getComponent(ob, data, tType, typeNames, rotateParam);
                            if (rotateData == null || !(rotateData instanceof Real)) continue;
                            Unit rotateUnit = info.getUnit();
                            double value = rotateUnit != null ? ((Real)rotateData).getValue(rotateUnit) : ((Real)rotateData).getValue();
                            Range rotateRange = info.getRange();
                            Range rotateDataRange = info.getDataRange();
                            double percent = Math.min(1.0, Math.max(0.0, rotateDataRange.getPercent(value)));
                            angle = -Math.toRadians(rotateRange.getValueOfPercent(percent));
                        }
                        if (RotateInfo.TYPES[i] == 2) {
                            ShapeUtility.rotateZ(shapes[shapeIndex], (float)angle);
                            continue;
                        }
                        if (RotateInfo.TYPES[i] == 0) {
                            ShapeUtility.rotateX(shapes[shapeIndex], (float)angle);
                            continue;
                        }
                        ShapeUtility.rotateY(shapes[shapeIndex], (float)angle);
                    }
                    shapeBounds = ShapeUtility.bounds2d(shapes[shapeIndex], this.workRect);
                    double tmpScale = shapeScaleFactor;
                    if (metSymbol.shouldScaleShape()) {
                        float size = metSymbol instanceof TextSymbol ? (float)((TextSymbol)metSymbol).getFontSize() / 12.0f : Math.min((float)((double)((float)symbolBounds.width / 20.0f) / shapeBounds.getWidth()), (float)((double)((float)symbolBounds.height / 20.0f) / shapeBounds.getHeight()));
                        tmpScale *= (double)size;
                    }
                    if (this.displayScaleFactor != null) {
                        ShapeUtility.reScale(shapes[shapeIndex], this.displayScaleFactor, (double)shapeScaleFactor);
                    } else {
                        ShapeUtility.reScale(shapes[shapeIndex], (double)shapeScaleFactor);
                    }
                    if (metSymbol.shouldScaleShape()) {
                        shapeBounds = ShapeUtility.bounds2d(shapes[shapeIndex], shapeBounds);
                    }
                    if (shapeIndex == 0) {
                        this.workShapeBounds.setRect(shapeBounds);
                        continue;
                    }
                    this.workShapeBounds = shapeBounds.createUnion(this.workShapeBounds);
                }
                shapeBounds = this.workShapeBounds;
                for (int s = 0; s < shapes.length; ++s) {
                    if (shapes[s] == null) continue;
                    if (metSymbol.shouldOffsetShape()) {
                        Point2D fromPoint = Glyph.getPointOnRect((String)offsetFlipPoints.get(symbolIdx), shapeBounds, this.workPoint);
                        this.workOffsetArray[0] = (float)(pointOnSymbol.getX() * (double)shapeScaleFactor - fromPoint.getX());
                        this.workOffsetArray[1] = (float)(-pointOnSymbol.getY() * (double)shapeScaleFactor - fromPoint.getY());
                        ShapeUtility.offset(shapes[s], this.workOffsetArray);
                    }
                    ShapeUtility.offset(shapes[s], 0.0f, 0.0f, 0.002f);
                    ColorTable ct = metSymbol.getColorTable();
                    String colorParam = metSymbol.getColorParam();
                    String ctParam = metSymbol.getColorTableParam();
                    if (colorParam != null && colorParam.length() > 0) {
                        Data colorData;
                        if (metSymbol.shouldBeColored() && (colorData = this.getComponent(ob, data, tType, typeNames, colorParam)) != null) {
                            List mappings = metSymbol.getColorMappings();
                            Color theColor = metSymbol.getForeground();
                            if (mappings != null && mappings.size() > 0) {
                                for (int i = 0; i < mappings.size(); ++i) {
                                    Color color;
                                    ColorMap colorMap = (ColorMap)mappings.get(i);
                                    if (!colorMap.match(colorData) || (color = colorMap.getColor()) == null) continue;
                                    theColor = color;
                                    break;
                                }
                            } else {
                                String colorString = colorData.toString();
                                theColor = GuiUtils.decodeColor(colorString, null);
                            }
                            if (theColor != null) {
                                ShapeUtility.setColor(shapes[s], theColor);
                            }
                        }
                    } else if (ct == null || ctParam == null || ctParam.length() == 0) {
                        if (metSymbol.shouldBeColored()) {
                            Color theColor = metSymbol.getForeground();
                            if (theColor == null) {
                                theColor = this.myColor;
                            }
                            if (theColor != null) {
                                ShapeUtility.setColor(shapes[s], theColor);
                            }
                        }
                    } else {
                        Data ctData = this.getComponent(ob, data, tType, typeNames, ctParam);
                        if (ctData != null) {
                            Unit ctUnit = metSymbol.getColorTableUnit();
                            double value = 0.0;
                            boolean valueOk = true;
                            if (ctData instanceof Real) {
                                value = ctUnit != null ? ((Real)ctData).getValue(ctUnit) : ((Real)ctData).getValue();
                            } else {
                                try {
                                    value = Double.parseDouble(ctData.toString());
                                }
                                catch (Exception exc) {
                                    valueOk = false;
                                    System.err.println(ctData.toString());
                                }
                            }
                            if (valueOk) {
                                Range r = metSymbol.getColorTableRange();
                                double percent = r.getPercent(value);
                                if (percent < 0.0) {
                                    percent = 0.0;
                                } else if (percent > 1.0) {
                                    percent = 1.0;
                                }
                                ArrayList<Color> colors = ct.getColorList();
                                double dindex = (double)colors.size() * percent;
                                int index = (int)dindex;
                                if (dindex - (double)index >= 0.5) {
                                    ++index;
                                }
                                if (--index < 0) {
                                    index = 0;
                                }
                                ShapeUtility.setColor(shapes[s], (Color)colors.get(index));
                            }
                        }
                    }
                    VisADQuadArray bgshape = null;
                    if (metSymbol.getBackground() != null) {
                        Rectangle2D tmp = ShapeUtility.bounds2d(shapes[s], this.workRect);
                        Rectangle2D.Float bgb = new Rectangle2D.Float((float)tmp.getX(), (float)tmp.getY(), (float)tmp.getWidth(), (float)tmp.getHeight());
                        bgb.x -= bgb.width * 0.05f;
                        bgb.y -= bgb.height * 0.05f;
                        bgb.width += bgb.width * 0.1f;
                        bgb.height += bgb.height * 0.1f;
                        bgshape = new VisADQuadArray();
                        bgshape.coordinates = new float[]{bgb.x, bgb.y, 0.0f, bgb.x, bgb.y + bgb.height, 0.0f, bgb.x + bgb.width, bgb.y + bgb.height, 0.0f, bgb.x + bgb.width, bgb.y, 0.0f};
                        bgshape.vertexCount = bgshape.coordinates.length / 3;
                        bgshape.normals = new float[12];
                        for (int i = 0; i < 12; i += 3) {
                            bgshape.normals[i] = 0.0f;
                            bgshape.normals[i + 1] = 0.0f;
                            bgshape.normals[i + 2] = 1.0f;
                        }
                        ShapeUtility.offset(bgshape, 0.0f, 0.0f, 0.001f);
                        ShapeUtility.setColor((VisADGeometryArray)bgshape, metSymbol.getBackground());
                        quadShapes = this.add(quadShapes, bgshape);
                    }
                    if (this.rotateShapes && this.currentRotation != null && metSymbol.rotateOnEarth()) {
                        for (VisADGeometryArray points : shapes) {
                            ShapeUtility.rotate(points, this.transform);
                        }
                        if (bgshape != null) {
                            ShapeUtility.rotate(bgshape, this.transform);
                        }
                    }
                    if (shapes[s] instanceof VisADLineArray) {
                        lineShapes = this.add(lineShapes, shapes[s]);
                        continue;
                    }
                    if (shapes[s] instanceof VisADQuadArray) {
                        quadShapes = this.add(quadShapes, shapes[s]);
                        continue;
                    }
                    triangleShapes = this.add(triangleShapes, shapes[s]);
                }
            }
        }
        catch (Exception e) {
            throw new WrapperException("Error generating symbol: " + (metSymbol != null ? metSymbol.getName() : ""), e);
        }
        ArrayList<VisADGeometryArray> allShapes = new ArrayList<VisADGeometryArray>();
        if (lineShapes != null) {
            if (lineShapes.size() > 1 && this.tryMerge) {
                try {
                    VisADLineArray[] la = new VisADLineArray[lineShapes.size()];
                    la = lineShapes.toArray(la);
                    allShapes.add(VisADLineArray.merge(la));
                }
                catch (DisplayException exc) {
                    this.tryMerge = false;
                    allShapes.addAll(lineShapes);
                }
            } else {
                allShapes.addAll(lineShapes);
            }
        }
        if (triangleShapes != null) {
            if (triangleShapes.size() > 1 && this.tryMerge) {
                try {
                    VisADTriangleArray[] ta = new VisADTriangleArray[triangleShapes.size()];
                    ta = triangleShapes.toArray(ta);
                    allShapes.add(VisADTriangleArray.merge(ta));
                }
                catch (DisplayException exc) {
                    this.tryMerge = false;
                    allShapes.addAll(triangleShapes);
                }
            } else {
                allShapes.addAll(triangleShapes);
            }
        }
        if (quadShapes != null) {
            allShapes.addAll(quadShapes);
        }
        return allShapes;
    }

    private void paint(Graphics2D g2, List<VisADGeometryArray> shapes) {
        for (VisADGeometryArray array : shapes) {
            GeneralPath path;
            int jinc;
            int j;
            int i;
            int i2;
            int my = this.kmzIconHeight / 2;
            int mx = this.kmzIconWidth / 2;
            float[] pts = array.coordinates;
            int count = array.vertexCount;
            byte[] colors = array.colors;
            if (colors == null) {
                // empty if block
            }
            if (pts == null) {
                // empty if block
            }
            float scale = 200.0f;
            if (array instanceof VisADLineArray) {
                if (colors == null) {
                    g2.setColor(Color.black);
                }
                int jinc2 = colors == null ? 0 : (colors.length == pts.length ? 3 : 4);
                int j2 = 0;
                for (i2 = 0; i2 < 3 * count; i2 += 6) {
                    if (colors != null) {
                        g2.setColor(new Color(((colors[j2] < 0 ? colors[j2] + 256 : colors[j2]) + (colors[j2 + jinc2] < 0 ? colors[j2 + jinc2] + 256 : colors[j2 + jinc2])) / 2, ((colors[j2 + 1] < 0 ? colors[j2 + 1] + 256 : colors[j2 + 1]) + (colors[j2 + jinc2 + 1] < 0 ? colors[j2 + jinc2 + 1] + 256 : colors[j2 + jinc2 + 1])) / 2, ((colors[j2 + 2] < 0 ? colors[j2 + 2] + 256 : colors[j2 + 2]) + (colors[j2 + jinc2 + 2] < 0 ? colors[j2 + jinc2 + 2] + 256 : colors[j2 + jinc2 + 2])) / 2));
                    }
                    j2 += 2 * jinc2;
                    g2.draw(new Line2D.Float((float)mx + scale * pts[i2], (float)my - scale * pts[i2 + 1], (float)mx + scale * pts[i2 + 3], (float)my - scale * pts[i2 + 4]));
                }
                continue;
            }
            if (array instanceof VisADTriangleArray) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                if (colors == null) {
                    for (i = 0; i < 3 * count; i += 9) {
                        GeneralPath path2 = new GeneralPath(0);
                        path2.moveTo((float)mx + scale * pts[i], (float)my - scale * pts[i + 1]);
                        path2.lineTo((float)mx + scale * pts[i + 3], (float)my - scale * pts[i + 4]);
                        path2.lineTo((float)mx + scale * pts[i + 6], (float)my - scale * pts[i + 7]);
                        path2.closePath();
                        g2.fill(path2);
                    }
                    continue;
                }
                j = 0;
                jinc = colors.length == pts.length ? 3 : 4;
                for (i2 = 0; i2 < 3 * count; i2 += 9) {
                    g2.setColor(new Color(((colors[j] < 0 ? colors[j] + 256 : colors[j]) + (colors[j + jinc] < 0 ? colors[j + jinc] + 256 : colors[j + jinc]) + (colors[j + 2 * jinc] < 0 ? colors[j + 2 * jinc] + 256 : colors[j + 2 * jinc])) / 3, ((colors[j + 1] < 0 ? colors[j + 1] + 256 : colors[j + 1]) + (colors[j + jinc + 1] < 0 ? colors[j + jinc + 1] + 256 : colors[j + jinc + 1]) + (colors[j + 2 * jinc + 1] < 0 ? colors[j + 2 * jinc + 1] + 256 : colors[j + 2 * jinc + 1])) / 3, ((colors[j + 2] < 0 ? colors[j + 2] + 256 : colors[j + 2]) + (colors[j + jinc + 2] < 0 ? colors[j + jinc + 2] + 256 : colors[j + jinc + 2]) + (colors[j + 2 * jinc + 2] < 0 ? colors[j + 2 * jinc + 2] + 256 : colors[j + 2 * jinc + 2])) / 3));
                    j += 3 * jinc;
                    path = new GeneralPath(0);
                    path.moveTo((float)mx + scale * pts[i2], (float)my - scale * pts[i2 + 1]);
                    path.lineTo((float)mx + scale * pts[i2 + 3], (float)my - scale * pts[i2 + 4]);
                    path.lineTo((float)mx + scale * pts[i2 + 6], (float)my - scale * pts[i2 + 7]);
                    path.closePath();
                    g2.fill(path);
                }
                continue;
            }
            if (!(array instanceof VisADQuadArray)) continue;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (colors == null) {
                for (i = 0; i < 3 * count; i += 12) {
                    GeneralPath path3 = new GeneralPath(0);
                    path3.moveTo((float)mx + scale * pts[i], (float)my - scale * pts[i + 1]);
                    path3.lineTo((float)mx + scale * pts[i + 3], (float)my - scale * pts[i + 4]);
                    path3.lineTo((float)mx + scale * pts[i + 6], (float)my - scale * pts[i + 7]);
                    path3.lineTo((float)mx + scale * pts[i + 9], (float)my - scale * pts[i + 10]);
                    path3.closePath();
                    g2.fill(path3);
                }
                continue;
            }
            j = 0;
            jinc = colors.length == pts.length ? 3 : 4;
            for (i2 = 0; i2 < 3 * count; i2 += 12) {
                g2.setColor(new Color(((colors[j] < 0 ? colors[j] + 256 : colors[j]) + (colors[j + jinc] < 0 ? colors[j + jinc] + 256 : colors[j + jinc]) + (colors[j + 2 * jinc] < 0 ? colors[j + 2 * jinc] + 256 : colors[j + 2 * jinc]) + (colors[j + 3 * jinc] < 0 ? colors[j + 3 * jinc] + 256 : colors[j + 3 * jinc])) / 4, ((colors[j + 1] < 0 ? colors[j + 1] + 256 : colors[j + 1]) + (colors[j + jinc + 1] < 0 ? colors[j + jinc + 1] + 256 : colors[j + jinc + 1]) + (colors[j + 2 * jinc + 1] < 0 ? colors[j + 2 * jinc + 1] + 256 : colors[j + 2 * jinc + 1]) + (colors[j + 3 * jinc + 1] < 0 ? colors[j + 3 * jinc + 1] + 256 : colors[j + 3 * jinc + 1])) / 4, ((colors[j + 2] < 0 ? colors[j + 2] + 256 : colors[j + 2]) + (colors[j + jinc + 2] < 0 ? colors[j + jinc + 2] + 256 : colors[j + jinc + 2]) + (colors[j + 2 * jinc + 2] < 0 ? colors[j + 2 * jinc + 2] + 256 : colors[j + 2 * jinc + 2]) + (colors[j + 3 * jinc + 2] < 0 ? colors[j + 3 * jinc + 2] + 256 : colors[j + 3 * jinc + 2])) / 4));
                j += 4 * jinc;
                path = new GeneralPath(0);
                path.moveTo((float)mx + scale * pts[i2], (float)my - scale * pts[i2 + 1]);
                path.lineTo((float)mx + scale * pts[i2 + 3], (float)my - scale * pts[i2 + 4]);
                path.lineTo((float)mx + scale * pts[i2 + 6], (float)my - scale * pts[i2 + 7]);
                path.lineTo((float)mx + scale * pts[i2 + 9], (float)my - scale * pts[i2 + 10]);
                path.closePath();
                g2.fill(path);
            }
        }
    }

    private List add(List l, Object o) {
        if (l == null) {
            l = new ArrayList<Object>();
        }
        l.add(o);
        return l;
    }

    @Override
    protected void destroy() throws RemoteException, VisADException {
        if (this.getDestroyed()) {
            return;
        }
        if (this.interp != null) {
            this.jythonManager.removeInterpreter(this.interp);
            this.interp = null;
            this.jythonManager = null;
        }
        super.destroy();
    }

    private Data evaluateCode(PointOb ob, String code, TupleType tType, String[] typeNames, Tuple data, Object formatter, Unit displayUnit) throws VisADException, RemoteException {
        List operands = (List)this.codeToOperands.get(code);
        if (operands == null) {
            operands = DerivedDataChoice.parseOperands(code);
            this.codeToOperands.put(code, operands);
        }
        if (this.interp == null) {
            this.interp = this.jythonManager.createInterpreter();
            this.convertCode = "from ucar.visad.Util import *\n\n";
            this.convertCode = this.convertCode + "def format(v):\n";
            this.convertCode = this.convertCode + "    if formatter is None:\n";
            this.convertCode = this.convertCode + "        return str(v);\n";
            this.convertCode = this.convertCode + "    return formatter.format(v)\n";
            this.convertCode = this.convertCode + "\n\n";
            this.convertCode = this.convertCode + "def convert(v):\n";
            this.convertCode = this.convertCode + "    if displayUnit is None:\n";
            this.convertCode = this.convertCode + "        return v\n";
            this.convertCode = this.convertCode + "    return v.getValue (displayUnit)\n";
            this.convertCode = this.convertCode + "\n\n";
            this.convertCode = this.convertCode + "def formatDate(v,format):\n";
            this.convertCode = this.convertCode + "    return formatUtcDate(v,format)\n";
            this.convertCode = this.convertCode + "\n\n";
            this.interp.exec(this.convertCode);
        }
        this.interp.set("displayUnit", displayUnit);
        this.interp.set("formatter", formatter);
        for (int opIdx = 0; opIdx < operands.size(); ++opIdx) {
            String op = operands.get(opIdx).toString();
            Data opData = this.getComponent(ob, data, tType, typeNames, op);
            if (opData == null) {
                return null;
            }
            this.interp.set(op, opData);
        }
        long t1 = System.currentTimeMillis();
        PyObject pyResult = this.interp.eval(code);
        long t2 = System.currentTimeMillis();
        this.codeTime += t2 - t1;
        Object resultObject = pyResult.__tojava__(Data.class);
        if (resultObject == null || !(resultObject instanceof Data)) {
            resultObject = pyResult.__tojava__(Object.class);
        }
        if (!(resultObject instanceof Data)) {
            resultObject = new Text(resultObject.toString());
        }
        for (int opIdx = 0; opIdx < operands.size(); ++opIdx) {
            this.interp.set(operands.get(opIdx).toString(), null);
        }
        return (Data)resultObject;
    }

    void pr(String msg) {
        System.err.println(msg);
    }

    void pr(String msg, Rectangle2D r) {
        System.err.println(msg + " y1 =" + " " + r.getY() + " cy= " + (r.getY() + r.getHeight() / 2.0) + " y2=" + (r.getY() + r.getHeight()) + " height= " + r.getHeight());
    }

    void pr(String msg, Point2D r) {
        System.err.println(msg + " pt.y= " + r.getY());
    }

    public void setScale(float newScale) throws VisADException, RemoteException {
        if (this.shapeControl != null) {
            this.shapeControl.setAutoScale(false);
            this.shapeControl.setScale(newScale);
            this.shapeControl.setAutoScale(true);
        }
        this.scale = newScale;
    }

    public float getScale() {
        return this.shapeControl != null ? this.shapeControl.getScale() : this.scale;
    }

    private void windVector(float speed, float direction, float[] uv) {
        if (direction > 0.0f && direction <= 360.0f || direction == 0.0f && speed == 0.0f) {
            uv[0] = (float)((double)(-1.0f * speed) * Math.sin((double)direction * (Math.PI / 180)));
            uv[1] = (float)((double)(-1.0f * speed) * Math.cos((double)direction * (Math.PI / 180)));
        } else {
            uv[0] = Float.NaN;
            uv[1] = Float.NaN;
        }
    }

    private int getIndex(String[] typeNames, List names) {
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            if (name.equalsIgnoreCase("lat") || name.equalsIgnoreCase("latitude")) {
                return INDEX_LAT;
            }
            if (name.equalsIgnoreCase("lon") || name.equalsIgnoreCase("longitude")) {
                return INDEX_LON;
            }
            if (name.equalsIgnoreCase("alt") || name.equalsIgnoreCase("altitude")) {
                return INDEX_ALT;
            }
            if (name.equalsIgnoreCase("time") || name.equalsIgnoreCase("dttm")) {
                return INDEX_TIME;
            }
            int index = this.getIndex(typeNames, name);
            if (index != -1) {
                return index;
            }
            List aliases = DataAlias.getAliasesOf(name);
            if (aliases == null || aliases.isEmpty()) continue;
            for (int aliasIdx = 0; aliasIdx < aliases.size(); ++aliasIdx) {
                String alias = (String)aliases.get(aliasIdx);
                index = this.getIndex(typeNames, alias);
                if (index == -1) continue;
                return index;
            }
        }
        return -1;
    }

    private int getIndex(String[] names, String lookingFor) {
        int i;
        if (lookingFor.equals("*")) {
            if (names.length > 0) {
                return 0;
            }
            return -1;
        }
        if (lookingFor.startsWith("#")) {
            int index = new Integer(lookingFor.substring(1));
            if (index < names.length) {
                return index;
            }
            return -1;
        }
        boolean not = false;
        if (lookingFor.startsWith("!")) {
            lookingFor = lookingFor.substring(1);
            not = true;
        }
        if (StringUtil.containsRegExp(lookingFor)) {
            for (i = 0; i < names.length; ++i) {
                if (StringUtil.stringMatch(names[i], lookingFor)) {
                    if (not) continue;
                    return i;
                }
                if (!not) continue;
                return i;
            }
        }
        for (i = 0; i < names.length; ++i) {
            if (names[i].equals(lookingFor)) {
                if (not) continue;
                return i;
            }
            if (!not) continue;
            return i;
        }
        return -1;
    }

    private String[] getTypeNames(TupleType tType) {
        MathType[] comps = tType.getComponents();
        String[] names = new String[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            String name;
            names[i] = name = Util.cleanTypeName(comps[i]);
        }
        return names;
    }

    private Data getComponent(PointOb ob, Tuple data, TupleType tType, String[] typeNames, String commaSeparatedNames) throws VisADException, RemoteException {
        int index;
        Integer cachedIndex;
        List<String> names = this.namesToList.get(commaSeparatedNames);
        if (names == null) {
            names = StringUtil.split(commaSeparatedNames, ",", true, true);
            this.namesToList.put(commaSeparatedNames, names);
        }
        if ((cachedIndex = this.nameToIndex.get(commaSeparatedNames)) != null) {
            index = cachedIndex;
        } else {
            index = this.getIndex(typeNames, names);
            this.nameToIndex.put(commaSeparatedNames, new Integer(index));
        }
        if (index == INDEX_LAT) {
            return ob.getEarthLocation().getLatitude();
        }
        if (index == INDEX_LON) {
            return ob.getEarthLocation().getLongitude();
        }
        if (index == INDEX_ALT) {
            return ob.getEarthLocation().getAltitude();
        }
        if (index == INDEX_TIME) {
            return ob.getDateTime();
        }
        if (index == -1) {
            if (this.haveNotified == null) {
                this.haveNotified = new Hashtable();
            }
            if (this.haveNotified.get(commaSeparatedNames) == null) {
                this.haveNotified.put(commaSeparatedNames, commaSeparatedNames);
                LogUtil.consoleMessage("Unknown field name:" + commaSeparatedNames);
            }
            return null;
        }
        return data.getComponent(index);
    }

    public void setShouldUseAltitude(boolean value) throws VisADException, RemoteException {
        this.shouldUseAltitude = value;
        if (this.stationData != null) {
            this.setStationData(this.stationData);
        }
    }

    public boolean getShouldUseAltitude() {
        return this.shouldUseAltitude;
    }

    @Override
    public void setSelectedRange(double low, double hi) throws VisADException, RemoteException {
        this.lowSelectedRange = low;
        this.highSelectedRange = hi;
        if (this.timeSelectControl != null && this.hasSelectedRange()) {
            this.setTimeColorRange(low, hi);
            this.timeSelectControl.setRange(new double[]{low, hi});
        }
    }

    private void setTimeColorRange(double low, double hi) throws VisADException, RemoteException {
        if (this.stationModel != null) {
            boolean haveTimeColoredShape = false;
            Iterator iter = this.stationModel.iterator();
            while (iter.hasNext()) {
                String colorParam;
                MetSymbol metSymbol = (MetSymbol)iter.next();
                if (!metSymbol.getActive() || !metSymbol.shouldBeColored() || (colorParam = metSymbol.getColorTableParam()) == null || colorParam.length() <= 0 || !colorParam.equalsIgnoreCase("time")) continue;
                haveTimeColoredShape = true;
                metSymbol.setColorTableRange(new Range(low, hi));
            }
            if (haveTimeColoredShape && this.stationData != null) {
                this.setStationData(this.stationData);
            }
        }
    }

    public void setRangeForSelect(double low, double hi) throws VisADException, RemoteException {
        this.minSelect = low;
        this.maxSelect = hi;
        if (this.timeSelectMap != null && this.hasSelectMinMax()) {
            this.timeSelectMap.setRange(low, hi);
        }
    }

    private boolean hasSelectMinMax() {
        return !Double.isNaN(this.minSelect) && !Double.isNaN(this.maxSelect);
    }

    public boolean hasSelectedRange() {
        return !Double.isNaN(this.lowSelectedRange) && !Double.isNaN(this.highSelectedRange);
    }

    public void setRotateShapes(boolean value) {
        this.rotateShapes = value;
    }

    public boolean getRotateShapes() {
        return this.rotateShapes;
    }
}

