/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.awt.Rectangle;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.idv.JythonManager;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.TextSymbol;
import ucar.unidata.ui.symbol.WeatherSymbol;
import ucar.unidata.util.Counter;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.StationModelDisplayable;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.georef.NamedLocation;
import visad.georef.NamedLocationTuple;

public class StationLocationDisplayable
extends StationModelDisplayable {
    static Counter counter = new Counter();
    public static final int ID_ID = 1;
    public static final int ID_NAME = 2;
    public static final int ID_LAT = 3;
    public static final int ID_LON = 4;
    public static final int ID_LATLON = 5;
    public static final int ID_ELEVATION = 6;
    public static final int ID_ELEVATION_FT = 7;
    public static final int[] IDS = new int[]{1, 2, 3, 4, 5, 6, 7};
    public static final String[] ID_NAMES = new String[]{"ID", "Name", "Latitude", "Longitude", "Lat/Lon", "Elevation (m)", "Elevation (ft)"};
    public static final int SYMBOL_NONE = -1;
    public static final int SYMBOL_SQUARE = 0;
    public static final int SYMBOL_FSQUARE = 1;
    public static final int SYMBOL_CIRCLE = 2;
    public static final int SYMBOL_FCIRCLE = 3;
    public static final int SYMBOL_TRIANGLE = 4;
    public static final int SYMBOL_FTRIANGLE = 5;
    public static final int SYMBOL_DIAMOND = 6;
    public static final int SYMBOL_FDIAMOND = 7;
    public static final int SYMBOL_STAR = 8;
    public static final int SYMBOL_FSTAR = 9;
    public static final int SYMBOL_PLUS = 14;
    public static final int[] SYMBOLS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 14};
    public static final String[] SYMBOL_NAMES = new String[]{"Square", "Filled square", "Circle", "Filled circle", "Triangle", "Filled Triangle", "Diamond", "Filled diamond", "Star", "Filled star", "Plus"};
    private Color myColor = null;
    private int symbolType = 9;
    private int idType = 1;
    private List stations;
    private boolean showId;
    private boolean showSymbol;
    private static DecimalFormat format = new DecimalFormat("####.0");

    public StationLocationDisplayable(String name) throws VisADException, RemoteException {
        this(name, 2, true, 1, true);
    }

    public StationLocationDisplayable(String name, int symbolType, boolean showSymbol, int idType, boolean showId) throws VisADException, RemoteException {
        this(name, symbolType, showSymbol, idType, showId, null);
    }

    public StationLocationDisplayable(String name, int symbolType, boolean showSymbol, int idType, boolean showId, JythonManager jythonManager) throws VisADException, RemoteException {
        super(name, jythonManager);
        this.symbolType = symbolType;
        this.showSymbol = showSymbol;
        this.showId = showId;
        this.idType = idType;
        this.setStationModel(this.makeStationModel());
    }

    public StationLocationDisplayable(String name, JythonManager jythonManager) throws VisADException, RemoteException {
        super(name, jythonManager);
    }

    public StationLocationDisplayable(String name, StationModel view) throws VisADException, RemoteException {
        super(name, view);
    }

    @Override
    protected void destroy() throws RemoteException, VisADException {
        if (this.getDestroyed()) {
            return;
        }
        super.destroy();
    }

    public void setDisplayState(int symbolType, boolean showSymbol, int idType, boolean showId) throws VisADException, RemoteException {
        this.symbolType = symbolType;
        this.showSymbol = showSymbol;
        this.showId = showId;
        this.idType = idType;
        this.setStationModel(this.makeStationModel());
        this.updateDisplayable();
    }

    @Override
    public void setColor(Color c) throws VisADException, RemoteException {
        this.myColor = c;
        this.setStationModel(this.makeStationModel());
    }

    public void updateDisplayable() throws VisADException, RemoteException {
        this.setStationData(this.makeStationField(this.stations));
    }

    public void setSymbolType(int value) throws VisADException, RemoteException {
        this.setDisplayState(value, this.showSymbol, this.idType, this.showId);
    }

    public int getSymbolType() {
        return this.symbolType;
    }

    public void setIdType(int value) throws VisADException, RemoteException {
        this.setDisplayState(this.symbolType, this.showId, value, this.showId);
    }

    public int getIdType() {
        return this.idType;
    }

    public void setShowId(boolean value) throws VisADException, RemoteException {
        this.setDisplayState(this.symbolType, this.showSymbol, this.idType, value);
    }

    public boolean getShowId() {
        return this.showId;
    }

    public void setShowSymbol(boolean value) throws VisADException, RemoteException {
        this.setDisplayState(this.symbolType, value, this.idType, this.showId);
    }

    public boolean getShowSymbol() {
        return this.showSymbol;
    }

    public void setStations(List stations) throws VisADException, RemoteException {
        this.stations = stations;
        this.setStationData(this.makeStationField(stations));
    }

    public void setStations(NamedLocation[] stations) throws VisADException, RemoteException {
        this.setStations(this.makeStationList(stations));
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return this;
    }

    private String fmt(Real r) {
        return format.format(r.getValue());
    }

    private String fmt(Real r, Unit u) {
        String retString = "";
        try {
            retString = format.format(r.getValue(u));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retString;
    }

    private FieldImpl makeStationField(List stations) throws RemoteException, VisADException {
        if (stations == null || stations.isEmpty()) {
            return null;
        }
        RealType index = RealType.getRealType("index");
        Real symbolData = new Real(RealType.getRealType("SYMBOL"), (double)this.symbolType);
        Integer1DSet domain = new Integer1DSet((MathType)index, stations.size());
        DateTime bogusTime = new DateTime(Double.NaN);
        FieldImpl stationField = null;
        NamedLocation nlt = null;
        ArrayList<String> attrNames = new ArrayList<String>();
        ArrayList<TextType> attrTypes = new ArrayList<TextType>();
        if (stations.size() > 0) {
            NamedStationImpl station = (NamedStationImpl)stations.get(0);
            Hashtable properties = station.getProperties();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String attrName = (String)keys.nextElement();
                attrNames.add(attrName);
                attrName = Util.cleanName(attrName);
                int cnt = 0;
                TextType type = TextType.getTextType(attrName);
                while (type == null) {
                    type = TextType.getTextType(attrName + "_" + ++cnt);
                    if (cnt <= 1000) continue;
                }
                attrTypes.add(type);
            }
        }
        Data[] firstData = null;
        Trace.call1("make field", " stations:" + stations.size());
        for (int i = 0; i < stations.size(); ++i) {
            Text idData = null;
            String idString = " ";
            NamedStationImpl station = (NamedStationImpl)stations.get(i);
            nlt = station.getNamedLocation();
            switch (this.idType) {
                case 1: {
                    idData = nlt.getIdentifier();
                    break;
                }
                case 2: {
                    idString = station.getName();
                    break;
                }
                case 3: {
                    idString = this.fmt(nlt.getLatitude());
                    break;
                }
                case 4: {
                    idString = this.fmt(nlt.getLongitude());
                    break;
                }
                case 5: {
                    idString = this.fmt(nlt.getLatitude()) + "/" + this.fmt(nlt.getLongitude());
                    break;
                }
                case 6: {
                    idString = this.fmt(nlt.getAltitude(), CommonUnit.meter);
                    break;
                }
                case 7: {
                    idString = this.fmt(nlt.getAltitude(), CommonUnits.FOOT);
                }
            }
            if (idData == null) {
                idData = new Text(NamedLocationTuple.IDENTIFIER_TYPE, idString);
            }
            Data[] theData = new Data[2 + attrNames.size()];
            if (firstData == null) {
                firstData = theData;
            }
            theData[0] = idData;
            theData[1] = symbolData;
            Hashtable properties = station.getProperties();
            for (int attrIdx = 0; attrIdx < attrNames.size(); ++attrIdx) {
                int arrayIndex = 2 + attrIdx;
                Object attrValue = properties.get(attrNames.get(attrIdx));
                if (attrValue == null && firstData[arrayIndex] instanceof Real) {
                    Real firstReal = (Real)firstData[arrayIndex];
                    theData[arrayIndex] = new Real((RealType)firstReal.getType(), Double.NaN, firstReal.getUnit());
                    continue;
                }
                if (attrValue == null) {
                    attrValue = " ";
                }
                if (attrValue instanceof Real) {
                    theData[arrayIndex] = (Real)attrValue;
                    continue;
                }
                TextType textType = (TextType)attrTypes.get(attrIdx);
                theData[arrayIndex] = new Text(textType, attrValue.toString());
                continue;
            }
            PointObTuple pot = new PointObTuple(nlt, bogusTime, new Tuple(theData, false));
            if (i == 0) {
                stationField = new FieldImpl(new FunctionType(index, pot.getType()), domain);
            }
            stationField.setSample(i, pot, false, false);
        }
        Trace.call2("make field");
        return stationField;
    }

    private StationModel makeStationModel() {
        StationModel obView = new StationModel("StationLocation");
        TextSymbol idSymbol = new TextSymbol(NamedLocationTuple.IDENTIFIER_TYPE.getName(), "Station ID");
        WeatherSymbol symbolSymbol = new WeatherSymbol(0, 0, "SYMBOL", "SYMBOL");
        if (this.myColor != null) {
            symbolSymbol.setForeground(this.myColor);
            idSymbol.setForeground(this.myColor);
        }
        symbolSymbol.setSymbolType(9);
        symbolSymbol.bounds = new Rectangle(-12, -12, 24, 24);
        symbolSymbol.setRectPoint("MM");
        if (this.showId) {
            obView.addSymbol(idSymbol);
        }
        if (this.showSymbol) {
            obView.addSymbol(symbolSymbol);
        }
        if (this.showSymbol && this.showId) {
            idSymbol.bounds = new Rectangle(-11, -31, 72, 24);
            idSymbol.setRectPoint("LM");
        } else if (this.showId) {
            idSymbol.bounds = new Rectangle(-11, -8, 72, 24);
            idSymbol.setRectPoint("MM");
        } else if (this.showSymbol) {
            // empty if block
        }
        return obView;
    }

    private List makeStationList(NamedLocation[] stations) {
        ArrayList<NamedStationImpl> list = new ArrayList<NamedStationImpl>(stations.length);
        for (int i = 0; i < stations.length; ++i) {
            list.add(new NamedStationImpl(stations[i].getIdentifier().getValue(), (NamedLocationTuple)stations[i]));
        }
        return list;
    }
}

