/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.ShapeUtility;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.Display;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.ShapeControl;
import visad.VisADException;
import visad.VisADGeometryArray;

public class ShapeDisplayable
extends LineDrawing {
    private RealTuple thePoint;
    private VisADGeometryArray marker;
    private VisADGeometryArray[] markers;
    private ScalarMap shapeMap = null;
    private RealType shapeType = null;
    private ShapeControl shapeControl = null;
    private static int count = 0;
    private int dimension;
    private Real markerValue;
    private boolean autoSize;
    private float pointSize = 1.0f;

    public ShapeDisplayable(String name, VisADGeometryArray marker) throws VisADException, RemoteException {
        this(name, marker, new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{0.0, 0.0, 0.0}));
    }

    public ShapeDisplayable(String name, RealTupleType pointType) throws VisADException, RemoteException {
        this(name, new RealTuple(pointType));
    }

    public ShapeDisplayable(String name, RealTuple initialValue) throws VisADException, RemoteException {
        this(name, ShapeDisplayable.reduce(ShapeUtility.makeShape("CUBE")), initialValue);
    }

    public ShapeDisplayable(String name, String markerText) throws VisADException, RemoteException {
        this(name, ShapeUtility.shapeText(markerText));
    }

    public ShapeDisplayable(String name, String markerText, RealTuple initialValue) throws VisADException, RemoteException {
        this(name, ShapeUtility.shapeText(markerText), initialValue);
    }

    public ShapeDisplayable(String name, VisADGeometryArray marker, RealTuple initialValue) throws VisADException, RemoteException {
        super(name);
        this.thePoint = initialValue;
        this.dimension = this.thePoint.getDimension();
        this.marker = marker == null ? ShapeDisplayable.reduce(ShapeUtility.makeShape("CUBE")) : marker;
        this.setupShapeMap();
        this.markerValue = new Real(this.shapeType, 0.0);
        this.mySetData(this.thePoint);
    }

    public void setPoint(RealTuple value) throws VisADException, RemoteException {
        if (!this.thePoint.getType().equals(value.getType())) {
            throw new VisADException("Invalid type for value");
        }
        this.thePoint = value;
        this.mySetData(value);
    }

    public ShapeDisplayable(ShapeDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.thePoint = that.getPoint();
        this.setData(that.getPoint());
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new ShapeDisplayable(this);
    }

    public RealTuple getPoint() {
        return this.thePoint;
    }

    public void setMarker(String markerText) throws VisADException, RemoteException {
        this.setMarker(ShapeUtility.shapeText(markerText));
    }

    public void setMarker(VisADGeometryArray marker, double x, double y, double z) throws VisADException, RemoteException {
        RealTuple loc = new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{x, y, z});
        this.setMarker(marker);
        this.setPoint(loc);
    }

    public void setPoint(double x, double y, double z) throws VisADException, RemoteException {
        RealTuple loc = new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{x, y, z});
        this.setPoint(loc);
    }

    public void setMarker(VisADGeometryArray marker) throws VisADException, RemoteException {
        if (this.shapeControl != null) {
            this.shapeControl.setShape(0, marker);
        }
        this.marker = marker;
    }

    public void setMarker(VisADGeometryArray[] marker) throws VisADException, RemoteException {
        if (this.shapeControl != null) {
            this.shapeControl.setShapes(marker);
        }
        this.markers = marker;
    }

    @Override
    public void setPointSize(float newSize) throws VisADException, RemoteException {
        if (this.shapeControl != null && newSize != this.pointSize) {
            this.shapeControl.setScale(newSize);
        }
        this.pointSize = newSize;
    }

    public float getScale() {
        return this.shapeControl != null ? this.shapeControl.getScale() : this.pointSize;
    }

    public VisADGeometryArray getMarker() {
        return this.marker;
    }

    public void setAutoSize(boolean yesorno) throws VisADException, RemoteException {
        if (this.shapeControl != null) {
            this.shapeControl.setAutoScale(this.autoSize);
        }
        this.autoSize = yesorno;
    }

    public boolean getAutoSize() {
        return this.autoSize;
    }

    @Override
    protected void dataChange() throws VisADException, RemoteException {
        RealTuple data = (RealTuple)this.getData();
        Real[] pointVals = new Real[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            pointVals[i] = (Real)data.getComponent(i);
        }
        this.thePoint = new RealTuple(pointVals);
        super.dataChange();
    }

    private void setShapesInControl() throws VisADException, RemoteException {
        if (this.shapeControl != null) {
            this.shapeControl.setShapeSet(new Integer1DSet((MathType)this.shapeType, 1));
            if (this.marker != null) {
                this.shapeControl.setShapeSet(new Integer1DSet((MathType)this.shapeType, 1));
                this.shapeControl.setShapes(new VisADGeometryArray[]{this.marker});
            } else if (this.markers != null) {
                this.shapeControl.setShapeSet(new Integer1DSet((MathType)this.shapeType, this.markers.length));
                this.shapeControl.setShapes(this.markers);
            }
        }
    }

    private void mySetData(RealTuple value) throws VisADException, RemoteException {
        int size = value.getDimension();
        Real[] data = new Real[size + 1];
        for (int i = 0; i < value.getDimension(); ++i) {
            data[i] = (Real)value.getComponent(i);
        }
        data[size] = this.markerValue;
        this.setData(new RealTuple(data));
    }

    public static VisADGeometryArray reduce(VisADGeometryArray marker) {
        return ShapeUtility.setSize(marker, 0.02f);
    }

    private void setupShapeMap() throws VisADException, RemoteException {
        this.shapeType = RealType.getRealType("ShapeDisplayable_" + count++);
        this.shapeMap = new ScalarMap(this.shapeType, Display.Shape);
        this.shapeMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    ShapeDisplayable.this.shapeControl = (ShapeControl)ShapeDisplayable.this.shapeMap.getControl();
                    if (ShapeDisplayable.this.shapeControl != null) {
                        ShapeDisplayable.this.setShapesInControl();
                        ShapeDisplayable.this.shapeControl.setScale(ShapeDisplayable.this.pointSize);
                        ShapeDisplayable.this.shapeControl.setAutoScale(ShapeDisplayable.this.autoSize);
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
            }
        });
        this.addScalarMap(this.shapeMap);
    }

    public RealType getShapeType() {
        return this.shapeType;
    }
}

