/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import java.util.List;
import ucar.visad.ShapeUtility;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.Data;
import visad.Display;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.ShapeControl;
import visad.VisADException;
import visad.VisADGeometryArray;

public class SelectorPoint
extends LineDrawing {
    private RealTuple thePoint;
    private VisADGeometryArray marker;
    private ScalarMap shapeMap = null;
    private RealType shapeType = null;
    private ShapeControl shapeControl = null;
    private static int count = 0;
    private int dimension;
    private Real markerValue;
    private boolean autoSize;
    private float pointSize = 1.0f;
    private boolean[] fixed = new boolean[]{false, false, false};

    public SelectorPoint(String name, RealTupleType pointType) throws VisADException, RemoteException {
        this(name, new RealTuple(pointType));
    }

    public SelectorPoint(String name, RealTuple initialValue) throws VisADException, RemoteException {
        this(name, SelectorPoint.reduce(ShapeUtility.createShape("CUBE")[0]), initialValue);
    }

    public SelectorPoint(String name, String markerText, RealTuple initialValue) throws VisADException, RemoteException {
        this(name, ShapeUtility.shapeText(markerText), initialValue);
    }

    public SelectorPoint(String name, VisADGeometryArray marker, RealTuple initialValue) throws VisADException, RemoteException {
        super(name);
        this.setManipulable(true);
        this.thePoint = initialValue;
        this.dimension = this.thePoint.getDimension();
        this.marker = marker == null ? SelectorPoint.reduce(ShapeUtility.createShape("CUBE")[0]) : marker;
        this.setupShapeMap();
        this.markerValue = new Real(this.shapeType, 0.0);
        this.mySetData(this.thePoint, null);
    }

    @Override
    public Set getAnimationSet(RealType aniType, boolean force) throws VisADException, RemoteException {
        return null;
    }

    public void setFixed(boolean x, boolean y, boolean z) {
        this.fixed[0] = x;
        this.fixed[1] = y;
        this.fixed[2] = z;
    }

    public void setPoint(RealTuple value) throws VisADException, RemoteException {
        this.setPointWithTime(value, null);
    }

    public void setPoint(RealTuple value, VisADGeometryArray marker) throws VisADException, RemoteException {
        this.marker = marker;
        if (this.shapeControl != null) {
            this.shapeControl.setShape(0, marker);
        }
        this.setPointWithTime(value, null);
    }

    public void setPointWithTime(RealTuple value, List times) throws VisADException, RemoteException {
        if (!this.thePoint.getType().equals(value.getType())) {
            throw new VisADException("Invalid type for value: mytype=" + this.thePoint.getType() + " new type=" + value.getType());
        }
        this.thePoint = value;
        this.mySetData(value, times);
    }

    public SelectorPoint(SelectorPoint that) throws VisADException, RemoteException {
        super(that);
        this.thePoint = that.getPoint();
        this.setData(that.getPoint());
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new SelectorPoint(this);
    }

    public RealTuple getPoint() {
        return this.thePoint;
    }

    public void setMarker(String markerText) throws VisADException, RemoteException {
        this.setMarker(ShapeUtility.shapeText(markerText));
    }

    public void setMarker(VisADGeometryArray marker) throws VisADException, RemoteException {
        if (this.shapeControl != null) {
            this.shapeControl.setShape(0, marker);
        }
        this.marker = marker;
    }

    @Override
    public void setPointSize(float newSize) throws VisADException, RemoteException {
        if (this.shapeControl != null && newSize != this.pointSize) {
            this.shapeControl.setScale(newSize);
        }
        this.pointSize = newSize;
    }

    public void setScale(float newScale) throws VisADException, RemoteException {
        if (this.shapeControl != null) {
            this.shapeControl.setAutoScale(false);
            this.shapeControl.setScale(newScale);
            this.shapeControl.setAutoScale(true);
        }
    }

    public float getScale() {
        return this.shapeControl != null ? this.shapeControl.getScale() : this.pointSize;
    }

    public VisADGeometryArray getMarker() {
        return this.marker;
    }

    public void setAutoSize(boolean yesorno) throws VisADException, RemoteException {
        this.autoSize = yesorno;
        if (this.shapeControl != null) {
            this.shapeControl.setAutoScale(this.autoSize);
        }
    }

    public boolean getAutoSize() {
        return this.autoSize;
    }

    @Override
    protected void dataChange() throws VisADException, RemoteException {
        Data currentData = this.getData();
        if (!(currentData instanceof RealTuple)) {
            return;
        }
        RealTuple data = (RealTuple)currentData;
        Real[] pointVals = new Real[this.dimension];
        double[] oldValues = null;
        RealTuple currentPoint = this.thePoint;
        if (currentPoint != null && !currentPoint.isMissing()) {
            oldValues = currentPoint.getValues();
        }
        boolean didChange = false;
        for (int i = 0; i < this.dimension; ++i) {
            Real v = (Real)data.getComponent(i);
            if (v != null && oldValues != null && this.fixed != null && i < this.fixed.length && this.fixed[i] && v.getValue() != oldValues[i]) {
                didChange = true;
                v = v.cloneButValue(oldValues[i]);
            }
            pointVals[i] = v;
        }
        this.thePoint = new RealTuple(pointVals);
        if (didChange) {
            this.setPoint(this.thePoint);
        }
        super.dataChange();
    }

    private void setShapesInControl() throws VisADException, RemoteException {
        if (this.shapeControl != null && this.marker != null) {
            this.shapeControl.setShapeSet(new Integer1DSet((MathType)this.shapeType, 1));
            this.shapeControl.setShapes(new VisADGeometryArray[]{this.marker});
        }
    }

    private void mySetData(RealTuple value, List times) throws VisADException, RemoteException {
        int size = value.getDimension();
        Real[] data = new Real[size + 1];
        for (int i = 0; i < value.getDimension(); ++i) {
            data[i] = (Real)value.getComponent(i);
        }
        data[size] = this.markerValue;
        this.setData(Util.makeTimeRangeField(new RealTuple(data), times));
    }

    public static VisADGeometryArray reduce(VisADGeometryArray marker) {
        return ShapeUtility.setSize(marker, 0.02f);
    }

    private void setupShapeMap() throws VisADException, RemoteException {
        this.shapeType = RealType.getRealType("Selector_Point_" + count++);
        this.shapeMap = new ScalarMap(this.shapeType, Display.Shape);
        this.shapeMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    SelectorPoint.this.shapeControl = (ShapeControl)SelectorPoint.this.shapeMap.getControl();
                    if (SelectorPoint.this.shapeControl != null) {
                        SelectorPoint.this.setShapesInControl();
                        SelectorPoint.this.shapeControl.setScale(SelectorPoint.this.pointSize);
                        SelectorPoint.this.shapeControl.setAutoScale(SelectorPoint.this.autoSize);
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
            }
        });
        this.addScalarMap(this.shapeMap);
    }
}

