/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.Displayable;
import ucar.visad.display.ScalarMapSet;
import visad.Display;
import visad.RangeControl;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Unit;
import visad.VisADException;

public class SelectRangeDisplayable
extends Displayable {
    private double lowSelectedRange = Double.NaN;
    private double highSelectedRange = Double.NaN;
    private ScalarMap selectMap = null;
    private RangeControl selectControl;
    private RealType selectRealType = null;
    private double minSelect = Double.NaN;
    private double maxSelect = Double.NaN;

    public SelectRangeDisplayable() throws VisADException, RemoteException {
        this((RealType)null);
    }

    public SelectRangeDisplayable(RealType rangeType) throws VisADException, RemoteException {
        if (rangeType != null) {
            this.selectRealType = rangeType;
            this.setSelectRangeMap();
        }
    }

    protected SelectRangeDisplayable(SelectRangeDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.lowSelectedRange = that.lowSelectedRange;
        this.highSelectedRange = that.highSelectedRange;
        this.minSelect = that.minSelect;
        this.maxSelect = that.maxSelect;
        if (that.getSelectRealType() != null) {
            this.setSelectRealType(that.getSelectRealType());
        }
    }

    public void setSelectRealType(RealType realType) throws RemoteException, VisADException {
        if (!realType.equals(this.selectRealType)) {
            RealType oldValue = this.selectRealType;
            this.selectRealType = realType;
            this.setSelectRangeMap();
        }
    }

    public RealType getSelectRealType() {
        return this.selectRealType;
    }

    @Override
    public final void myAddDataReferences() {
    }

    @Override
    public final void myRemoveDataReferences() {
    }

    public boolean hasSelectedRange() {
        return !Double.isNaN(this.lowSelectedRange) && !Double.isNaN(this.highSelectedRange);
    }

    private boolean hasSelectMinMax() {
        return !Double.isNaN(this.minSelect) && !Double.isNaN(this.maxSelect);
    }

    @Override
    public void setSelectedRange(double low, double hi) throws VisADException, RemoteException {
        this.lowSelectedRange = low;
        this.highSelectedRange = hi;
        if (this.selectControl != null && this.hasSelectedRange()) {
            this.selectControl.setRange(new double[]{low, hi});
        }
    }

    @Override
    public void setDisplayUnit(Unit unit) throws VisADException, RemoteException {
        super.setDisplayUnit(unit);
        this.applyDisplayUnit(this.selectMap, this.selectRealType);
    }

    private void setSelectRangeMap() throws RemoteException, VisADException {
        this.selectMap = new ScalarMap(this.selectRealType, Display.SelectRange);
        this.applyDisplayUnit(this.selectMap, this.selectRealType);
        if (this.hasSelectMinMax()) {
            this.selectMap.setRange(this.minSelect, this.maxSelect);
        }
        this.selectMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    SelectRangeDisplayable.this.selectControl = (RangeControl)SelectRangeDisplayable.this.selectMap.getControl();
                    if (SelectRangeDisplayable.this.hasSelectedRange() && SelectRangeDisplayable.this.selectControl != null) {
                        SelectRangeDisplayable.this.selectControl.setRange(new double[]{SelectRangeDisplayable.this.lowSelectedRange, SelectRangeDisplayable.this.highSelectedRange});
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
                if (event.getId() == 1 && SelectRangeDisplayable.this.hasSelectMinMax()) {
                    SelectRangeDisplayable.this.selectMap.setRange(SelectRangeDisplayable.this.minSelect, SelectRangeDisplayable.this.maxSelect);
                }
            }
        });
        ScalarMapSet maps = this.getScalarMapSet();
        maps.add(this.selectMap);
        this.setScalarMapSet(maps);
    }

    public void setRangeForSelect(double low, double hi) throws VisADException, RemoteException {
        this.minSelect = low;
        this.maxSelect = hi;
        if (this.selectMap != null && this.hasSelectMinMax()) {
            this.selectMap.setRange(low, hi);
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new SelectRangeDisplayable(this);
    }
}

