/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import visad.ScalarMap;
import visad.ScalarType;

public class ScalarMapSet {
    private final TreeMap maps = new TreeMap();

    public ScalarMapSet() {
    }

    public ScalarMapSet(ScalarMapSet that) {
        Iterator iter = that.maps.values().iterator();
        while (iter.hasNext()) {
            this.myAdd((ScalarMap)iter.next());
        }
    }

    public ScalarMapSet(Collection col) {
        this.myAdd(col);
    }

    public ScalarMap add(ScalarMap map) {
        return this.myAdd(map);
    }

    private synchronized ScalarMap myAdd(ScalarMap map) {
        return this.maps.put(new Key(map), map);
    }

    public void add(ScalarMapSet that) {
        this.myAdd(that);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void myAdd(ScalarMapSet that) {
        ScalarMapSet scalarMapSet = that;
        synchronized (scalarMapSet) {
            this.maps.putAll(that.maps);
        }
    }

    public void add(Collection col) {
        this.myAdd(col);
    }

    private synchronized void myAdd(Collection col) {
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            this.myAdd((ScalarMap)iter.next());
        }
    }

    public ScalarMap get(ScalarMap template) {
        return this.myGet(template);
    }

    private synchronized ScalarMap myGet(ScalarMap template) {
        return (ScalarMap)this.maps.get(new Key(template));
    }

    public synchronized boolean remove(ScalarMap map) {
        return this.maps.remove(new Key(map)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(ScalarMapSet that) {
        ScalarMapSet scalarMapSet = that;
        synchronized (scalarMapSet) {
            Iterator iter = that.iterator();
            while (iter.hasNext()) {
                this.remove((ScalarMap)iter.next());
            }
        }
    }

    public synchronized void removeAll() {
        this.maps.clear();
    }

    public int size() {
        return this.mySize();
    }

    private synchronized int mySize() {
        return this.maps.size();
    }

    public synchronized void clear() {
        this.maps.clear();
    }

    public Iterator iterator() {
        return this.myIterator();
    }

    private Iterator myIterator() {
        return this.maps.values().iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScalarMapSet)) {
            return false;
        }
        return this.maps.equals(((ScalarMapSet)obj).maps);
    }

    public int hashCode() {
        return this.maps.hashCode();
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName() + "{");
        boolean first = true;
        Iterator iter = this.myIterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(((ScalarMap)iter.next()).toString());
        }
        buf.append("}");
        return buf.toString();
    }

    public static ScalarMapSet combine(ScalarMapSet set1, ScalarMapSet set2) {
        ScalarMapSet set = new ScalarMapSet();
        set.myAdd(set1);
        set.myAdd(set2);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScalarMapSet subtract(ScalarMapSet set1, ScalarMapSet set2) {
        ScalarMapSet result = new ScalarMapSet();
        ScalarMapSet scalarMapSet = set1;
        synchronized (scalarMapSet) {
            ScalarMapSet scalarMapSet2 = set2;
            synchronized (scalarMapSet2) {
                Iterator iter = set1.myIterator();
                while (iter.hasNext()) {
                    ScalarMap map = (ScalarMap)iter.next();
                    if (set2.myGet(map) != null) continue;
                    result.myAdd(map);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScalarMapSet intersect(ScalarMapSet set1, ScalarMapSet set2) {
        ScalarMapSet result = new ScalarMapSet();
        ScalarMapSet scalarMapSet = set1;
        synchronized (scalarMapSet) {
            ScalarMapSet scalarMapSet2 = set2;
            synchronized (scalarMapSet2) {
                if (set1.mySize() > set2.mySize()) {
                    ScalarMapSet tmp = set1;
                    set1 = set2;
                    set2 = tmp;
                }
                Iterator iter = set1.myIterator();
                while (iter.hasNext()) {
                    ScalarMap map = (ScalarMap)iter.next();
                    if (set2.myGet(map) == null) continue;
                    result.myAdd(map);
                }
            }
        }
        return result;
    }

    private static class Key
    implements Comparable {
        private final String scalarName;
        private final String displayName;

        Key(ScalarMap map) {
            this.displayName = map.getDisplayScalar().getOriginalName();
            ScalarType scalar = map.getScalar();
            this.scalarName = scalar == null ? this.displayName : scalar.getOriginalName();
        }

        public int compareTo(Object obj) {
            Key that = (Key)obj;
            int cmp = this.scalarName.compareTo(that.scalarName);
            if (cmp == 0) {
                cmp = this.displayName.compareTo(that.displayName);
            }
            return cmp;
        }
    }
}

