/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.DataRenderer;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.bom.RubberBandBoxRendererJ3D;

public class RubberBandBox
extends LineDrawing {
    private RealType xType;
    private RealType yType;
    private RubberBandBoxRendererJ3D rubberBandBox;
    private Gridded2DSet bounds;
    private int mask;

    public RubberBandBox(RealType xType, RealType yType) throws VisADException, RemoteException {
        this(xType, yType, 0);
    }

    public RubberBandBox(RealType xType, RealType yType, int mask) throws VisADException, RemoteException {
        super("Rubber Band Box");
        this.xType = xType;
        this.yType = yType;
        this.mask = mask;
        this.bounds = new Gridded2DSet((MathType)new RealTupleType(xType, yType), (float[][])null, 1);
        this.setData(this.bounds);
    }

    protected RubberBandBox(RubberBandBox that) throws VisADException, RemoteException {
        super(that);
        this.xType = that.xType;
        this.yType = that.yType;
        this.bounds = that.bounds;
    }

    @Override
    protected void dataChange() throws VisADException, RemoteException {
        this.bounds = (Gridded2DSet)this.getData();
        super.dataChange();
    }

    public Gridded2DSet getBounds() {
        return this.bounds;
    }

    @Override
    protected DataRenderer getDataRenderer() {
        this.rubberBandBox = new RubberBandBoxRendererJ3D(this.xType, this.yType, this.mask, this.mask);
        return this.rubberBandBox;
    }

    public void reSetBounds() {
        try {
            this.bounds = new Gridded2DSet((MathType)new RealTupleType(this.xType, this.yType), (float[][])null, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new RubberBandBox(this);
    }
}

