/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.visad.display.Displayable;
import ucar.visad.display.PolarLineDrawing;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Linear1DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.TypeException;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;

public class RingSet
extends PolarLineDrawing {
    public RingSet(String name, RealTupleType polarType) throws RemoteException, VisADException {
        this(name, polarType, Color.white);
    }

    public RingSet(String name, RealTupleType polarType, Color color) throws RemoteException, VisADException {
        super(name, polarType);
        this.setColor(color);
    }

    protected RingSet(RingSet that) throws RemoteException, VisADException {
        super(that);
    }

    public void setRingValues(Linear1DSet ringValues) throws VisADException, RemoteException {
        RealType realType = (RealType)((SetType)ringValues.getType()).getDomain().getComponent(0);
        Unit unit = ringValues.getSetUnits()[0];
        this.setRingValues(new Real(realType, ringValues.getStep(), unit), new Real(realType, ringValues.getHiX(), unit));
    }

    public void setRingValues(Real rangeInc, Real rangeMax) throws VisADException, RemoteException {
        RealType rangeType = this.getRangeType();
        Unit unit = rangeType.getDefaultUnit();
        double inc = rangeInc.getValue(unit);
        double max = rangeMax.getValue(unit);
        this.setData(RingSet.newUnionSet(this.getPolarType(), new Linear1DSet((MathType)rangeType, inc, max, (int)Math.round(max / inc))));
    }

    public static SampledSet newUnionSet(RealTupleType polarType, Gridded1DSet values) throws VisADException, RemoteException {
        int bearingIndex = RingSet.getBearingIndex(polarType);
        int rangeIndex = 1 - bearingIndex;
        int ringCount = values.getLength(0);
        SampledSet[] rings = new SampledSet[ringCount];
        float[][] samples = new float[][]{new float[361], new float[361]};
        float[] bearings = samples[bearingIndex];
        int j = bearings.length;
        while (--j >= 0) {
            bearings[j] = j;
        }
        float[] ranges = samples[rangeIndex];
        Unit[] units = new Unit[2];
        units[bearingIndex] = CommonUnit.degree;
        units[rangeIndex] = values.getSetUnits()[0];
        int[] indexes = new int[1];
        for (int i = 0; i < ringCount; ++i) {
            indexes[0] = i;
            Arrays.fill(ranges, values.indexToValue(indexes)[0][0]);
            rings[i] = new Gridded2DSet((MathType)polarType, (float[][])samples, ranges.length, (CoordinateSystem)null, units, (ErrorEstimate[])null);
        }
        return new UnionSet((MathType)polarType, rings);
    }

    public void setRingValues(RingSet that) throws TypeException, VisADException, RemoteException {
        if (!this.getPolarType().equals(that.getPolarType())) {
            throw new TypeException(this.getClass().getName() + ".setRingValues(RingSet): " + "Type of other RingSet doesn't match this one");
        }
        this.setData(that.getData());
    }

    public void addScalarMaps(LocalDisplay display) {
    }

    @Override
    public synchronized Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new RingSet(this);
    }
}

