/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Arrays;
import ucar.visad.display.PolarLineDrawing;
import ucar.visad.display.TextDisplayable;
import visad.CommonUnit;
import visad.Contour2D;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Scalar;
import visad.ScalarType;
import visad.SetType;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Unit;
import visad.VisADException;

public class RingLabels
extends TextDisplayable {
    Real bearing = null;
    RealType bearingType;
    RealType rangeType;
    RealTupleType polarType;
    Gridded1DSet values = null;
    Unit labelUnit = null;

    public RingLabels(String name, RealTupleType polarType, Color color) throws RemoteException, VisADException {
        this(name, polarType, new Real((RealType)polarType.getComponent(PolarLineDrawing.getBearingIndex(polarType)), 0.0), color);
    }

    public RingLabels(String name, RealTupleType polarType, Real bearing, Color color) throws RemoteException, VisADException {
        super(RealType.getRealType(name));
        this.polarType = polarType;
        this.bearingType = (RealType)polarType.getComponent(PolarLineDrawing.getBearingIndex(polarType));
        this.rangeType = (RealType)polarType.getComponent(1 - PolarLineDrawing.getBearingIndex(polarType));
        this.bearing = bearing;
        this.labelUnit = this.rangeType.getDefaultUnit();
        this.createLabels();
        this.setColor(color);
    }

    public void setLabelUnit(Unit unit) throws VisADException, RemoteException {
        this.labelUnit = unit;
        this.createLabels();
    }

    public Unit getLabelUnit() {
        return this.labelUnit;
    }

    public void setLabelValues(Gridded1DSet labelValues) throws VisADException, RemoteException {
        if (labelValues != null && this.rangeType.equals(((SetType)labelValues.getType()).getDomain())) {
            throw new VisADException("labelValue set not compatible with this object's range type");
        }
        this.values = labelValues;
        this.createLabels();
    }

    public void setLabelValues(float[] values) throws VisADException, RemoteException {
        this.setLabelValues(values, this.labelUnit);
    }

    public void setLabelValues(float[] values, Unit units) throws VisADException, RemoteException {
        this.setLabelValues(new Gridded1DSet((MathType)this.rangeType, (float[][])new float[][]{values}, values.length, (CoordinateSystem)null, new Unit[]{units}, (ErrorEstimate[])null));
    }

    public void setLabelValues(Real rangeInc, Real rangeMax) throws VisADException, RemoteException {
        float min = (float)rangeInc.getValue(this.labelUnit);
        float[] values = Contour2D.intervalToLevels(min, min, (float)rangeMax.getValue(this.labelUnit), min, new boolean[]{false});
        if (values != null) {
            this.setLabelValues(values, this.labelUnit);
        } else {
            this.setLabelValues((Gridded1DSet)null);
        }
    }

    public void setLabelPosition(Real bearing) throws VisADException, RemoteException {
        if (!Unit.canConvert(bearing.getUnit(), CommonUnit.degree)) {
            throw new VisADException("bearing units not compatible with this object's bearing type");
        }
        this.bearing = bearing;
        this.createLabels();
    }

    private void createLabels() throws VisADException, RemoteException {
        Unit[] unitArray;
        float[][] fArrayArray;
        if (this.values == null || this.bearing == null) {
            this.setData(new SingletonSet(new RealTuple(this.polarType)));
            return;
        }
        float bear = (float)this.bearing.getValue(this.bearingType.getDefaultUnit());
        int numLabels = this.values.getLength();
        float[][] ranges = Unit.convertTuple(this.values.getSamples(), this.values.getSetUnits(), new Unit[]{this.labelUnit});
        float[] bearings = new float[numLabels];
        Arrays.fill(bearings, bear);
        if (PolarLineDrawing.getBearingIndex(this.polarType) == 0) {
            float[][] fArrayArray2 = new float[2][];
            fArrayArray2[0] = bearings;
            fArrayArray = fArrayArray2;
            fArrayArray2[1] = ranges[0];
        } else {
            float[][] fArrayArray3 = new float[2][];
            fArrayArray3[0] = ranges[0];
            fArrayArray = fArrayArray3;
            fArrayArray3[1] = bearings;
        }
        float[][] samples = fArrayArray;
        CoordinateSystem coordinateSystem = null;
        if (PolarLineDrawing.getBearingIndex(this.polarType) == 0) {
            Unit[] unitArray2 = new Unit[2];
            unitArray2[0] = this.bearingType.getDefaultUnit();
            unitArray = unitArray2;
            unitArray2[1] = this.labelUnit;
        } else {
            Unit[] unitArray3 = new Unit[2];
            unitArray3[0] = this.labelUnit;
            unitArray = unitArray3;
            unitArray3[1] = this.bearingType.getDefaultUnit();
        }
        Gridded2DSet domain = new Gridded2DSet((MathType)this.polarType, (float[][])samples, numLabels, coordinateSystem, unitArray, (ErrorEstimate[])null);
        ScalarType type = this.getTextType();
        FunctionType ft = new FunctionType(this.polarType, type);
        FieldImpl labelField = new FieldImpl(ft, domain);
        Scalar[] labels = null;
        if (type instanceof TextType) {
            labels = new Text[numLabels];
            NumberFormat labelFormat = this.getNumberFormat();
            for (int i = 0; i < numLabels; ++i) {
                labels[i] = new Text((TextType)type, labelFormat.format((int)ranges[0][i]));
            }
        } else if (type instanceof RealType) {
            labels = new Real[numLabels];
            for (int i = 0; i < numLabels; ++i) {
                labels[i] = Unit.canConvert(((RealType)type).getDefaultUnit(), this.labelUnit) ? new Real((RealType)type, ranges[0][i], this.labelUnit) : new Real((RealType)type, (double)ranges[0][i]);
            }
        }
        labelField.setSamples(labels, false);
        this.setData(labelField);
    }
}

