/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.ContourLevels;
import visad.Contour2D;
import visad.ContourControl;
import visad.VisADException;

public final class RegularContourLevels
extends ContourLevels {
    protected final float interval;
    protected final float minimum;
    protected final float maximum;
    private boolean dash;

    public RegularContourLevels(float interval) {
        this(interval, 0.0f);
    }

    public RegularContourLevels(float interval, float base) {
        this(interval, base, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    }

    public RegularContourLevels(float interval, float base, float minimum, float maximum) {
        this(interval, base, minimum, maximum, false);
    }

    public RegularContourLevels(float interval, float base, float minimum, float maximum, boolean dash) {
        super(base);
        this.interval = interval;
        this.minimum = minimum;
        this.maximum = maximum;
        this.dash = dash;
    }

    public synchronized float[] getLevels() throws VisADException {
        return this.getLevels(this.minimum, this.maximum);
    }

    @Override
    public synchronized float[] getLevels(float minimum, float maximum) throws VisADException {
        if (Float.isInfinite(minimum) || Float.isNaN(minimum) || Float.isInfinite(maximum) || Float.isNaN(maximum)) {
            throw new VisADException(this.getClass().getName() + ".getLevels(float,float): " + "Invalid range extrema (max or min is infinite or NaN)");
        }
        float base = this.getBase();
        return Contour2D.intervalToLevels(this.interval, minimum, maximum, base, new boolean[1]);
    }

    @Override
    public synchronized void setControl(ContourControl control) throws VisADException, RemoteException {
        this.setControl(control, this.minimum, this.maximum);
    }

    @Override
    public synchronized void setControl(ContourControl control, float minimum, float maximum) throws VisADException, RemoteException {
        if (Float.isInfinite(minimum) || Float.isNaN(minimum) || Float.isInfinite(maximum) || Float.isNaN(maximum)) {
            throw new VisADException(this.getClass().getName() + ".setControl(ContourControl,float,float): " + "Invalid range extrema (max or min is infinite or NaN)");
        }
        control.setLevels(Contour2D.intervalToLevels(this.interval, minimum, maximum, this.getBase(), new boolean[1]), this.getBase(), this.dash);
    }
}

