/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.visad.display.Displayable;
import ucar.visad.display.PolarLineDrawing;
import visad.CommonUnit;
import visad.Gridded2DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;

public class Radials
extends PolarLineDrawing {
    public Radials(String name, RealTupleType polarType, Color color) throws RemoteException, VisADException {
        super(name, polarType);
        this.setColor(color);
    }

    protected Radials(Radials that) throws RemoteException, VisADException {
        super(that);
    }

    public void setRadials(Real maximum, double inc) throws VisADException, RemoteException {
        this.setRadials(new Real((RealType)maximum.getType(), 0.0, maximum.getUnit()), maximum, inc);
    }

    public void setRadials(Real minimum, Real maximum, double inc) throws VisADException, RemoteException {
        if (inc <= 0.0) {
            return;
        }
        int numRadials = (int)(360.0 / inc);
        SampledSet[] hairs = new SampledSet[numRadials];
        float[][] samples = new float[2][];
        float max = (float)maximum.getValue(this.getRangeType().getDefaultUnit());
        float min = (float)minimum.getValue(this.getRangeType().getDefaultUnit());
        samples[this.getRangeIndex()] = new float[]{min, max};
        float[] bearings = new float[2];
        Unit bearingUnit = this.getBearingType().getDefaultUnit();
        samples[this.getBearingIndex()] = bearings;
        for (int i = 0; i < numRadials; ++i) {
            Arrays.fill(bearings, (float)bearingUnit.toThis((double)i * inc, CommonUnit.degree));
            hairs[i] = new Gridded2DSet((MathType)this.getPolarType(), (float[][])samples, bearings.length);
        }
        this.setData(new UnionSet((MathType)this.getPolarType(), hairs));
    }

    public void setRadials(Radials radials) throws VisADException, RemoteException {
        this.setData(radials.getData());
    }

    @Override
    public boolean equals(Object obj) {
        Radials that;
        boolean equals = !(obj instanceof Radials) ? false : (that = (Radials)obj) == this || super.equals(that);
        return equals;
    }

    public void addScalarMaps(LocalDisplay display) {
    }

    @Override
    public synchronized Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new Radials(this);
    }
}

