/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.awt.Font;
import java.rmi.RemoteException;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.Radials;
import ucar.visad.display.RingLabels;
import ucar.visad.display.RingSet;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.georef.LatLonPoint;

public class RadarGrid
extends CompositeDisplayable {
    private RingSet rangeRings;
    private Radials radials;
    private RingLabels labels;
    private final RealType rangeType = RealType.getRealType("Range", CommonUnit.meter);
    private final RealType azimuthType = RealType.getRealType("Azimuth", CommonUnit.degree);
    private RealTupleType rtt;
    private double rrSpacing = 50.0;
    private double rrMax = 200.0;
    private double radialInc = 30.0;
    private double center_lat;
    private double center_lon;
    private double label_inc;
    private float labelSize = 1.0f;
    private Color gridColor;
    private Color lineColor;
    private Color ringColor;
    private Color labelColor;
    private float labelWidth = 1.0f;
    private float rangeRingWidth = 1.0f;
    private float radialWidth = 1.0f;
    private Unit distanceUnit = CommonUnits.KILOMETER;

    public RadarGrid(LatLonPoint llp, Color color) throws VisADException, RemoteException {
        this(llp, color, CommonUnits.KILOMETER);
    }

    public RadarGrid(LatLonPoint llp, Color color, Unit distUnit) throws VisADException, RemoteException {
        this(llp.getLatitude().getValue(CommonUnit.degree), llp.getLongitude().getValue(CommonUnit.degree), color, distUnit);
    }

    public RadarGrid(double lat, double lon, Color color) throws VisADException, RemoteException {
        this(lat, lon, color, CommonUnits.KILOMETER);
    }

    public RadarGrid(double lat, double lon, Color color, Unit distUnit) throws VisADException, RemoteException {
        this.label_inc = 2.0 * this.rrSpacing;
        this.gridColor = color;
        this.lineColor = color;
        this.ringColor = color;
        this.labelColor = color;
        this.distanceUnit = distUnit;
        this.setCenterPoint(lat, lon);
    }

    @Override
    public void setColor(Color color) throws VisADException, RemoteException {
        this.rangeRings.setColor(color);
        this.radials.setColor(color);
        this.labels.setColor(color);
        this.gridColor = color;
        this.lineColor = color;
        this.ringColor = color;
        this.labelColor = color;
    }

    public void setAzimuthLineColor(Color color) throws VisADException, RemoteException {
        this.radials.setColor(color);
        this.lineColor = color;
    }

    public void setRangeRingColor(Color color) throws VisADException, RemoteException {
        this.rangeRings.setColor(color);
        this.ringColor = color;
    }

    public void setLabelColor(Color color) throws VisADException, RemoteException {
        this.labels.setColor(color);
        this.labelColor = color;
    }

    public void setLabelLineWidth(float width) throws VisADException, RemoteException {
        this.labels.setLineWidth(width);
        this.labelWidth = width;
    }

    public void setRangeRingLineWidth(float width) throws VisADException, RemoteException {
        this.rangeRings.setLineWidth(width);
        this.rangeRingWidth = width;
    }

    public void setRadialLineWidth(float width) throws VisADException, RemoteException {
        this.radials.setLineWidth(width);
        this.radialWidth = width;
    }

    public void setAzimuthLinesVisible(boolean visible) throws VisADException, RemoteException {
        this.radials.setVisible(visible);
    }

    public void setRangeRingsVisible(boolean visible) throws VisADException, RemoteException {
        this.rangeRings.setVisible(visible);
    }

    public void setLabelsVisible(boolean visible) throws VisADException, RemoteException {
        this.labels.setVisible(visible);
    }

    public void setCenterPoint(LatLonPoint llp) throws VisADException, RemoteException {
        this.setCenterPoint(llp.getLatitude().getValue(CommonUnit.degree), llp.getLongitude().getValue(CommonUnit.degree));
    }

    public void setCenterPoint(double lat, double lon) throws VisADException, RemoteException {
        this.removeDisplayable(this.radials);
        this.removeDisplayable(this.rangeRings);
        this.removeDisplayable(this.labels);
        this.center_lat = lat;
        this.center_lon = lon;
        this.makeRealTupleType(lat, lon);
        this.makeRadials();
        this.makeRangeRings();
        this.makeLabels();
    }

    public void setCenterPointAndColors(double lat, double lon, Color rrcolor, Color radcolor, Color lcolor) throws VisADException, RemoteException {
        this.lineColor = radcolor;
        this.ringColor = rrcolor;
        this.labelColor = lcolor;
        this.setCenterPoint(lat, lon);
    }

    public double getCenterLatitude() {
        return this.center_lat;
    }

    public double getCenterLongitude() {
        return this.center_lon;
    }

    public void setRangeRingSpacing(double spacing, double max) throws VisADException, RemoteException {
        this.rangeRings.setRingValues(new Real(this.rangeType, spacing, this.distanceUnit), new Real(this.rangeType, max, this.distanceUnit));
        this.rrSpacing = spacing;
        this.rrMax = max;
        this.setRadialInterval(this.radialInc);
        this.removeDisplayable(this.labels);
        this.makeLabels();
    }

    public void setMaxRadius(double radius) throws VisADException, RemoteException {
        this.setRangeRingSpacing(this.rrSpacing, radius);
    }

    public void setLabelSpacing(double li) throws VisADException, RemoteException {
        this.label_inc = li;
        this.removeDisplayable(this.labels);
        this.makeLabels();
    }

    public void setRadialInterval(double inc) throws VisADException, RemoteException {
        this.radials.setRadials(new Real(this.rangeType, this.rrSpacing, this.distanceUnit), new Real(this.rangeType, this.rrMax, this.distanceUnit), inc);
        this.radialInc = inc;
    }

    public void setLabelSize(float size) {
        try {
            this.labelSize = size;
            this.labels.setTextSize(this.labelSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void makeRealTupleType(double lat, double lon) throws VisADException, RemoteException {
        Radar2DCoordinateSystem r2Dcs = new Radar2DCoordinateSystem((float)lat, (float)lon);
        this.rtt = new RealTupleType(this.rangeType, this.azimuthType, r2Dcs, null);
    }

    private void makeRadials() throws VisADException, RemoteException {
        boolean oldVisible = this.radials != null ? this.radials.getVisible() : this.getVisible();
        this.radials = new Radials("radials", this.rtt, this.lineColor);
        this.radials.setRadials(new Real(this.rangeType, this.rrSpacing, this.distanceUnit), new Real(this.rangeType, this.rrMax, this.distanceUnit), this.radialInc);
        this.radials.setVisible(oldVisible);
        this.radials.setLineWidth(this.radialWidth);
        this.addDisplayable(this.radials);
    }

    private void makeRangeRings() throws VisADException, RemoteException {
        boolean oldVisible = this.rangeRings != null ? this.rangeRings.getVisible() : this.getVisible();
        this.rangeRings = new RingSet("range rings", this.rtt, this.ringColor);
        this.rangeRings.setRingValues(new Real(this.rangeType, this.rrSpacing, this.distanceUnit), new Real(this.rangeType, this.rrMax, this.distanceUnit));
        this.rangeRings.setVisible(oldVisible);
        this.rangeRings.setLineWidth(this.rangeRingWidth);
        this.addDisplayable(this.rangeRings);
    }

    private void makeLabels() throws VisADException, RemoteException {
        boolean oldVisible = this.labels != null ? this.labels.getVisible() : this.getVisible();
        this.labels = new RingLabels("Distance", this.rtt, new Real(this.azimuthType, 15.0), this.labelColor);
        this.labels.setLabelValues(new Real(this.rangeType, this.label_inc, this.distanceUnit), new Real(this.rangeType, this.rrMax, this.distanceUnit));
        this.labels.setLabelUnit(this.distanceUnit);
        this.labels.setTextSize(this.labelSize);
        this.labels.setVisible(oldVisible);
        this.labels.setLineWidth(this.labelWidth);
        this.addDisplayable(this.labels);
    }

    public void setFont(Font f) throws VisADException, RemoteException {
        this.labels.setFont(f);
    }

    @Override
    public void setDisplayUnit(Unit newUnit) throws VisADException, RemoteException {
        this.setDistanceUnit(newUnit);
    }

    public void setDistanceUnit(Unit newUnit) throws VisADException, RemoteException {
        if (!Unit.canConvert(CommonUnit.meter, newUnit)) {
            throw new VisADException("Units must be convertible to meters");
        }
        this.distanceUnit = newUnit;
        this.setCenterPoint(this.center_lat, this.center_lon);
    }
}

