/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.ScalarMapSet;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.ConstantMap;
import visad.Display;
import visad.RangeControl;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Unit;
import visad.VisADException;
import visad.util.Util;

public abstract class RGBDisplayable
extends DisplayableData {
    public static final String COLOR_PALETTE = "colorPalette";
    public static final String RGB_REAL_TYPE = "rgbRealType";
    public static final int POLYGON_FILL = 0;
    public static final int POLYGON_LINE = 1;
    public static final int POLYGON_POINT = 2;
    private float[][] colorPalette = null;
    private volatile ScalarMap colorMap;
    private volatile BaseColorControl colorControl;
    private volatile RealType rgbRealType;
    private ScalarMap selectMap = null;
    private RangeControl selectControl;
    private RealType selectRealType = null;
    private boolean alphaflag;
    private double lowRange = Double.NaN;
    private double highRange = Double.NaN;
    private int polygonMode = 0;
    private int curvedSize = 10;
    private double lowSelectedRange = Double.NaN;
    private double highSelectedRange = Double.NaN;
    private double minSelect = Double.NaN;
    private double maxSelect = Double.NaN;
    private boolean useRGBTypeForSelect = false;
    private boolean autoScaleColorRange = false;

    public RGBDisplayable(String name, RealType rgbRealType, boolean alphaflag) throws VisADException, RemoteException {
        this(name, rgbRealType, null, alphaflag);
    }

    public RGBDisplayable(String name, RealType rgbRealType, float[][] colorPalette, boolean alphaflag) throws VisADException, RemoteException {
        super(name);
        this.rgbRealType = rgbRealType;
        this.colorPalette = colorPalette;
        this.alphaflag = alphaflag;
        if (rgbRealType != null) {
            this.setColorMaps();
            if (this.useDisplayUnitForColor()) {
                this.setDisplayUnit(rgbRealType.getDefaultUnit());
            } else {
                this.setColorUnit(rgbRealType.getDefaultUnit());
            }
        }
    }

    protected boolean useDisplayUnitForColor() {
        return true;
    }

    protected RGBDisplayable(RGBDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.colorPalette = that.colorPalette;
        this.rgbRealType = that.rgbRealType;
        this.selectRealType = that.selectRealType;
        this.alphaflag = that.alphaflag;
        if (this.rgbRealType != null) {
            this.setColorMaps();
        }
    }

    public void setRGBRealType(RealType realType) throws RemoteException, VisADException {
        if (!realType.equals(this.rgbRealType)) {
            RealType oldValue = this.rgbRealType;
            this.rgbRealType = realType;
            this.setColorMaps();
            if (this.useDisplayUnitForColor()) {
                if (!this.isUnitCompatible(this.rgbRealType, this.getDisplayUnit())) {
                    this.setDisplayUnit(null);
                }
            } else if (!this.isUnitCompatible(this.rgbRealType, this.getColorUnit())) {
                this.setColorUnit(null);
            }
            this.firePropertyChange(RGB_REAL_TYPE, oldValue, this.rgbRealType);
        }
        if (this.getUseRGBTypeForSelect()) {
            this.setSelectRealType(this.rgbRealType);
        }
    }

    public RealType getRGBRealType() {
        return this.rgbRealType;
    }

    public RealType getSelectRealType() {
        return this.selectRealType;
    }

    protected void setScalarMaps(ScalarMapSet maps) throws BadMappingException {
        if (this.colorMap == null) {
            throw new BadMappingException(this.getClass().getName() + ".setScalarMaps(ScalarMapSet): " + "Color not yet set");
        }
        maps.add(this.colorMap);
        if (this.selectMap != null) {
            maps.add(this.selectMap);
        }
        super.setScalarMapSet(maps);
    }

    @Override
    public void setColorPalette(float[][] colorPalette) throws RemoteException, VisADException {
        if (this.colorControl != null) {
            this.colorControl.setTable(colorPalette);
        }
        this.colorPalette = colorPalette;
    }

    public float[][] getColorPalette() {
        return this.colorPalette;
    }

    @Override
    public void setColor(Color color) throws RemoteException, VisADException {
        int len = 5;
        float[][] table = new float[this.alphaflag ? 4 : 3][len];
        for (int m = 0; m < len; ++m) {
            table[0][m] = (float)color.getRed() / 255.0f;
            table[1][m] = (float)color.getGreen() / 255.0f;
            table[2][m] = (float)color.getBlue() / 255.0f;
            if (!this.alphaflag) continue;
            table[3][m] = (float)color.getAlpha() / 255.0f;
        }
        this.setColorPalette(table);
    }

    public final void setGreyPalette() throws RemoteException, VisADException {
        if (this.colorControl != null) {
            this.colorControl.initGreyWedge();
            this.setColorPalette(this.colorControl.getTable());
        }
    }

    public final void setVisADPalette() throws RemoteException, VisADException {
        if (this.colorControl != null) {
            this.colorControl.initVis5D();
            this.setColorPalette(this.colorControl.getTable());
        }
    }

    public void setRange(double low, double hi) throws VisADException, RemoteException {
        this.setRangeForColor(low, hi);
    }

    @Override
    public void setRangeForColor(double low, double hi) throws VisADException, RemoteException {
        this.lowRange = low;
        this.highRange = hi;
        if (this.colorMap != null && this.hasRange() && !this.getAutoScaleColorRange()) {
            this.colorMap.setRange(low, hi);
        }
    }

    public double[] getRangeforColor() {
        return this.getRangeForColor();
    }

    public double[] getRangeForColor() {
        return new double[]{this.lowRange, this.highRange};
    }

    private void applyUnit(ScalarMap colorMap, RealType rgbRealType) throws VisADException, RemoteException {
        if (this.useDisplayUnitForColor()) {
            this.applyDisplayUnit(colorMap, rgbRealType);
        } else {
            this.applyColorUnit(colorMap, rgbRealType);
        }
    }

    @Override
    public void setDisplayUnit(Unit unit) throws VisADException, RemoteException {
        if (this.useDisplayUnitForColor()) {
            this.checkUnit(this.rgbRealType, unit);
        }
        super.setDisplayUnit(unit);
        if (this.useDisplayUnitForColor()) {
            this.applyUnit(this.colorMap, this.rgbRealType);
        }
        if (this.getUseRGBTypeForSelect()) {
            this.applyUnit(this.selectMap, this.selectRealType);
        }
    }

    @Override
    public void setColorUnit(Unit unit) throws VisADException, RemoteException {
        if (!this.useDisplayUnitForColor()) {
            this.checkUnit(this.rgbRealType, unit);
        }
        super.setColorUnit(unit);
        if (!this.useDisplayUnitForColor()) {
            this.applyUnit(this.colorMap, this.rgbRealType);
        }
    }

    public boolean hasRange() {
        return !Double.isNaN(this.lowRange) && !Double.isNaN(this.highRange);
    }

    public void setPolygonMode(int polygonMode) throws VisADException, RemoteException {
        this.polygonMode = polygonMode;
        this.addConstantMap(new ConstantMap(this.convertToVisADPolygonMode(polygonMode), Display.PolygonMode));
    }

    private int convertToVisADPolygonMode(int myMode) {
        if (Util.canDoJava3D()) {
            switch (myMode) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
            }
            return 2;
        }
        return 0;
    }

    public int getPolygonMode() {
        return this.polygonMode;
    }

    public void setCurvedSize(int curvedSize) throws VisADException, RemoteException {
        this.curvedSize = curvedSize;
        this.addConstantMap(this.makeCurvedSizeMap(curvedSize));
    }

    protected ConstantMap makeCurvedSizeMap(int curvedSize) throws VisADException, RemoteException {
        return new ConstantMap(curvedSize, Display.CurvedSize);
    }

    public int getCurvedSize() {
        return this.curvedSize;
    }

    private void setColorMaps() throws RemoteException, VisADException {
        ScalarMapSet maps = this.getScalarMapSet();
        if (this.colorMap != null) {
            maps.remove(this.colorMap);
        }
        this.colorMap = !this.alphaflag ? new ScalarMap(this.rgbRealType, Display.RGB) : new ScalarMap(this.rgbRealType, Display.RGBA);
        this.applyUnit(this.colorMap, this.rgbRealType);
        if (this.hasRange() && !this.getAutoScaleColorRange()) {
            this.colorMap.setRange(this.lowRange, this.highRange);
        }
        this.colorMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block7: {
                    block6: {
                        int id = event.getId();
                        if (id == 3) break block6;
                        if (id != 5) break block7;
                    }
                    RGBDisplayable.this.colorControl = (BaseColorControl)RGBDisplayable.this.colorMap.getControl();
                    if (RGBDisplayable.this.colorControl != null) {
                        if (RGBDisplayable.this.colorPalette != null) {
                            RGBDisplayable.this.colorControl.setTable(RGBDisplayable.this.colorPalette);
                        } else {
                            RGBDisplayable.access$202(RGBDisplayable.this, RGBDisplayable.this.colorControl.getTable());
                        }
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
                if (event.getId() == 1 && RGBDisplayable.this.hasRange() && !RGBDisplayable.this.getAutoScaleColorRange()) {
                    RGBDisplayable.this.colorMap.setRange(RGBDisplayable.this.lowRange, RGBDisplayable.this.highRange);
                }
            }
        });
        maps.add(this.colorMap);
        this.setScalarMapSet(maps);
    }

    protected void setSelectRealType(RealType realType) throws RemoteException, VisADException {
        if (!realType.equals(this.selectRealType)) {
            RealType oldValue = this.selectRealType;
            this.selectRealType = realType;
            this.setSelectMaps();
            if (this.useDisplayUnitForColor()) {
                if (!this.isUnitCompatible(this.selectRealType, this.getDisplayUnit())) {
                    this.setDisplayUnit(null);
                }
            } else if (!this.isUnitCompatible(this.selectRealType, this.getColorUnit())) {
                this.setColorUnit(null);
            }
        }
    }

    public boolean hasSelectedRange() {
        return !Double.isNaN(this.lowSelectedRange) && !Double.isNaN(this.highSelectedRange);
    }

    @Override
    public void setSelectedRange(double low, double hi) throws VisADException, RemoteException {
        this.lowSelectedRange = low;
        this.highSelectedRange = hi;
        if (this.selectControl != null && this.hasSelectedRange()) {
            this.selectControl.setRange(new double[]{low, hi});
        }
    }

    public void setRangeForSelect(double low, double hi) throws VisADException, RemoteException {
        this.minSelect = low;
        this.maxSelect = hi;
        if (this.selectMap != null && this.hasSelectMinMax()) {
            this.selectMap.setRange(low, hi);
        }
    }

    private boolean hasSelectMinMax() {
        return !Double.isNaN(this.minSelect) && !Double.isNaN(this.maxSelect);
    }

    public void setUseRGBTypeForSelect(boolean yesno) {
        this.useRGBTypeForSelect = yesno;
    }

    public boolean getUseRGBTypeForSelect() {
        return this.useRGBTypeForSelect;
    }

    public void setAutoScaleColorRange(boolean yesno) {
        this.autoScaleColorRange = yesno;
        if (this.colorMap != null) {
            if (this.autoScaleColorRange) {
                this.colorMap.resetAutoScale();
            } else if (this.hasRange()) {
                try {
                    this.colorMap.setRange(this.lowRange, this.highRange);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean getAutoScaleColorRange() {
        return this.autoScaleColorRange;
    }

    private void setSelectMaps() throws RemoteException, VisADException {
        ScalarMapSet maps = this.getScalarMapSet();
        if (this.selectMap != null) {
            maps.remove(this.selectMap);
        }
        this.selectMap = new ScalarMap(this.selectRealType, Display.SelectRange);
        if (this.selectRealType.equals(this.rgbRealType)) {
            this.applyUnit(this.selectMap, this.selectRealType);
        }
        if (this.hasSelectMinMax()) {
            this.selectMap.setRange(this.minSelect, this.maxSelect);
        }
        this.selectMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    RGBDisplayable.this.selectControl = (RangeControl)RGBDisplayable.this.selectMap.getControl();
                    if (RGBDisplayable.this.hasSelectedRange() && RGBDisplayable.this.selectControl != null) {
                        RGBDisplayable.this.selectControl.setRange(new double[]{RGBDisplayable.this.lowSelectedRange, RGBDisplayable.this.highSelectedRange});
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
                if (event.getId() == 1 && RGBDisplayable.this.hasSelectMinMax()) {
                    RGBDisplayable.this.selectMap.setRange(RGBDisplayable.this.minSelect, RGBDisplayable.this.maxSelect);
                }
            }
        });
        maps.add(this.selectMap);
        this.setScalarMapSet(maps);
    }

    static /* synthetic */ float[][] access$202(RGBDisplayable x0, float[][] x1) {
        x0.colorPalette = x1;
        return x1;
    }
}

