/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.LineDrawing;
import visad.CommonUnit;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public abstract class PolarLineDrawing
extends LineDrawing {
    private RealTupleType polarType;
    private int rangeIndex;
    private int bearingIndex;

    protected PolarLineDrawing(String name, RealTupleType polarType) throws RemoteException, VisADException {
        super(name);
        this.polarType = polarType;
        this.bearingIndex = PolarLineDrawing.getBearingIndex(polarType);
        this.rangeIndex = 1 - this.bearingIndex;
    }

    protected PolarLineDrawing(PolarLineDrawing that) throws RemoteException, VisADException {
        super(that);
        this.polarType = that.polarType;
        this.rangeIndex = that.rangeIndex;
        this.bearingIndex = that.bearingIndex;
    }

    protected final RealTupleType getPolarType() {
        return this.polarType;
    }

    protected final int getRangeIndex() {
        return this.rangeIndex;
    }

    protected final int getBearingIndex() {
        return this.bearingIndex;
    }

    public static int getBearingIndex(RealTupleType polarType) throws VisADException {
        int bearingIndex = -1;
        for (int i = 0; i < 2; ++i) {
            if (!Unit.canConvert(CommonUnit.degree, ((RealType)polarType.getComponent(i)).getDefaultUnit())) continue;
            bearingIndex = i;
        }
        return bearingIndex;
    }

    protected final RealType getRangeType() throws VisADException {
        return (RealType)this.getPolarType().getComponent(this.getRangeIndex());
    }

    protected final RealType getBearingType() throws VisADException {
        return (RealType)this.getPolarType().getComponent(this.getBearingIndex());
    }

    public boolean equals(Object obj) {
        PolarLineDrawing that;
        boolean equals = !(obj instanceof PolarLineDrawing) ? false : (that = (PolarLineDrawing)obj) == this || this.polarType.equals(that.polarType) && super.equals(that);
        return equals;
    }

    public int hashCode() {
        return this.polarType.hashCode() ^ super.hashCode();
    }
}

