/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.SelectorDisplayable;
import ucar.visad.display.SelectorPoint;
import visad.ActionImpl;
import visad.RealTuple;
import visad.RealTupleType;
import visad.VisADException;
import visad.VisADGeometryArray;

public class PointProbe
extends SelectorDisplayable {
    private SelectorPoint point;
    private volatile boolean settingPosition = false;

    public PointProbe() throws VisADException, RemoteException {
        this(0.0, 0.0, 0.0);
    }

    public PointProbe(double x, double y, double z) throws VisADException, RemoteException {
        this(new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{x, y, z}));
    }

    public PointProbe(RealTuple position) throws VisADException, RemoteException {
        this.point = new SelectorPoint("Probe point", position);
        this.addDisplayable(this.point);
        this.setPosition(position);
        this.point.addAction(new ActionImpl("point listener"){

            @Override
            public void doAction() throws VisADException, RemoteException {
                if (PointProbe.this.settingPosition) {
                    return;
                }
                PointProbe.this.notifyListenersOfMove();
            }
        });
    }

    public SelectorPoint getSelectorPoint() {
        return this.point;
    }

    public void setFixed(boolean x, boolean y, boolean z) {
        this.point.setFixed(x, y, z);
    }

    public float getPointScale() {
        if (this.point != null) {
            return this.point.getScale();
        }
        return 1.0f;
    }

    public void setMarker(VisADGeometryArray marker) throws VisADException, RemoteException {
        this.point.setMarker(marker);
    }

    public void setMarker(String marker) throws VisADException, RemoteException {
        this.point.setMarker(marker);
    }

    @Override
    public void setAutoSize(boolean yesorno) throws VisADException, RemoteException {
        this.point.setAutoSize(yesorno);
    }

    public RealTuple getPosition() throws VisADException, RemoteException {
        return this.point.getPoint();
    }

    public void setPosition(double x, double y) throws VisADException, RemoteException {
        this.setPosition(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x, y}));
    }

    public void setPosition(RealTuple position) throws VisADException, RemoteException {
        this.settingPosition = true;
        try {
            this.point.setPoint(position);
        }
        finally {
            this.settingPosition = false;
        }
    }
}

