/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.CoordinateSystem;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.VisADException;

public class MapLines
extends LineDrawing {
    private SampledSet mapSet = null;

    public MapLines(String name) throws VisADException, RemoteException {
        this(name, null);
    }

    public MapLines(String name, SampledSet mapSet) throws VisADException, RemoteException {
        super(name);
        if (mapSet != null) {
            this.setMapLines(mapSet);
        }
    }

    protected MapLines(MapLines that) throws RemoteException, VisADException {
        super(that);
        this.mapSet = that.mapSet;
        if (this.mapSet != null) {
            this.setMapLines(this.mapSet);
        }
    }

    public void setMapLines(SampledSet mapSet) throws VisADException, RemoteException {
        if (mapSet == null) {
            this.setData(new Real(0.0));
            this.mapSet = null;
            return;
        }
        if (mapSet.getDimension() != 2) {
            throw new VisADException("Set dimension must be 2");
        }
        CoordinateSystem cs = mapSet.getCoordinateSystem();
        RealTupleType mType = cs == null ? ((SetType)mapSet.getType()).getDomain() : mapSet.getCoordinateSystem().getReference();
        if (mType.getIndex(RealType.Latitude) == -1 || mType.getIndex(RealType.Longitude) == -1) {
            throw new VisADException("Set or CoordinateSystem must be values of RealType.Latitude and RealType.Longitude");
        }
        this.mapSet = mapSet;
        this.setData(this.mapSet);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Map Name = ");
        sb.append(this.getName());
        sb.append("\n");
        sb.append("\tColor = ");
        sb.append(this.getColor().toString());
        sb.append("\n");
        sb.append("\tHas Data = ");
        sb.append(this.mapSet != null ? "Yes" : "No");
        sb.append("\n");
        sb.append("\tIs Visible = ");
        sb.append(this.isVisible() ? "Yes" : "No");
        return sb.toString();
    }

    @Override
    public synchronized Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new MapLines(this);
    }
}

