/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.ProfileLine;
import ucar.visad.display.SelectorDisplayable;
import ucar.visad.display.SelectorPoint;
import visad.ActionImpl;
import visad.ConstantMap;
import visad.Display;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.VisADGeometryArray;

public class LineProbe
extends SelectorDisplayable {
    private SelectorPoint point;
    private ProfileLine line;
    private Real constant;
    private float pointSize = 5.0f;
    private volatile boolean settingPosition = false;
    private RealTuple fixedEndPoint;

    public LineProbe() throws VisADException, RemoteException {
        this(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{0.0, 0.0}));
    }

    public LineProbe(double x, double y, double z) throws VisADException, RemoteException {
        this(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x, y}), new Real(RealType.ZAxis, z));
    }

    public LineProbe(RealTuple position) throws VisADException, RemoteException {
        this(position, new Real(RealType.ZAxis, 1.0));
    }

    public LineProbe(RealTuple position, Real constant) throws VisADException, RemoteException {
        this(position, null, constant);
    }

    public LineProbe(RealTuple position, RealTuple fixedEndPoint, Real constant) throws VisADException, RemoteException {
        if (constant != null && !constant.getType().equals(RealType.ZAxis)) {
            throw new VisADException("Can't yet handle constant " + constant.getType());
        }
        this.fixedEndPoint = fixedEndPoint;
        this.constant = constant;
        this.line = new ProfileLine("ProbeLine");
        this.point = new SelectorPoint("Probe point", position);
        if (constant != null) {
            this.point.addConstantMap(new ConstantMap(constant.getValue(), Display.ZAxis));
        }
        this.addDisplayable(this.point);
        this.addDisplayable(this.line);
        this.setPosition(position);
        this.point.addAction(new ActionImpl("point listener"){

            @Override
            public void doAction() throws VisADException, RemoteException {
                if (LineProbe.this.settingPosition) {
                    return;
                }
                LineProbe.this.setLinePosition();
                LineProbe.this.notifyListenersOfMove();
            }
        });
    }

    @Override
    public void setManipulable(boolean manip) throws VisADException, RemoteException {
        this.line.setManipulable(manip);
        this.point.setManipulable(manip);
    }

    public RealTuple getPosition() throws VisADException, RemoteException {
        return this.point.getPoint();
    }

    public SelectorPoint getSelectorPoint() {
        return this.point;
    }

    @Override
    public void setAutoSize(boolean yesorno) throws VisADException, RemoteException {
        this.point.setAutoSize(yesorno);
        super.setAutoSize(yesorno);
    }

    public void setPosition(double x, double y) throws VisADException, RemoteException {
        this.setPosition(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x, y}));
    }

    public void setPosition(RealTuple position) throws VisADException, RemoteException {
        this.settingPosition = true;
        try {
            if (this.constant != null && !this.constant.getType().equals(RealType.ZAxis)) {
                throw new VisADException("Can't yet constant " + this.constant.getType());
            }
            this.point.setPoint(position);
            this.setLinePosition();
        }
        finally {
            this.settingPosition = false;
        }
    }

    private void setLinePosition() throws VisADException, RemoteException {
        float[][] lineVals = new float[3][2];
        Real[] reals = this.point.getPoint().getRealComponents();
        lineVals[0][0] = (float)reals[0].getValue();
        lineVals[1][0] = (float)reals[1].getValue();
        if (reals.length == 2 && this.constant != null) {
            lineVals[2][0] = (float)this.constant.getValue();
        } else if (reals.length == 3) {
            lineVals[2][0] = (float)reals[2].getValue();
        }
        if (this.fixedEndPoint != null) {
            Real[] pt = this.fixedEndPoint.getRealComponents();
            lineVals[0][1] = (float)pt[0].getValue();
            lineVals[1][1] = (float)pt[1].getValue();
            lineVals[2][1] = (float)pt[2].getValue();
        } else {
            lineVals[0][1] = lineVals[0][0];
            lineVals[1][1] = lineVals[1][0];
            lineVals[2][1] = -1.0f;
        }
        Gridded3DSet lineData = new Gridded3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, lineVals, 2);
        if (!lineData.equals(this.line.getData())) {
            this.line.setData(lineData);
        }
    }

    public void setMarker(String markerText) throws VisADException, RemoteException {
        this.point.setMarker(markerText);
    }

    public void setMarker(VisADGeometryArray marker) throws VisADException, RemoteException {
        this.point.setMarker(marker);
    }

    @Override
    public void setPointSize(float newSize) throws VisADException, RemoteException {
        this.point.setPointSize(newSize);
    }

    public float getPointScale() {
        if (this.point != null) {
            return this.point.getScale();
        }
        return 1.0f;
    }
}

