/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import ucar.visad.display.DisplayableData;
import visad.ConstantMap;
import visad.Display;
import visad.VisADException;

public class LineDrawing
extends DisplayableData {
    public static String COLOR = "color";
    public static String LINE_WIDTH = "lineWidth";
    public static String LINE_STYLE = "lineStyle";
    public static String POINT_SIZE = "pointSize";
    private Color myColor;
    private float myLineWidth;
    private float myPointSize;
    private int myLineStyle;

    public LineDrawing(String name) throws VisADException, RemoteException {
        super(name);
        this.myColor = Color.white;
        this.myLineWidth = 1.0f;
        this.myPointSize = 1.0f;
        this.myLineStyle = 0;
    }

    public LineDrawing(LineDrawing that) throws VisADException, RemoteException {
        super(that);
        this.myColor = that.myColor;
        this.myLineWidth = that.myLineWidth;
        this.myPointSize = that.myPointSize;
        this.myLineStyle = that.myLineStyle;
    }

    public void setRGB(double red, double green, double blue) throws VisADException, RemoteException {
        this.setRGBA(red, green, blue, 1.0);
    }

    public void setRGBA(double red, double green, double blue, double alpha) throws VisADException, RemoteException {
        this.setColor(new Color((float)red, (float)green, (float)blue, (float)alpha));
    }

    public void setRGB(float[] rgb) throws VisADException, RemoteException {
        this.setRGB(rgb[0], rgb[1], rgb[2]);
    }

    public void setRGBA(float[] rgba) throws VisADException, RemoteException {
        this.setRGBA(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public void setHSV(double hue, double saturation, double value) throws VisADException, RemoteException {
        float[][] rgb = Display.DisplayHSVCoordSys.toReference(new float[][]{{(float)hue}, {(float)saturation}, {(float)value}});
        this.setRGB(new float[]{rgb[0][0], rgb[1][0], rgb[2][0]});
    }

    public void setHSV(float[] hsv) throws VisADException, RemoteException {
        this.setHSV(hsv[0], hsv[1], hsv[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColor(Color color) throws VisADException, RemoteException {
        Color oldValue;
        LineDrawing lineDrawing = this;
        synchronized (lineDrawing) {
            oldValue = this.myColor;
            this.addConstantMaps(new ConstantMap[]{new ConstantMap((double)color.getRed() / 255.0, Display.Red), new ConstantMap((double)color.getGreen() / 255.0, Display.Green), new ConstantMap((double)color.getBlue() / 255.0, Display.Blue), new ConstantMap((double)color.getAlpha() / 255.0, Display.Alpha)});
            this.myColor = color;
        }
        this.firePropertyChange(COLOR, oldValue, this.myColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLineWidth(float lineWidth) throws VisADException, RemoteException {
        float oldValue;
        LineDrawing lineDrawing = this;
        synchronized (lineDrawing) {
            oldValue = this.myLineWidth;
            this.addConstantMap(new ConstantMap(lineWidth, Display.LineWidth));
            this.myLineWidth = lineWidth;
        }
        this.firePropertyChange(LINE_WIDTH, new Float(oldValue), new Float(this.myLineWidth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineStyle(int lineStyle) throws VisADException, RemoteException {
        int oldValue;
        LineDrawing lineDrawing = this;
        synchronized (lineDrawing) {
            oldValue = this.myLineStyle;
            this.addConstantMap(new ConstantMap(lineStyle, Display.LineStyle));
            this.myLineStyle = lineStyle;
        }
        this.firePropertyChange(LINE_STYLE, new Integer(oldValue), new Integer(this.myLineStyle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPointSize(float pointSize) throws VisADException, RemoteException {
        float oldValue;
        LineDrawing lineDrawing = this;
        synchronized (lineDrawing) {
            oldValue = this.myPointSize;
            this.addConstantMap(new ConstantMap(pointSize, Display.PointSize));
            this.myPointSize = pointSize;
        }
        this.firePropertyChange(POINT_SIZE, new Float(oldValue), new Float(this.myPointSize));
    }

    public Color getColor() {
        return this.myColor;
    }

    @Override
    public float getLineWidth() {
        return this.myLineWidth;
    }

    public int getLineStyle() {
        return this.myLineStyle;
    }

    @Override
    public float getPointSize() {
        return this.myPointSize;
    }
}

