/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import java.util.ArrayList;
import ucar.unidata.util.Misc;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.UnionSet;
import visad.VisADException;

public class LatLonLines
extends LineDrawing {
    private UnionSet latLines;
    private float minValue;
    private float maxValue;
    private float spacing;
    private float base;
    private boolean isLat = false;

    public LatLonLines(RealType type) throws VisADException, RemoteException {
        this(type, type.equals(RealType.Latitude) ? -90 : -180, type.equals(RealType.Latitude) ? 90 : 180, type.equals(RealType.Latitude) ? 30 : 45);
    }

    public LatLonLines(RealType type, float minValue, float maxValue, float spacing) throws VisADException, RemoteException {
        this(type, minValue, maxValue, spacing, true);
    }

    public LatLonLines(RealType type, float minValue, float maxValue, float spacing, boolean setData) throws VisADException, RemoteException {
        this(type, minValue, maxValue, spacing, 0.0f, true);
    }

    public LatLonLines(RealType type, float minValue, float maxValue, float spacing, float base, boolean setData) throws VisADException, RemoteException {
        super(LatLonLines.makeName(type));
        this.isLat = type.equals(RealType.Latitude);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.spacing = spacing;
        this.base = base;
        this.createLines(setData);
    }

    protected LatLonLines(LatLonLines that) throws RemoteException, VisADException {
        super(that);
        this.latLines = that.latLines;
        this.minValue = that.minValue;
        this.maxValue = that.maxValue;
        this.spacing = that.spacing;
        this.base = that.base;
        this.isLat = that.isLat;
        this.createLines();
    }

    private static String makeName(RealType type) throws VisADException {
        String name;
        if (type.equals(RealType.Latitude)) {
            name = "LatitudeLines";
        } else if (type.equals(RealType.Longitude)) {
            name = "LongitudeLines";
        } else {
            throw new VisADException("Invalid type for LatLonLines: " + type);
        }
        return name;
    }

    public void setSpacing(float spacing) throws VisADException, RemoteException {
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        this.createLines();
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setBase(float base) throws VisADException, RemoteException {
        if (base == this.base) {
            return;
        }
        this.base = base;
        this.createLines();
    }

    public float getBase() {
        return this.base;
    }

    public void setMaxMin(float minValue, float maxValue) throws VisADException, RemoteException {
        this.setLimits(minValue, maxValue, this.spacing);
    }

    public void setLimits(float minValue, float maxValue, float spacing) throws VisADException, RemoteException {
        this.setLimits(minValue, maxValue, spacing, 0.0f);
    }

    public void setLimits(float minValue, float maxValue, float spacing, float base) throws VisADException, RemoteException {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.spacing = spacing;
        this.base = base;
        this.createLines();
    }

    @Override
    public synchronized Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new LatLonLines(this);
    }

    private void createLines() throws VisADException, RemoteException {
        this.createLines(true);
    }

    private void createLines(boolean andSetData) throws VisADException, RemoteException {
        ArrayList<Gridded2DSet> setList = new ArrayList<Gridded2DSet>();
        float[] lineVals = Misc.computeTicks(this.maxValue, this.minValue, this.base, this.spacing);
        int numpoints = this.isLat ? 361 : 181;
        float first = this.isLat ? -180.0f : -90.0f;
        for (int i = 0; i < lineVals.length; ++i) {
            float[][] lalo = new float[2][numpoints];
            float other = first;
            float value = lineVals[i];
            for (int j = 0; j < numpoints; ++j) {
                lalo[0][j] = this.isLat ? value : other;
                lalo[1][j] = this.isLat ? other : value;
                other += 1.0f;
            }
            Gridded2DSet lineSet = new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, lalo, numpoints);
            setList.add(lineSet);
        }
        SampledSet[] latlons = new Gridded2DSet[setList.size()];
        setList.toArray(latlons);
        this.latLines = new UnionSet((MathType)RealTupleType.LatitudeLongitudeTuple, latlons);
        if (andSetData) {
            this.setData(this.latLines);
        }
    }

    @Override
    public void setVisible(boolean visible) throws RemoteException, VisADException {
        if (visible && !this.hasData()) {
            this.createLines(true);
        }
        super.setVisible(visible);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name = ");
        sb.append(this.getName());
        sb.append("\n");
        sb.append("\tColor = ");
        sb.append(this.getColor().toString());
        sb.append("\n");
        sb.append("\tMin:");
        sb.append(Float.toString(this.minValue));
        sb.append("\t");
        sb.append("Max:");
        sb.append(Float.toString(this.maxValue));
        sb.append("\t");
        sb.append("Spacing:");
        sb.append(Float.toString(this.spacing));
        sb.append("\n");
        sb.append("\tIs Visible = ");
        sb.append(this.isVisible() ? "Yes" : "No");
        return sb.toString();
    }
}

