/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.unidata.util.Misc;
import ucar.visad.display.TextDisplayable;
import visad.CommonUnit;
import visad.Data;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.ScalarType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;

public class LatLonLabels
extends TextDisplayable {
    private boolean isLatitude;
    private float base;
    private float max;
    private float min;
    private float interval;
    private float[] labelLines;
    private String labelFormat = "DD";
    private TupleType labelType;
    private boolean use360 = false;
    private Real latReal = new Real(RealType.Latitude, 0.0, CommonUnit.degree);
    private Real lonReal = new Real(RealType.Longitude, 0.0, CommonUnit.degree);

    public LatLonLabels() throws VisADException, RemoteException {
        this("LatLonLabels");
    }

    public LatLonLabels(String name) throws VisADException, RemoteException {
        this(name, TextType.getTextType(name));
    }

    public LatLonLabels(ScalarType textType) throws VisADException, RemoteException {
        this("LatLonLabels", textType);
    }

    public LatLonLabels(String name, ScalarType textType) throws VisADException, RemoteException {
        this(name, textType, true, 15.0f, -90.0f, 90.0f, 0.0f, new float[]{0.0f, -180.0f});
    }

    public LatLonLabels(String name, ScalarType textType, boolean isLatitude, float increment, float min, float max, float base, float[] labelLines) throws VisADException, RemoteException {
        super(name, textType, false);
        this.isLatitude = isLatitude;
        this.interval = increment;
        this.min = min;
        this.max = max;
        this.base = base;
        this.labelLines = labelLines;
        this.createLabels();
    }

    public LatLonLabels(LatLonLabels that) throws RemoteException, VisADException {
        super(that);
    }

    public void setValues(float increment, float min, float max, float base, float[] labelLines) throws VisADException, RemoteException {
        this.interval = increment;
        this.min = min;
        this.max = max;
        this.base = base;
        this.labelLines = labelLines;
        this.createLabels();
    }

    @Override
    public ScalarType getTextType() {
        if (super.getTextType() instanceof RealType) {
            return TextType.getTextType(super.getTextType().getName());
        }
        return super.getTextType();
    }

    @Override
    public void setTextType(ScalarType textType) throws RemoteException, VisADException {
        super.setTextType(textType);
        this.labelType = null;
    }

    private TupleType makeLabelType() throws VisADException, RemoteException {
        return new TupleType(new MathType[]{RealType.Latitude, RealType.Longitude, this.getTextType()});
    }

    protected void createLabels() throws VisADException, RemoteException {
        if (this.labelType == null) {
            this.labelType = this.makeLabelType();
        }
        if (!this.isLatitude && 0 == Float.compare(this.min + 360.0f, this.max)) {
            this.min = (float)((double)this.min + 0.01);
        }
        float[] labelVals = Misc.computeTicks(this.max, this.min, this.base, this.interval);
        int numLabels = labelVals.length * this.labelLines.length;
        FieldImpl labelField = new FieldImpl(new FunctionType(RealType.getRealType("index"), this.labelType), new Integer1DSet(numLabels));
        Data[] labelTuples = new Tuple[numLabels];
        int m = 0;
        for (int i = 0; i < this.labelLines.length; ++i) {
            for (int j = 0; j < labelVals.length; ++j) {
                Real lat = this.isLatitude ? this.latReal.cloneButValue(labelVals[j]) : this.latReal.cloneButValue(this.labelLines[i]);
                Real lon = this.isLatitude ? this.lonReal.cloneButValue(this.labelLines[i]) : this.lonReal.cloneButValue(labelVals[j]);
                Text label = new Text((TextType)this.getTextType(), this.formatLabel(labelVals[j]));
                labelTuples[m++] = new Tuple(this.labelType, new Data[]{lat, lon, label}, false, false);
            }
        }
        labelField.setSamples(labelTuples, false);
        this.setData(labelField);
    }

    private String formatLabel(double value) {
        return Misc.formatLatOrLon(value, this.labelFormat, this.isLatitude, this.use360);
    }

    public boolean isLatitude() {
        return this.isLatitude;
    }

    public void setLatitude(boolean isLatitude) throws VisADException, RemoteException {
        if (this.isLatitude == isLatitude) {
            return;
        }
        this.isLatitude = isLatitude;
        this.createLabels();
    }

    public float getBase() {
        return this.base;
    }

    public void setBase(float base) throws VisADException, RemoteException {
        if (this.base == base) {
            return;
        }
        this.base = base;
        this.createLabels();
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) throws VisADException, RemoteException {
        if (this.max == max) {
            return;
        }
        this.max = max;
        this.createLabels();
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) throws VisADException, RemoteException {
        if (this.min == min) {
            return;
        }
        this.min = min;
        this.createLabels();
    }

    public float getInterval() {
        return this.interval;
    }

    public void setInterval(float interval) throws VisADException, RemoteException {
        if (this.interval == interval) {
            return;
        }
        this.interval = interval;
        this.createLabels();
    }

    public boolean getUse360() {
        return this.use360;
    }

    public void setUse360(boolean yesorno) throws VisADException, RemoteException {
        if (this.use360 == yesorno) {
            return;
        }
        this.use360 = yesorno;
        this.createLabels();
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(String labelFormat) throws VisADException, RemoteException {
        if (labelFormat == null || Misc.equals(this.labelFormat, labelFormat)) {
            return;
        }
        this.labelFormat = labelFormat;
        this.createLabels();
    }

    public float[] getLabelLines() {
        return this.labelLines;
    }

    public void setLabelLines(float[] labelLines) throws VisADException, RemoteException {
        if (Arrays.equals(this.labelLines, labelLines)) {
            return;
        }
        this.labelLines = labelLines;
        this.createLabels();
    }
}

