/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.RGBDisplayable;
import ucar.visad.display.ScalarMapSet;
import visad.BadMappingException;
import visad.ContourControl;
import visad.Display;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Unit;
import visad.VisADException;

public abstract class IsoSurface
extends RGBDisplayable {
    public static final String SURFACE_VALUE = "surfaceValue";
    public static final String CONTOUR_REAL_TYPE = "contourRealType";
    private volatile float surfaceValue;
    private volatile ScalarMap contourMap;
    private volatile ContourControl contourControl;
    private volatile RealType contourRealType;

    public IsoSurface(String name, RealType contourRealType, boolean alphaflag) throws VisADException, RemoteException {
        super(name, contourRealType, alphaflag);
        this.contourRealType = contourRealType;
        if (contourRealType != null) {
            this.setContourMaps();
        }
    }

    protected IsoSurface(IsoSurface that) throws VisADException, RemoteException {
        super(that);
        this.surfaceValue = that.surfaceValue;
        this.contourRealType = that.contourRealType;
        if (this.contourRealType != null) {
            this.setContourMaps();
        }
    }

    protected void setContourRealType(RealType realType) throws RemoteException, VisADException {
        if (!realType.equals(this.contourRealType)) {
            RealType oldValue = this.contourRealType;
            this.contourRealType = realType;
            this.setContourMaps();
            this.firePropertyChange(CONTOUR_REAL_TYPE, oldValue, this.contourRealType);
        }
    }

    @Override
    public void setDisplayUnit(Unit unit) throws VisADException, RemoteException {
        super.setDisplayUnit(unit);
    }

    public RealType getContourRealType() {
        return this.contourRealType;
    }

    public final void setSurfaceValue(float value) throws RemoteException, VisADException {
        if (value != this.surfaceValue) {
            Float oldValue = new Float(this.surfaceValue);
            if (this.contourControl != null) {
                this.contourControl.setSurfaceValue(value, true);
            }
            this.surfaceValue = value;
            this.firePropertyChange(SURFACE_VALUE, oldValue, new Float(this.surfaceValue));
        }
    }

    @Override
    protected void setScalarMaps(ScalarMapSet maps) throws BadMappingException {
        if (this.contourMap == null) {
            throw new BadMappingException(this.getClass().getName() + ".setScalarMaps(ScalarMapSet): " + "Contour parameter not yet set");
        }
        maps.add(this.contourMap);
        super.setScalarMapSet(maps);
    }

    public final float getSurfaceValue() {
        return this.surfaceValue;
    }

    private void setContourMaps() throws RemoteException, VisADException {
        ScalarMap oldContourMap = this.contourMap;
        this.contourMap = new ScalarMap(this.contourRealType, Display.IsoContour);
        this.contourMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block3: {
                    block2: {
                        int id = event.getId();
                        if (id == 3) break block2;
                        if (id != 5) break block3;
                    }
                    IsoSurface.this.contourControl = (ContourControl)IsoSurface.this.contourMap.getControl();
                    IsoSurface.this.contourControl.setSurfaceValue(IsoSurface.this.surfaceValue, true);
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) {
            }
        });
        this.replaceScalarMap(oldContourMap, this.contourMap);
        this.fireScalarMapSetChange();
    }
}

