/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.visad.display.ContourLevels;
import visad.ContourControl;
import visad.VisADException;

public final class IrregularContourLevels
extends ContourLevels {
    protected final float[] levels;
    private boolean dash = false;

    public IrregularContourLevels(float[] levels) {
        this.levels = (float[])levels.clone();
    }

    public IrregularContourLevels(float[] levels, float base) {
        this(levels, base, false);
    }

    public IrregularContourLevels(float[] levels, float base, boolean dash) {
        super(base);
        this.levels = (float[])levels.clone();
        this.dash = dash;
    }

    @Override
    public float[] getLevels(float minimum, float maximum) {
        float[] result;
        int minIndex = Arrays.binarySearch(this.levels, minimum);
        if (minIndex == -this.levels.length - 1) {
            result = new float[]{};
        } else {
            int maxIndex;
            if (minIndex < 0) {
                minIndex = 0;
            }
            if ((maxIndex = Arrays.binarySearch(this.levels, maximum)) == -1) {
                result = new float[]{};
            } else {
                if (maxIndex < 0) {
                    maxIndex = this.levels.length - 1;
                }
                result = new float[maxIndex - minIndex + 1];
                System.arraycopy(this.levels, minIndex, result, 0, result.length);
            }
        }
        return result;
    }

    @Override
    public void setControl(ContourControl control) throws VisADException, RemoteException {
        control.setLevels(this.levels, this.getBase(), this.dash);
    }

    @Override
    public void setControl(ContourControl control, float minimum, float maximum) throws VisADException, RemoteException {
        this.setControl(control);
    }
}

