/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.Displayable;
import ucar.visad.display.Grid2DDisplayable;
import visad.ConstantMap;
import visad.DataRenderer;
import visad.Display;
import visad.FieldImpl;
import visad.RealType;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.meteorology.ImageSequence;

public class ImageSequenceDisplayable
extends Grid2DDisplayable {
    private ImageSequence sequence;
    private ImageRendererJ3D myRenderer = null;

    public ImageSequenceDisplayable(String name, RealType imageType) throws VisADException, RemoteException {
        this(name, imageType, null);
    }

    public ImageSequenceDisplayable(String name, RealType imageType, float[][] initialColorPalette) throws VisADException, RemoteException {
        super(name, imageType, initialColorPalette, initialColorPalette != null ? initialColorPalette.length == 4 : true);
    }

    protected ImageSequenceDisplayable(ImageSequenceDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.setImageSequence(that.sequence);
    }

    public void setImageSequence(ImageSequence sequence) throws VisADException, RemoteException {
        this.setImageSequence((FieldImpl)((Object)sequence));
    }

    public void setAlpha(float alpha) throws RemoteException, VisADException {
        this.addConstantMaps(new ConstantMap[]{new ConstantMap(alpha, Display.Alpha)});
    }

    public void setImageSequence(FieldImpl sequence) throws VisADException, RemoteException {
        if (sequence == null) {
            throw new VisADException("Sequence can't be null");
        }
        this.loadData(sequence);
    }

    @Override
    protected DataRenderer getDataRenderer() {
        if (this.getDisplay().getDisplayRenderer() instanceof DisplayRendererJ2D) {
            return new DefaultRendererJ2D();
        }
        if (this.myRenderer == null) {
            this.myRenderer = new ImageRendererJ3D();
            this.myRenderer.setReUseFrames(false);
        }
        return this.myRenderer;
    }

    @Override
    public void setColorPalette(float[][] colorPalette) throws RemoteException, VisADException {
        boolean reUseTrue;
        boolean bl = reUseTrue = this.myRenderer != null ? this.myRenderer.getReUseFrames() : false;
        if (reUseTrue) {
            this.myRenderer.setReUseFrames(false);
            super.setColorPalette(colorPalette);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myRenderer.setReUseFrames(true);
        } else {
            super.setColorPalette(colorPalette);
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new ImageSequenceDisplayable(this);
    }

    @Override
    public void setTextureProperties(FieldImpl grid) throws VisADException, RemoteException {
    }

    @Override
    public boolean getTextureEnable() {
        return true;
    }

    public void setReUseScenes(boolean on) throws RemoteException, VisADException {
        if (this.myRenderer != null && this.myRenderer instanceof ImageRendererJ3D) {
            this.myRenderer.setReUseFrames(on);
        }
    }
}

