/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.ScalarMapSet;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.ConstantMap;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.FieldImpl;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.TupleType;
import visad.VisADException;

public class ImageRGBDisplayable
extends DisplayableData
implements GridDisplayable {
    private volatile ScalarMap[] colorMaps = new ScalarMap[]{null, null, null};
    private volatile RealTupleType colorTupleType;
    private float[][] colorPalette;
    private DisplayRealType mapType = Display.RGB;
    private boolean doAlpha = false;

    public ImageRGBDisplayable(String name) throws VisADException, RemoteException {
        this(name, false);
    }

    public ImageRGBDisplayable(String name, boolean doAlpha) throws VisADException, RemoteException {
        this(name, BaseColorControl.initTableGreyWedge(new float[doAlpha ? 4 : 3][255]), doAlpha);
    }

    public ImageRGBDisplayable(String name, float[][] colorPalette, boolean doAlpha) throws VisADException, RemoteException {
        super(name);
        this.doAlpha = doAlpha;
        this.colorPalette = colorPalette;
        if (doAlpha) {
            this.mapType = Display.RGBA;
            this.colorMaps = new ScalarMap[]{null, null, null, null};
        }
        this.addConstantMaps(new ConstantMap[]{new ConstantMap(1.0, Display.ColorMode), new ConstantMap(1.0, Display.MissingTransparent)});
    }

    public ImageRGBDisplayable(String name, float[][] colorPalette, boolean doAlpha, FieldImpl field) throws VisADException, RemoteException {
        super(name);
        this.doAlpha = doAlpha;
        if (doAlpha) {
            this.mapType = Display.RGBA;
            this.colorMaps = new ScalarMap[]{null, null, null, null};
        }
        this.addConstantMaps(new ConstantMap[]{new ConstantMap(1.0, Display.ColorMode), new ConstantMap(1.0, Display.MissingTransparent)});
        if (field != null) {
            TupleType tt = GridUtil.getParamType(field);
            RealTupleType ffldType = new RealTupleType(tt.getRealComponents());
            if (this.getColorTupleType() == null || !ffldType.equals(this.getColorTupleType())) {
                this.setColorTupleType(ffldType);
            }
        }
    }

    protected ImageRGBDisplayable(ImageRGBDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.doAlpha = that.doAlpha;
        this.colorTupleType = that.colorTupleType;
        this.colorPalette = Set.copyFloats(that.colorPalette);
        if (this.colorTupleType != null) {
            this.setColorMaps();
        }
    }

    @Override
    public void loadData(FieldImpl field) throws VisADException, RemoteException {
        if (field == null) {
            return;
        }
        TupleType tt = GridUtil.getParamType(field);
        RealTupleType ffldType = new RealTupleType(tt.getRealComponents());
        if (this.getColorTupleType() == null || !ffldType.equals(this.getColorTupleType())) {
            this.setColorTupleType(ffldType);
        }
        this.setData(field);
    }

    public RealTupleType getColorTupleType() {
        return this.colorTupleType;
    }

    protected void setColorTupleType(RealTupleType realTupleType) throws RemoteException, VisADException {
        if (!realTupleType.equals(this.colorTupleType)) {
            RealTupleType oldValue = this.colorTupleType;
            this.colorTupleType = realTupleType;
            this.setColorMaps();
        }
    }

    public RealTupleType getRGBRealTupleType() {
        return this.colorTupleType;
    }

    protected void setScalarMaps(ScalarMapSet maps) throws BadMappingException {
        if (this.colorMaps[0] == null) {
            throw new BadMappingException(this.getClass().getName() + ".setScalarMaps(ScalarMapSet): " + "Color not yet set");
        }
        for (int i = 0; i < this.colorMaps.length; ++i) {
            maps.add(this.colorMaps[i]);
        }
        super.setScalarMapSet(maps);
    }

    public void setAlpha(float alpha) throws RemoteException, VisADException {
        this.addConstantMaps(new ConstantMap[]{new ConstantMap(alpha, Display.Alpha)});
    }

    private void setColorMaps() throws RemoteException, VisADException {
        int i;
        ScalarMapSet set = new ScalarMapSet();
        String[] pattern = new String[]{"red", "green", "blue"};
        for (i = 0; i < this.colorMaps.length; ++i) {
            this.colorMaps[i] = null;
        }
        if (this.colorTupleType.__len__() == 3 && this.colorMaps.length == 4) {
            RealType[] c_all = new RealType[]{RealType.getRealType("Red"), RealType.getRealType("Green"), RealType.getRealType("Blue"), RealType.getRealType("Alpha")};
            this.colorTupleType = new RealTupleType(c_all);
        }
        if (this.colorTupleType.getDimension() > 3) {
            block1: for (i = 0; i < pattern.length; ++i) {
                for (int tupleIdx = 0; tupleIdx < this.colorTupleType.getDimension(); ++tupleIdx) {
                    RealType rt = (RealType)this.colorTupleType.getComponent(tupleIdx);
                    if (rt.toString().indexOf(pattern[i]) < 0) continue;
                    this.colorMaps[i] = new ScalarMap(rt, this.mapType);
                    continue block1;
                }
            }
        }
        for (i = 0; i < this.colorMaps.length; ++i) {
            if (this.colorMaps[i] == null) {
                this.colorMaps[i] = new ScalarMap((RealType)this.colorTupleType.getComponent(i), this.mapType);
            }
            this.colorMaps[i].setRange(0.0, 255.0);
            set.add(this.colorMaps[i]);
            final int colorMapIndex = i;
            this.colorMaps[i].addScalarMapListener(new ScalarMapListener(){

                @Override
                public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                    block3: {
                        block2: {
                            int id = event.getId();
                            if (id == 3) break block2;
                            if (id != 5) break block3;
                        }
                        ImageRGBDisplayable.this.setColorsInControls(ImageRGBDisplayable.this.colorPalette, colorMapIndex);
                    }
                }

                @Override
                public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
                }
            });
        }
        this.setScalarMapSet(set);
        this.setColorsInControls(this.colorPalette);
    }

    @Override
    public void setDisplay(LocalDisplay display) throws DisplayException, VisADException, RemoteException {
        super.setDisplay(display);
        this.setColorsInControls(this.colorPalette);
    }

    @Override
    public void setColorPalette(float[][] colorPalette) throws RemoteException, VisADException {
        this.setColorsInControls(colorPalette);
        this.colorPalette = colorPalette;
    }

    public float[][] getColorPalette() {
        return this.colorPalette;
    }

    private void setColorsInControls(float[][] colorPalette) throws RemoteException, VisADException {
        for (int i = 0; i < this.colorMaps.length; ++i) {
            this.setColorsInControls(colorPalette, i);
        }
    }

    private void setColorsInControls(float[][] colorPalette, int colorMapIndex) throws RemoteException, VisADException {
        if (colorPalette == null) {
            return;
        }
        if (this.colorMaps[colorMapIndex] == null) {
            return;
        }
        BaseColorControl bcc = (BaseColorControl)this.colorMaps[colorMapIndex].getControl();
        if (bcc != null) {
            float[][] table = new float[this.colorMaps.length][colorPalette[0].length];
            table[colorMapIndex] = colorPalette[colorMapIndex];
            bcc.setTable(table);
        }
    }

    @Override
    public void setColoredByAnother(boolean yesno) {
    }
}

