/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.visad.display.Displayable;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.IsoSurface;
import visad.FieldImpl;
import visad.FlatField;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.util.DataUtility;

public class Grid3DDisplayable
extends IsoSurface
implements GridDisplayable {
    private boolean coloredByAnother = false;

    public Grid3DDisplayable(String name, boolean alphaflag) throws VisADException, RemoteException {
        super(name, null, alphaflag);
    }

    @Override
    protected boolean useDisplayUnitForColor() {
        return !this.coloredByAnother;
    }

    public void setGrid3D(FieldImpl field) throws VisADException, RemoteException {
        this.loadData(field);
    }

    @Override
    public void loadData(FieldImpl field) throws VisADException, RemoteException {
        FlatField ffld = null;
        ffld = GridUtil.isTimeSequence(field) ? (FlatField)field.getSample(0) : (FlatField)field;
        RealTupleType rtt = DataUtility.getFlatRangeType(ffld);
        RealType contourType = (RealType)rtt.getComponent(0);
        this.setContourRealType(contourType);
        RealType rgbType = this.coloredByAnother ? (RealType)rtt.getComponent(1) : contourType;
        this.setRGBRealType(rgbType);
        this.setData(field);
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return this;
    }

    @Override
    public void setColoredByAnother(boolean yesno) {
        this.coloredByAnother = yesno;
    }
}

