/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.visad.display.ConstantMapSet;
import ucar.visad.display.Displayable;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.RGBDisplayable;
import visad.ConstantMap;
import visad.DataRenderer;
import visad.Display;
import visad.Field;
import visad.FieldImpl;
import visad.RealType;
import visad.TupleType;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java3d.DefaultRendererJ3D;

public class Grid2DDisplayable
extends RGBDisplayable
implements GridDisplayable {
    private Field field;
    private DataRenderer myRenderer;
    private boolean isTextured = false;
    private boolean isMissingTransparent = true;
    private boolean useDefault = false;
    private int THRESHOLD = 500000;
    private int curvedSize = 10;

    public Grid2DDisplayable(String name, boolean alphaflag) throws VisADException, RemoteException {
        this(name, null, null, alphaflag);
    }

    public Grid2DDisplayable(String name, RealType rgbRealType, float[][] colorPalette, boolean alphaflag) throws VisADException, RemoteException {
        super(name, rgbRealType, colorPalette, alphaflag);
    }

    public void setGrid2D(FieldImpl field) throws VisADException, RemoteException {
        this.loadData(field);
    }

    protected Grid2DDisplayable(Grid2DDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.field = that.field;
        this.isTextured = that.isTextured;
        this.isMissingTransparent = that.isMissingTransparent;
        this.useDefault = that.useDefault;
        this.setTextureProperties((FieldImpl)this.field);
    }

    @Override
    public void loadData(FieldImpl field) throws VisADException, RemoteException {
        TupleType tt = GridUtil.getParamType(field);
        RealType ffldType = tt.getRealComponents()[0];
        if (this.getRGBRealType() == null || !ffldType.equals(this.getRGBRealType())) {
            this.setRGBRealType(ffldType);
        }
        this.field = field;
        this.setTextureProperties(field);
        this.setData(this.field);
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new Grid2DDisplayable(this);
    }

    @Override
    protected DataRenderer getDataRenderer() throws VisADException {
        try {
            if (this.getDisplay().getDisplayRenderer() instanceof DisplayRendererJ2D) {
                this.myRenderer = new DefaultRendererJ2D();
            } else if (this.getData() != null && ImageRendererJ3D.isImageType(this.getData().getType()) && this.getTextureEnable() && !this.getUseDefaultRenderer() && !this.getUseRGBTypeForSelect()) {
                this.myRenderer = new ImageRendererJ3D();
                ((ImageRendererJ3D)this.myRenderer).setReUseFrames(false);
            } else {
                this.myRenderer = new DefaultRendererJ3D();
            }
        }
        catch (RemoteException re) {
            this.myRenderer = super.getDataRenderer();
        }
        return this.myRenderer;
    }

    public void setTextureEnable(boolean enable) throws VisADException, RemoteException {
        this.isTextured = enable;
        this.setTextureProperties(null);
    }

    @Override
    protected void myAddConstantMaps(ConstantMap[] newMaps) throws VisADException, RemoteException {
        if (this.myRenderer != null) {
            String c = this.myRenderer.getClass().getName();
            if (c.equals("visad.bom.ImageRendererJ3D") && !this.isTextured || c.equals("visad.java3d.DefaultRendererJ3D") && !this.isTextured) {
                this.setDisplayInactive();
                this.removeDataReferences();
                this.addDataReferences();
                this.setDisplayActive();
            } else {
                super.myAddConstantMaps(newMaps);
            }
        } else {
            super.myAddConstantMaps(newMaps);
        }
    }

    protected ConstantMap makeTextureMap(boolean enable) throws VisADException, RemoteException {
        return new ConstantMap(enable ? 1.0 : 0.0, Display.TextureEnable);
    }

    public boolean getTextureEnable() {
        return this.isTextured;
    }

    public void setMissingTransparent(boolean enable) throws VisADException, RemoteException {
        this.isMissingTransparent = enable;
        this.addConstantMap(new ConstantMap(enable ? 1.0 : 0.0, Display.MissingTransparent));
    }

    public boolean getMissingTransparent() {
        return this.isMissingTransparent;
    }

    public void setUseDefaultRenderer(boolean use) {
        this.useDefault = use;
    }

    public boolean getUseDefaultRenderer() {
        return this.useDefault;
    }

    public void setTextureProperties(FieldImpl grid) throws VisADException, RemoteException {
        FieldImpl fi;
        FieldImpl fieldImpl = fi = grid == null ? (FieldImpl)this.getData() : grid;
        if (fi == null) {
            return;
        }
        int dfltCurvedSize = this.curvedSize;
        float dataSize = GridUtil.getSpatialDomain(fi).getLength();
        ConstantMapSet maps = new ConstantMapSet();
        if (!(dataSize > (float)this.THRESHOLD) || !this.isTextured) {
            // empty if block
        }
        if (this.isTextured) {
            maps.put(this.makeCurvedSizeMap(dfltCurvedSize));
        }
        maps.put(this.makeTextureMap(this.isTextured));
        this.addConstantMaps(maps.getConstantMaps());
    }

    @Override
    public void setColoredByAnother(boolean yesno) {
    }

    @Override
    public void setCurvedSize(int size) {
        this.curvedSize = size;
        try {
            this.setTextureProperties(null);
        }
        catch (Exception e) {
            System.err.println("couldn't set curved size");
        }
    }

    @Override
    public int getCurvedSize() {
        return this.curvedSize;
    }
}

