/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import ucar.visad.Util;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.ScalarMapSet;
import visad.ConstantMap;
import visad.Data;
import visad.DelaunayCustom;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Irregular2DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SetType;
import visad.VisADError;
import visad.VisADException;
import visad.java3d.MouseBehaviorJ3D;

public class FrontDrawer
extends DisplayableData {
    private static int count = 0;
    public static final String TYPE_COLD_FRONT = "COLD_FRONT";
    public static final String TYPE_WARM_FRONT = "WARM_FRONT";
    public static final String TYPE_OCCLUDED_FRONT = "OCCLUDED_FRONT";
    public static final String TYPE_STATIONARY_FRONT = "STATIONARY_FRONT";
    public static final String TYPE_CONVERGENCE = "CONVERGENCE";
    public static final String TYPE_FRONTOGENESIS = "FRONTOGENESIS";
    public static final String TYPE_FRONTOLYSIS = "FRONTOLYSIS";
    public static final String TYPE_UPPER_COLD_FRONT = "UPPER_COLD_FRONT";
    public static final String TYPE_UPPER_WARM_FRONT = "UPPER_WARM_FRONT";
    public static final String TYPE_TROUGH = "TROUGH";
    public static final String TYPE_RIDGE = "RIDGE";
    public static final String TYPE_MOISTURE = "MOISTURE";
    public static final String TYPE_LOW_LEVEL_JET = "LOW_LEVEL_JET";
    public static final String TYPE_UPPER_LEVEL_JET = "UPPER_LEVEL_JET";
    public static final String TYPE_DRY_LINE = "DRY_LINE";
    public static final String TYPE_WAVE_LINE = "WAVE_LINE";
    public static final String TYPE_TOTAL_TOTALS = "TOTAL_TOTALS";
    public static final String TYPE_LIFTED_INDEX = "LIFTED_INDEX";
    public static final String TYPE_ISOTHERMS = "ISOTHERMS";
    public static final String TYPE_THICKNESS_RIDGE = "THICKNESS_RIDGE";
    public static final String TYPE_LOWER_THERMAL_TROUGH = "LOWER_THERMAL_TROUGH";
    public static final String TYPE_UPPER_THERMAL_TROUGH = "UPPER_THERMAL_TROUGH";
    public static final String TYPE_UNEVEN_LOW_LEVEL_JET = "UNEVEN_LOW_LEVEL_JET";
    public static final String[] BASETYPES = new String[]{"COLD_FRONT", "WARM_FRONT", "OCCLUDED_FRONT", "STATIONARY_FRONT", "TROUGH", "WAVE_LINE"};
    public static final String[] TYPES = new String[]{"COLD_FRONT", "WARM_FRONT", "OCCLUDED_FRONT", "STATIONARY_FRONT", "CONVERGENCE", "FRONTOGENESIS", "FRONTOLYSIS", "UPPER_COLD_FRONT", "UPPER_WARM_FRONT", "TROUGH", "RIDGE", "MOISTURE", "LOW_LEVEL_JET", "UPPER_LEVEL_JET", "DRY_LINE", "TOTAL_TOTALS", "LIFTED_INDEX", "ISOTHERMS", "THICKNESS_RIDGE", "LOWER_THERMAL_TROUGH", "UPPER_THERMAL_TROUGH", "UNEVEN_LOW_LEVEL_JET", "WAVE_LINE"};
    public static final String[] LABELS = new String[]{"Cold front", "Warm front", "Occluded front", "Stationary front", "Convergence", "Frontogenesis", "Frontolysis", "Upper cold front", "Upper warm front", "Trough", "Ridge", "Moisture", "Low level jet", "Upper level jet", "Dry line", "Total totals", "Lifted index", "Isotherms", "Thickness ridge", "Lower thermal trough", "Upper thermal trough", "Uneven low level jet", "Wave line"};
    private static final float[] rsegmentarray = new float[]{0.2f, 0.2f, 0.15f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.05f, 0.1f, 0.05f, 0.2f, 0.2f, 0.1f, 0.05f, 0.1f, 0.15f, 0.1f, 0.05f, 0.1f, 0.1f, 0.1f};
    private static final float[] fsegmentarray = new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.05f, 0.1f, 0.05f, 0.2f, 0.2f, 0.1f, 0.05f, 0.1f, 0.15f, 0.1f, 0.05f, 0.1f, 0.2f, 0.1f};
    private static final float[][][][] rshapesarray = new float[][][][]{new float[][][]{new float[][]{{0.0f, 0.025f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.025f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.04f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.07f, 0.0525f, 0.035f, 0.0175f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.03f, 0.037f, 0.03f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.025f, 0.05f, 0.07f, 0.105f, 0.14f, 0.17f, 0.2f, 0.2f, 0.17f, 0.14f, 0.1225f, 0.105f, 0.0875f, 0.07f, 0.05f, 0.025f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.03f, 0.037f, 0.03f, 0.01f, 0.01f, 0.04f, 0.01f}}}, new float[][][]{new float[][]{{0.09f, 0.11f, 0.1275f, 0.145f, 0.1625f, 0.18f, 0.2f, 0.2f, 0.1775f, 0.155f, 0.1175f, 0.09f}, {0.0f, 0.0f, -0.02f, -0.027f, -0.02f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, new float[][]{{0.0f, 0.02f, 0.045f, 0.07f, 0.09f, 0.09f, 0.07f, 0.045f, 0.02f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.04f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.03f, 0.035f, 0.01f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.11f, 0.135f, 0.13f, 0.1f, 0.05f, 0.0f}, {0.01f, 0.04f, 0.035f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.0f, 0.0f, 0.0f, -0.025f, -0.03f, 0.0f, 0.0f, 0.0f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.15f, 0.1f, 0.0875f, 0.075f, 0.0625f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.025f, 0.035f, 0.025f, 0.01f, 0.01f}}, new float[][]{{0.16f, 0.19f, 0.19f, 0.16f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.07f, 0.1f, 0.15f, 0.15f, 0.1f, 0.0875f, 0.075f, 0.0625f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.025f, 0.035f, 0.025f, 0.01f, 0.01f}}, new float[][]{{0.16f, 0.17f, 0.17f, 0.18f, 0.18f, 0.19f, 0.19f, 0.18f, 0.18f, 0.17f, 0.17f, 0.16f}, {0.0f, 0.0f, -0.01f, -0.01f, 0.0f, 0.0f, 0.01f, 0.01f, 0.02f, 0.02f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, new float[][]{{0.0f, 0.03f, 0.06f, 0.05f, 0.03f, 0.01f}, {0.01f, 0.04f, 0.01f, 0.01f, 0.03f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}, new float[][]{{0.0f, 0.015f, 0.03f, 0.045f, 0.06f, 0.05f, 0.04f, 0.03f, 0.02f, 0.01f}, {0.01f, 0.03f, 0.037f, 0.03f, 0.01f, 0.01f, 0.023f, 0.027f, 0.023f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.035f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.1f, 0.05f, 0.0f}, {0.04f, -0.06f, 0.04f, 0.06f, -0.04f, 0.06f}}}, new float[][][]{new float[][]{{0.0f, 0.0f, 0.01f, 0.01f, 0.05f, 0.05f, 0.0f}, {0.01f, 0.05f, 0.05f, 0.01f, 0.01f, 0.0f, 0.0f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.0f}, {-0.01f, -0.01f, -0.01f, -0.01f, -0.01f, 0.02f, 0.02f, 0.02f, 0.02f, 0.02f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}, new float[][]{{0.06f, 0.09f, 0.09f, 0.06f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, new float[][][]{new float[][]{{0.0f, 0.035f, 0.035f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.01f, 0.01f}}, new float[][]{{0.06f, 0.09f, 0.09f, 0.06f}, {-0.005f, -0.005f, 0.015f, 0.015f}}}, new float[][][]{new float[][]{{0.0f, 0.0f, 0.04f, 0.08f, 0.08f, 0.04f, 0.0f, 0.0f, 0.02f, 0.02f, 0.06f, 0.06f, 0.02f, 0.02f}, {0.0f, -0.02f, -0.02f, -0.02f, 0.02f, 0.02f, 0.02f, 0.0f, 0.0f, 0.01f, 0.01f, -0.01f, -0.01f, 0.0f}}}, new float[][][]{new float[][]{{0.0f, 0.025f, 0.05f, 0.075f, 0.1f, 0.1f, 0.075f, 0.05f, 0.025f, 0.0f}, {0.01f, 0.03f, 0.037f, 0.03f, 0.01f, 0.02f, 0.04f, 0.047f, 0.04f, 0.02f}}}, new float[][][]{new float[][]{{0.0f, 0.045f, 0.045f, 0.0f}, {-0.01f, -0.01f, 0.02f, 0.02f}}}, new float[][][]{new float[][]{{0.0f, 0.04f, 0.02f}, {0.0f, 0.0f, 0.04f}}}, new float[][][]{new float[][]{{0.0f, 0.05f, 0.1f, 0.1f, 0.05f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.025f, 0.05f, 0.075f, 0.1f, 0.1f, 0.075f, 0.05f, 0.025f, 0.0f}, {0.01f, 0.03f, 0.037f, 0.03f, 0.01f, 0.02f, 0.04f, 0.047f, 0.04f, 0.02f}}}};
    private static final float[][] rredarray = new float[][]{{0.0f}, {1.0f}, {1.0f}, {1.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.5f}, {0.5f}, {1.0f}, {0.5f}, {0.5f}, {0.5f, 0.5f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}, {0.5f}, {0.5f}};
    private static final float[][] rgreenarray = new float[][]{{0.0f}, {0.0f}, {0.0f}, {0.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.3f}, {0.3f}, {1.0f}, {0.5f}, {0.5f}, {0.3f, 0.3f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}, {0.5f}, {0.5f}};
    private static final float[][] rbluearray = new float[][]{{1.0f}, {0.0f}, {1.0f}, {0.0f, 1.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}, {0.0f}, {0.0f}, {1.0f}, {1.0f}, {1.0f}, {0.0f, 0.0f}, {1.0f}, {1.0f, 1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}, {1.0f}};
    private static final float[][][][] fshapesarray = new float[][][][]{(float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, new float[][][]{new float[][]{{0.0f, 0.07f, 0.075f, 0.01f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.01f, 0.075f, 0.07f, 0.0f}, {0.0f, -0.07f, -0.065f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.075f, 0.08f, 0.01f}}}, new float[][][]{new float[][]{{0.0f, 0.06f, 0.077f, 0.04f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.04f, 0.077f, 0.06f, 0.0f}, {-0.001f, -0.06f, -0.04f, -0.01f, -0.01f, -0.01f, -0.01f, -0.01f, 0.02f, 0.02f, 0.02f, 0.02f, 0.02f, 0.05f, 0.07f, 0.02f}}}, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, (float[][][])null, new float[][][]{new float[][]{{0.0f, 0.07f, 0.075f, 0.01f, 0.05f, 0.1f, 0.15f, 0.2f, 0.2f, 0.15f, 0.1f, 0.05f, 0.01f, 0.075f, 0.07f, 0.0f}, {0.0f, -0.07f, -0.065f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f, 0.01f, 0.01f, 0.075f, 0.08f, 0.01f}}}, (float[][][])null};
    private static final float[][] fredarray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {0.5f}, {0.5f}, null, null, null, null, null, null, null, {0.5f}, null};
    private static final float[][] fgreenarray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {0.5f}, {0.5f}, null, null, null, null, null, null, null, {0.5f}, null};
    private static final float[][] fbluearray = new float[][]{null, null, null, null, null, null, null, null, null, null, null, null, {1.0f}, {1.0f}, null, null, null, null, null, null, null, {1.0f}, null};
    private static final int LAT_INDEX = 0;
    private static final int LON_INDEX = 1;
    private float[][] curve;
    private List curveTimes;
    private static final float CLIP_DELTA = 0.001f;
    private boolean debug = true;
    private float zoom = 1.0f;
    private float last_zoom = 1.0f;
    private ScalarMap latMap = null;
    private ScalarMap lonMap = null;
    private SetType curve_type = null;
    private FunctionType fronts_type = null;
    private FunctionType front_type = null;
    private FunctionType front_inner = null;
    private RealType front_index = null;
    private RealType front_red = null;
    private RealType front_green = null;
    private RealType front_blue = null;
    private int nfshapes = -1;
    private float[][][] first_shapes = null;
    private int[][][] first_tris = null;
    private float[] first_red = null;
    private float[] first_green = null;
    private float[] first_blue = null;
    private int nrshapes = -1;
    private float[][][] repeat_shapes = null;
    private int[][][] repeat_tris = null;
    private float[] repeat_red = null;
    private float[] repeat_green = null;
    private float[] repeat_blue = null;
    private float fsegment_length;
    private float rsegment_length;
    private int fprofile_length = -1;
    private int rprofile_length = -1;
    private int filter_window = 1;
    private boolean doColors = true;
    private boolean flipTheFlip = true;
    public double baseScale = 15.0;

    public FrontDrawer(int fw, String frontType) throws VisADException, RemoteException {
        this(fw, frontType, true);
    }

    private FrontDrawer(int fw, int frontType) throws VisADException, RemoteException {
        this(fw, frontType, true);
    }

    public FrontDrawer(int fw, String frontType, boolean doColors) throws VisADException, RemoteException {
        this(fw, FrontDrawer.getIndex(frontType), doColors);
    }

    private FrontDrawer(int fw, int frontType, boolean doColors) throws VisADException, RemoteException {
        super("FrontDrawer");
        this.doColors = doColors;
        this.filter_window = fw;
        this.setFrontType(frontType);
        this.initColorMaps();
    }

    public FrontDrawer(FrontDrawer that) throws RemoteException, VisADException {
        super("FrontDrawer");
        this.doColors = that.doColors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColor(Color color) throws VisADException, RemoteException {
        FrontDrawer frontDrawer = this;
        synchronized (frontDrawer) {
            this.addConstantMaps(new ConstantMap[]{new ConstantMap((double)color.getRed() / 255.0, Display.Red), new ConstantMap((double)color.getGreen() / 255.0, Display.Green), new ConstantMap((double)color.getBlue() / 255.0, Display.Blue), new ConstantMap((double)color.getAlpha() / 255.0, Display.Alpha)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLineWidth(float lineWidth) throws VisADException, RemoteException {
        FrontDrawer frontDrawer = this;
        synchronized (frontDrawer) {
            this.addConstantMap(new ConstantMap(lineWidth, Display.LineWidth));
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new FrontDrawer(this);
    }

    public void setScale(double baseScale) throws VisADException, RemoteException {
        this.baseScale = baseScale;
        if (this.getDisplayMaster() == null) {
            return;
        }
        ProjectionControl pcontrol = this.getDisplayMaster().getDisplay().getProjectionControl();
        if (pcontrol == null) {
            return;
        }
        double[] matrix = pcontrol.getMatrix();
        double[] rot = new double[3];
        double[] scale = new double[1];
        double[] trans = new double[3];
        MouseBehaviorJ3D.unmake_matrix(rot, scale, trans, matrix);
        this.zoom = (float)scale[0] / (float)baseScale;
    }

    private static int getIndex(String name) {
        if (name == null) {
            return -1;
        }
        name = name.toUpperCase();
        for (int i = 0; i < TYPES.length; ++i) {
            if (!name.equals(TYPES[i])) continue;
            return i;
        }
        return -1;
    }

    public static String getLabel(String type) {
        int index = FrontDrawer.getIndex(type);
        if (index >= 0) {
            return LABELS[index];
        }
        return null;
    }

    public void setFrontType(String type) throws VisADException, RemoteException {
        this.setFrontType(FrontDrawer.getIndex(type));
    }

    private void setFrontType(int type) throws VisADException, RemoteException {
        this.setFrontState(fsegmentarray[type], rsegmentarray[type], fshapesarray[type], fredarray[type], fgreenarray[type], fbluearray[type], rshapesarray[type], rredarray[type], rgreenarray[type], rbluearray[type]);
    }

    private void setFrontState(float fsegment, float rsegment, float[][][] fshapes, float[] fred, float[] fgreen, float[] fblue, float[][][] rshapes, float[] rred, float[] rgreen, float[] rblue) throws VisADException, RemoteException {
        int i;
        int i2;
        this.fsegment_length = fsegment;
        this.rsegment_length = rsegment;
        this.nrshapes = rshapes.length;
        for (i2 = 0; i2 < this.nrshapes; ++i2) {
            if (rshapes[i2] != null && rshapes[i2].length == 2 && rshapes[i2][0] != null && rshapes[i2][1] != null && rshapes[i2][0].length == rshapes[i2][1].length) continue;
            throw new VisADException("bad rshapes[" + i2 + "]");
        }
        if (rred == null || rred.length != this.nrshapes || rgreen == null || rgreen.length != this.nrshapes || rblue == null || rblue.length != this.nrshapes) {
            throw new VisADException("bad rcolors");
        }
        this.repeat_tris = new int[this.nrshapes][][];
        for (i2 = 0; i2 < this.nrshapes; ++i2) {
            this.repeat_tris[i2] = DelaunayCustom.fill(rshapes[i2]);
        }
        this.repeat_shapes = new float[this.nrshapes][2][];
        int rlen = 0;
        for (i = 0; i < this.nrshapes; ++i) {
            int n = rshapes[i][0].length;
            rlen += n;
            this.repeat_shapes[i][0] = new float[n];
            this.repeat_shapes[i][1] = new float[n];
            System.arraycopy(rshapes[i][0], 0, this.repeat_shapes[i][0], 0, n);
            System.arraycopy(rshapes[i][1], 0, this.repeat_shapes[i][1], 0, n);
        }
        this.rprofile_length = rlen;
        this.repeat_red = new float[this.nrshapes];
        this.repeat_green = new float[this.nrshapes];
        this.repeat_blue = new float[this.nrshapes];
        System.arraycopy(rred, 0, this.repeat_red, 0, this.nrshapes);
        System.arraycopy(rgreen, 0, this.repeat_green, 0, this.nrshapes);
        System.arraycopy(rblue, 0, this.repeat_blue, 0, this.nrshapes);
        if (fshapes == null) {
            this.nfshapes = this.nrshapes;
            this.first_tris = this.repeat_tris;
            this.first_shapes = this.repeat_shapes;
            this.first_red = this.repeat_red;
            this.first_green = this.repeat_green;
            this.first_blue = this.repeat_blue;
        } else {
            this.nfshapes = fshapes.length;
            for (i = 0; i < this.nfshapes; ++i) {
                if (fshapes[i] != null && fshapes[i].length == 2 && fshapes[i][0] != null && fshapes[i][1] != null && fshapes[i][0].length == fshapes[i][1].length) continue;
                throw new VisADException("bad fshapes[" + i + "]");
            }
            if (fred == null || fred.length != this.nfshapes || fgreen == null || fgreen.length != this.nfshapes || fblue == null || fblue.length != this.nfshapes) {
                throw new VisADException("bad fcolors");
            }
            this.first_tris = new int[this.nfshapes][][];
            for (i = 0; i < this.nfshapes; ++i) {
                this.first_tris[i] = DelaunayCustom.fill(fshapes[i]);
            }
            this.first_shapes = new float[this.nfshapes][2][];
            int flen = 0;
            for (int i3 = 0; i3 < this.nfshapes; ++i3) {
                int n = fshapes[i3][0].length;
                flen += n;
                this.first_shapes[i3][0] = new float[n];
                this.first_shapes[i3][1] = new float[n];
                System.arraycopy(fshapes[i3][0], 0, this.first_shapes[i3][0], 0, n);
                System.arraycopy(fshapes[i3][1], 0, this.first_shapes[i3][1], 0, n);
            }
            this.fprofile_length = flen;
            this.first_red = new float[this.nfshapes];
            this.first_green = new float[this.nfshapes];
            this.first_blue = new float[this.nfshapes];
            System.arraycopy(fred, 0, this.first_red, 0, this.nfshapes);
            System.arraycopy(fgreen, 0, this.first_green, 0, this.nfshapes);
            System.arraycopy(fblue, 0, this.first_blue, 0, this.nfshapes);
        }
        if (this.rprofile_length < 5) {
            this.rprofile_length = 5;
        }
        if (this.fprofile_length < 5) {
            this.fprofile_length = 5;
        }
    }

    private ScalarMap getLatMap() throws VisADException, RemoteException {
        if (this.latMap == null) {
            this.initLatLonMap();
        }
        return this.latMap;
    }

    private ScalarMap getLonMap() throws VisADException, RemoteException {
        if (this.lonMap == null) {
            this.initLatLonMap();
        }
        return this.lonMap;
    }

    @Override
    protected void setDisplayMaster(DisplayMaster master) throws VisADException, RemoteException {
        super.setDisplayMaster(master);
        if (this.latMap == null && this.curve != null) {
            this.setCurve(this.curve, this.curveTimes);
        }
    }

    public void setCurve(float[][] curve, List curveTimes) throws VisADException, RemoteException {
        this.curve = curve;
        this.curveTimes = curveTimes;
        FieldImpl front = this.makeFront(curve);
        if (front != null) {
            this.setData(Util.makeTimeRangeField(front, curveTimes));
        }
    }

    public void initLatLonMap() throws VisADException, RemoteException {
        if (this.latMap != null) {
            return;
        }
        if (this.getDisplayMaster() == null) {
            return;
        }
        boolean callScale = this.latMap == null;
        DisplayImpl display = (DisplayImpl)this.getDisplayMaster().getDisplay();
        this.latMap = null;
        this.lonMap = null;
        Vector scalar_map_vector = display.getMapVector();
        Enumeration en = scalar_map_vector.elements();
        while (en.hasMoreElements()) {
            ScalarMap map = (ScalarMap)en.nextElement();
            DisplayRealType real = map.getDisplayScalar();
            DisplayTupleType tuple = real.getTuple();
            if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            if (RealType.Latitude.equals(map.getScalar())) {
                this.latMap = map;
                continue;
            }
            if (!RealType.Longitude.equals(map.getScalar())) continue;
            this.lonMap = map;
        }
        if (callScale) {
            this.setScale(this.baseScale);
        }
    }

    private void initColorMaps() throws VisADException, RemoteException {
        this.setupTypes();
        if (this.doColors) {
            ScalarMap rmap = new ScalarMap(this.front_red, Display.Red);
            rmap.setRange(0.0, 1.0);
            ScalarMap gmap = new ScalarMap(this.front_green, Display.Green);
            gmap.setRange(0.0, 1.0);
            ScalarMap bmap = new ScalarMap(this.front_blue, Display.Blue);
            bmap.setRange(0.0, 1.0);
            ScalarMapSet maps = this.getScalarMapSet();
            maps.add(rmap);
            maps.add(bmap);
            maps.add(gmap);
            this.setScalarMapSet(maps);
        }
    }

    private void setupTypes() throws VisADException {
        if (this.curve_type == null) {
            RealTupleType latlon = RealTupleType.LatitudeLongitudeTuple;
            this.curve_type = new SetType(latlon);
            this.front_index = RealType.getRealType("front_index" + ++count);
            this.front_red = RealType.getRealType("front_red" + count);
            this.front_green = RealType.getRealType("front_green" + count);
            this.front_blue = RealType.getRealType("front_blue" + count);
            RealTupleType rgb = new RealTupleType(this.front_red, this.front_green, this.front_blue);
            this.front_inner = new FunctionType(latlon, rgb);
            this.front_type = new FunctionType(this.front_index, this.front_inner);
            this.fronts_type = new FunctionType(RealType.Time, this.front_type);
        }
    }

    public FieldImpl makeFront(float[][] curve_samples) throws VisADException, RemoteException {
        boolean flip = true;
        this.initLatLonMap();
        if (this.latMap == null) {
            return null;
        }
        double[] lat_range = this.getLatMap().getRange();
        double[] lon_range = this.getLonMap().getRange();
        if (lat_range[1] < lat_range[0]) {
            boolean bl = flip = !flip;
        }
        if (lon_range[1] < lon_range[0]) {
            boolean bl = flip = !flip;
        }
        if ((double)curve_samples[0][0] < 0.0) {
            flip = !flip;
        }
        float[][] curve = new float[][]{this.getLatMap().scaleValues(curve_samples[0]), this.getLonMap().scaleValues(curve_samples[1])};
        return this.robustCurveToFront(curve, flip);
    }

    public FieldImpl robustCurveToFront(float[][] curve, boolean flip) throws RemoteException {
        float increment = this.rsegment_length / ((float)this.rprofile_length * this.zoom);
        float[][] oldCurve = null;
        try {
            oldCurve = FrontDrawer.resample_curve(curve, increment);
        }
        catch (VisADError ve) {
            return null;
        }
        int fw = this.filter_window;
        fw = 1;
        FieldImpl front = null;
        float[][] originalCurve = curve;
        this.debug = true;
        for (int tries = 0; tries < 12; ++tries) {
            curve = FrontDrawer.smooth_curve(oldCurve, fw);
            curve = FrontDrawer.resample_curve(curve, increment);
            try {
                front = this.curveToFront(curve, flip);
                break;
            }
            catch (VisADException e) {
                int n;
                oldCurve = curve;
                if (tries > 4 && (n = oldCurve[0].length) > 2) {
                    float[][] no = new float[2][n - 2];
                    System.arraycopy(oldCurve[0], 1, no[0], 0, n - 2);
                    System.arraycopy(oldCurve[1], 1, no[1], 0, n - 2);
                    oldCurve = no;
                }
                if (tries > 8) {
                    fw = 2 * fw;
                }
                if (tries != 9) continue;
                front = null;
                continue;
            }
        }
        return front;
    }

    private FieldImpl curveToFront(float[][] curve, boolean flip) throws VisADException, RemoteException {
        int len;
        if (this.flipTheFlip) {
            boolean bl = flip = !flip;
        }
        if ((len = curve[0].length) < 2) {
            return null;
        }
        float[] seg_length = new float[len - 1];
        float curve_length = FrontDrawer.curveLength(curve, seg_length);
        float delta = curve_length / (float)(len - 1);
        float mul = (float)this.rprofile_length * this.zoom / this.rsegment_length;
        float ratio = delta * mul;
        float[][] curve_perp = new float[2][len];
        for (int i = 0; i < len; ++i) {
            int im = i - 1;
            int ip = i + 1;
            if (im < 0) {
                im = 0;
            }
            if (ip > len - 1) {
                ip = len - 1;
            }
            float yp = curve[0][ip] - curve[0][im];
            float xp = curve[1][ip] - curve[1][im];
            xp = -xp;
            float d = (float)Math.sqrt(xp * xp + yp * yp);
            if (flip) {
                d = -d;
            }
            curve_perp[0][i] = xp /= d;
            curve_perp[1][i] = yp /= d;
        }
        Vector<FlatField> inner_field_vector = new Vector<FlatField>();
        int segment = 0;
        while (true) {
            float segment_length = segment == 0 ? this.fsegment_length : this.rsegment_length;
            int profile_length = segment == 0 ? this.fprofile_length : this.rprofile_length;
            mul = (float)profile_length * this.zoom / segment_length;
            boolean clip = false;
            float xclip = 0.0f;
            int ibase = segment == 0 ? 0 : this.fprofile_length + (segment - 1) * this.rprofile_length;
            int iend = ibase + profile_length;
            if (ibase > len - 1) break;
            if (iend > len - 1) {
                clip = true;
                iend = len - 1;
                xclip = (float)(iend - ibase) / mul;
            }
            int nshapes = this.nrshapes;
            float[][][] shapes = this.repeat_shapes;
            int[][][] tris = this.repeat_tris;
            float[] red = this.repeat_red;
            float[] green = this.repeat_green;
            float[] blue = this.repeat_blue;
            if (segment == 0) {
                nshapes = this.nfshapes;
                shapes = this.first_shapes;
                tris = this.first_tris;
                red = this.first_red;
                green = this.first_green;
                blue = this.first_blue;
            }
            for (int shape = 0; shape < nshapes; ++shape) {
                float[][] samples = shapes[shape];
                int[][] ts = tris[shape];
                if (samples == null || samples[0].length < 1) break;
                float[][] ss = this.mapShape(samples, len, ibase, mul, ratio, curve, curve_perp);
                ts = DelaunayCustom.fill(ss);
                boolean DOCLIP = false;
                if (clip && DOCLIP) {
                    float[][] clip_samples = new float[][]{{xclip, xclip, xclip - 0.001f}, {0.001f, -0.001f, 0.0f}};
                    float[][] clip_ss = this.mapShape(clip_samples, len, ibase, mul, ratio, curve, curve_perp);
                    float det = clip_samples[0][1] * clip_samples[1][0] - clip_samples[0][0] * clip_samples[1][1];
                    float xc = (clip_samples[1][0] - clip_samples[1][1]) / det;
                    float yc = (clip_samples[0][1] - clip_samples[0][0]) / det;
                    float v = 1.0f;
                    if (xc * clip_samples[0][2] + yc * clip_samples[1][2] > v) {
                        xc = -xc;
                        yc = -yc;
                        v = -v;
                    }
                    float[][][] outs = new float[1][][];
                    int[][][] outt = new int[1][][];
                    DelaunayCustom.clip(ss, ts, xc, yc, v, outs, outt);
                    ss = outs[0];
                    ts = outt[0];
                }
                if (ss == null) break;
                int n = ss[0].length;
                float[][] values = new float[3][n];
                float r = red[shape];
                float g = green[shape];
                float b = blue[shape];
                for (int i = 0; i < n; ++i) {
                    values[0][i] = r;
                    values[1][i] = g;
                    values[2][i] = b;
                }
                DelaunayCustom delaunay = new DelaunayCustom(ss, ts);
                Irregular2DSet set = new Irregular2DSet(this.curve_type, ss, null, null, null, delaunay);
                FlatField field = new FlatField(this.front_inner, set);
                field.setSamples(values, false);
                inner_field_vector.addElement(field);
            }
            ++segment;
        }
        int nfields = inner_field_vector.size();
        Integer1DSet iset = new Integer1DSet((MathType)this.front_index, nfields);
        FieldImpl front = new FieldImpl(this.front_type, iset);
        Data[] fields = new FlatField[nfields];
        for (int i = 0; i < nfields; ++i) {
            fields[i] = (FlatField)inner_field_vector.elementAt(i);
        }
        front.setSamples(fields, false);
        return front;
    }

    private float[][] mapShape(float[][] samples, int len, int ibase, float mul, float ratio, float[][] curve, float[][] curve_perp) throws VisADException, RemoteException {
        int n = samples[0].length;
        float[][] ss = new float[2][n];
        for (int i = 0; i < n; ++i) {
            float a;
            float findex = (float)ibase + mul * samples[0][i] / this.zoom;
            int il = (int)findex;
            int ih = il + 1;
            if (il < 0) {
                il = 0;
                ih = il + 1;
            }
            if (ih > len - 1) {
                ih = len - 1;
                il = ih - 1;
            }
            if ((a = findex - (float)il) < -1.0f) {
                a = -1.0f;
            }
            if (a > 2.0f) {
                a = 2.0f;
            }
            float b = 1.0f - a;
            float xl = curve[0][il] + ratio * samples[1][i] * curve_perp[0][il] / this.zoom;
            float yl = curve[1][il] + ratio * samples[1][i] * curve_perp[1][il] / this.zoom;
            float xh = curve[0][ih] + ratio * samples[1][i] * curve_perp[0][ih] / this.zoom;
            float yh = curve[1][ih] + ratio * samples[1][i] * curve_perp[1][ih] / this.zoom;
            ss[0][i] = b * xl + a * xh;
            ss[1][i] = b * yl + a * yh;
        }
        ss[0] = this.getLatMap().inverseScaleValues(ss[0]);
        ss[1] = this.getLonMap().inverseScaleValues(ss[1]);
        return ss;
    }

    public static float[][] smooth_curve(float[][] curve, int window) {
        int len = curve[0].length;
        float[][] newcurve = new float[2][len];
        for (int i = 0; i < len; ++i) {
            int ii;
            int win = window;
            if (i < win) {
                win = i;
            }
            if ((ii = len - 1 - i) < win) {
                win = ii;
            }
            float runx = 0.0f;
            float runy = 0.0f;
            for (int j = i - win; j <= i + win; ++j) {
                runx += curve[0][j];
                runy += curve[1][j];
            }
            newcurve[0][i] = runx / (float)(2 * win + 1);
            newcurve[1][i] = runy / (float)(2 * win + 1);
        }
        return newcurve;
    }

    public static float[][] resample_curve(float[][] curve, float increment) {
        int len = curve[0].length;
        float[] seg_length = new float[len - 1];
        float curve_length = FrontDrawer.curveLength(curve, seg_length);
        int npoints = 1 + (int)(curve_length / increment);
        float delta = curve_length / (float)(npoints - 1);
        float[][] newcurve = new float[2][npoints];
        newcurve[0][0] = curve[0][0];
        newcurve[1][0] = curve[1][0];
        if (npoints < 2) {
            return newcurve;
        }
        int k = 0;
        float old_seg = seg_length[k];
        for (int i = 1; i < npoints - 1; ++i) {
            float new_seg;
            for (new_seg = delta; old_seg < new_seg; new_seg -= old_seg) {
                if (++k > len - 2) {
                    throw new VisADError("k = " + k + " i = " + i);
                }
                old_seg = seg_length[k];
            }
            float a = (old_seg -= new_seg) / seg_length[k];
            newcurve[0][i] = a * curve[0][k] + (1.0f - a) * curve[0][k + 1];
            newcurve[1][i] = a * curve[1][k] + (1.0f - a) * curve[1][k + 1];
        }
        newcurve[0][npoints - 1] = curve[0][len - 1];
        newcurve[1][npoints - 1] = curve[1][len - 1];
        return newcurve;
    }

    public static float curveLength(float[][] curve, float[] seg_length) {
        int len = curve[0].length;
        float curve_length = 0.0f;
        for (int i = 0; i < len - 1; ++i) {
            seg_length[i] = (float)Math.sqrt((curve[0][i + 1] - curve[0][i]) * (curve[0][i + 1] - curve[0][i]) + (curve[1][i + 1] - curve[1][i]) * (curve[1][i + 1] - curve[1][i]));
            curve_length += seg_length[i];
        }
        return curve_length;
    }

    public void setFlipTheFlip(boolean value) {
        this.flipTheFlip = value;
    }

    public boolean getFlipTheFlip() {
        return this.flipTheFlip;
    }
}

