/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import ucar.unidata.data.grid.DerivedGridFactory;
import ucar.unidata.data.grid.GridMath;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.util.Range;
import ucar.visad.data.GeoGridFlatField;
import ucar.visad.display.Displayable;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.RGBDisplayable;
import ucar.visad.display.ScalarMapSet;
import visad.BadMappingException;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.Display;
import visad.EarthVectorType;
import visad.FieldImpl;
import visad.FlowControl;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.TrajectoryParams;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;

public class FlowDisplayable
extends RGBDisplayable
implements GridDisplayable {
    private static boolean useFlow1 = false;
    public static final String FLOW_TYPE = "flowRealTupleType";
    public static String COLOR = "color";
    volatile ScalarMap flowXMap;
    volatile ScalarMap flowYMap;
    volatile ScalarMap flowZMap;
    private volatile FlowControl flowControl;
    private volatile RealTupleType flowRealTupleType;
    private float flowscale = 0.02f;
    private float trajOffset = 4.0f;
    private int smoothFactor = 20;
    private float trajWidth = 0.01f;
    private float ribbonWidth = 1.0f;
    private int zskip = 0;
    private float vectorLength = 2.0f;
    private boolean arrowHead = false;
    private float arrowHeadSize = 1.0f;
    private int tracerType = 7;
    private float streamlineDensity = 1.0f;
    private Color myColor;
    private boolean isStreamlines = false;
    private boolean isTrajectories = false;
    private boolean isRefresh = false;
    private boolean streamline = false;
    private boolean isCartesian = true;
    private boolean coloredByAnother = false;
    private boolean useSpeedForColor = false;
    private boolean autoScale = false;
    private int barborientation;
    private boolean adjustFlow = true;
    private boolean is3D = false;
    private boolean ignoreExtraParameters = false;
    public static final int NH_ORIENTATION = 0;
    public static final int SH_ORIENTATION = 1;
    private double flowMinValue = Double.NEGATIVE_INFINITY;
    private double flowMaxValue = Double.POSITIVE_INFINITY;
    protected Unit speedUnit = null;
    protected int spdIndex = 1;
    private int trajFormType = 0;
    private int trajStartLevel = 0;
    private boolean forward = true;
    RealTupleType trajStartPointType = null;
    float[][] trajStartPoints = null;

    public FlowDisplayable(String name, RealTupleType rTT, float flowscale, boolean useSpeedForColor) throws VisADException, RemoteException {
        super(name, null, null, true);
        this.flowRealTupleType = rTT;
        this.flowscale = flowscale;
        this.useSpeedForColor = useSpeedForColor;
        if (this.flowRealTupleType != null) {
            this.setFlowMaps();
        }
    }

    public FlowDisplayable(String name, RealTupleType rTT, float flowscale) throws VisADException, RemoteException {
        this(name, rTT, flowscale, false);
    }

    public FlowDisplayable(String name, RealTupleType rTT) throws VisADException, RemoteException {
        this(name, rTT, 0.02f);
    }

    protected FlowDisplayable(FlowDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.flowRealTupleType = that.flowRealTupleType;
        this.flowscale = that.flowscale;
        if (this.flowRealTupleType != null) {
            this.setFlowMaps();
        }
    }

    public RealTupleType getFlowTuple() {
        return this.flowRealTupleType;
    }

    public boolean getStreamlinesEnabled() {
        return this.flowControl == null ? false : this.flowControl.streamlinesEnabled();
    }

    public void setStreamlinesEnabled(boolean enable) {
        if (this.flowControl != null && enable != this.isStreamlines) {
            try {
                this.flowControl.enableStreamlines(enable);
            }
            catch (VisADException ve) {
                ve.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        this.isStreamlines = enable;
    }

    public void setTrojectoriesEnabled(boolean enable, float mSize, boolean refresh) {
        this.setTrojectoriesEnabled(enable, false, mSize, refresh);
    }

    public void setTrojectoriesEnabled(boolean enable, boolean markerOn, float mSize, boolean refresh) {
        if (this.flowControl != null) {
            try {
                if (!enable) {
                    this.flowControl.enableTrajectory(false);
                } else {
                    double tlen;
                    double rlen;
                    Set timeSet = GridUtil.getTimeSet((FieldImpl)this.getData());
                    int numTimes = timeSet.getLength();
                    double[][] td = timeSet.getDoubles();
                    if (refresh) {
                        rlen = (td[0][1] - td[0][0]) * (double)this.vectorLength;
                        tlen = (td[0][1] - td[0][0]) * (double)this.vectorLength;
                    } else {
                        rlen = (td[0][1] - td[0][0]) * (double)numTimes;
                        tlen = (td[0][1] - td[0][0]) * (double)this.trajOffset;
                        if (this.streamline) {
                            rlen = td[0][1] - td[0][0];
                        }
                    }
                    this.arrowHead = markerOn;
                    this.arrowHeadSize = mSize;
                    TrajectoryParams tparm = this.flowControl.getTrajectoryParams();
                    tparm.setTrajectoryForm(this.trajFormType);
                    tparm.setTrajectoryForm(this.trajFormType);
                    if (this.trajFormType == 5) {
                        tparm.setTracerStreamingEnabled(true);
                    } else {
                        tparm.setTracerStreamingEnabled(false);
                    }
                    tparm.setMarkerSize(mSize);
                    tparm.setTrajRefreshInterval(rlen);
                    tparm.setTrajVisibilityTimeWindow(tlen);
                    tparm.setMarkerEnabled(markerOn);
                    tparm.setCylinderWidth(this.trajWidth);
                    tparm.setRibbonWidthFactor(this.ribbonWidth);
                    tparm.setZStartIndex(this.trajStartLevel);
                    tparm.setStartPoints(this.trajStartPointType, this.trajStartPoints);
                    tparm.setZStartSkip(this.zskip);
                    tparm.setDirectionFlag(this.forward);
                    tparm.setConserveColor(true);
                    if (this.isTrajectories) {
                        tparm.setCachingEnabled(false);
                        tparm.setMethod(TrajectoryParams.Method.HySplit);
                        tparm.setTimeStepScaleFactor(1.0);
                        tparm.setInterpolationMethod(TrajectoryParams.InterpolationMethod.Cubic);
                    }
                    if (this.streamline) {
                        tparm.setTrajVisibilityTimeWindow(rlen);
                        tparm.setManualIntrpPts(true);
                        tparm.setMethod(TrajectoryParams.Method.Euler);
                        tparm.setInterpolationMethod(TrajectoryParams.InterpolationMethod.None);
                        tparm.setTimeStepScaleFactor(this.trajOffset);
                        tparm.setNumIntrpPts(this.smoothFactor);
                    }
                    this.flowControl.enableTrajectory(enable, tparm);
                }
            }
            catch (VisADException ve) {
                ve.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        this.isTrajectories = enable;
        this.isRefresh = refresh;
    }

    public void setIsTrajectories(boolean isTrajectories) {
        this.isTrajectories = isTrajectories;
    }

    public void setStreamline(boolean streamline) {
        this.streamline = streamline;
    }

    public void resetTrojectories() {
        if (this.flowControl != null) {
            try {
                double tlen;
                double rlen;
                Set timeSet = GridUtil.getTimeSet((FieldImpl)this.getData());
                int numTimes = timeSet.getLength();
                double[][] td = timeSet.getDoubles();
                if (this.isRefresh) {
                    rlen = (td[0][1] - td[0][0]) * (double)this.vectorLength;
                    tlen = (td[0][1] - td[0][0]) * (double)this.vectorLength;
                } else {
                    rlen = (td[0][1] - td[0][0]) * (double)numTimes;
                    tlen = (td[0][1] - td[0][0]) * (double)this.trajOffset;
                    if (this.streamline) {
                        rlen = td[0][1] - td[0][0];
                    }
                }
                TrajectoryParams tparm = this.flowControl.getTrajectoryParams();
                tparm.setConserveColor(true);
                int t = tparm.getStartSkip();
                tparm.setTrajectoryForm(this.trajFormType);
                tparm.setTracerType(this.tracerType);
                if (this.trajFormType == 5) {
                    tparm.setTracerStreamingEnabled(true);
                } else {
                    tparm.setTracerStreamingEnabled(false);
                }
                tparm.setMarkerSize(this.arrowHeadSize);
                tparm.setTrajRefreshInterval(rlen);
                tparm.setTrajVisibilityTimeWindow(tlen);
                tparm.setMarkerEnabled(this.arrowHead);
                tparm.setCylinderWidth(this.trajWidth);
                tparm.setRibbonWidthFactor(this.ribbonWidth);
                tparm.setStartSkip(t);
                tparm.setNumIntrpPts(this.smoothFactor);
                tparm.setZStartIndex(this.trajStartLevel);
                tparm.setZStartSkip(this.zskip);
                tparm.setStartPoints(this.trajStartPointType, this.trajStartPoints);
                tparm.setDirectionFlag(this.forward);
                tparm.setCachingEnabled(false);
                if (this.streamline) {
                    tparm.setTrajVisibilityTimeWindow(rlen);
                    tparm.setManualIntrpPts(true);
                    tparm.setMethod(TrajectoryParams.Method.Euler);
                    tparm.setInterpolationMethod(TrajectoryParams.InterpolationMethod.None);
                    tparm.setTimeStepScaleFactor(this.trajOffset);
                    this.flowControl.enableTrajectory(true, tparm);
                } else {
                    tparm.setMethod(TrajectoryParams.Method.HySplit);
                    tparm.setTimeStepScaleFactor(1.0);
                    tparm.setInterpolationMethod(TrajectoryParams.InterpolationMethod.Cubic);
                    this.flowControl.enableTrajectory(this.isTrajectories, tparm);
                }
            }
            catch (VisADException ve) {
                ve.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    public int getBarbOrientation() {
        return this.barborientation;
    }

    public void setBarbOrientation(int style) {
        if (this.flowControl != null) {
            try {
                if (style == 0 || style == 1) {
                    this.flowControl.setBarbOrientation(style);
                    this.barborientation = style;
                }
            }
            catch (VisADException ve) {
                ve.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    public boolean getAdjustFlow() {
        return this.adjustFlow;
    }

    @Override
    public void setAdjustFlow(boolean adjust) {
        if (this.flowControl != null) {
            try {
                this.flowControl.setAdjustFlowToEarth(adjust);
            }
            catch (VisADException ve) {
                ve.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        this.adjustFlow = adjust;
    }

    public void setStreamlineDensity(float density) {
        if (this.flowControl != null && this.streamlineDensity != density) {
            try {
                this.flowControl.setStreamlineDensity(density);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.streamlineDensity = density;
    }

    public void setFlowScale(float scale) {
        if (this.flowControl != null && scale != this.flowscale) {
            try {
                this.adjustScale(scale);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.flowscale = scale;
    }

    public void setArrowHead(boolean onoff) {
        this.arrowHead = onoff;
    }

    public void setArrowHeadSize(float size) {
        this.arrowHeadSize = size;
        if (this.flowControl != null) {
            try {
                this.flowControl.setArrowScale(this.arrowHeadSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setTracerType(int type) {
        this.tracerType = type;
        if (this.flowControl != null) {
            try {
                this.flowControl.setArrowScale(this.arrowHeadSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setVectorLength(float len) {
        this.vectorLength = len;
    }

    public void setTrajOffset(float offset) {
        this.trajOffset = offset;
    }

    public void setSmoothFactor(int factor) {
        this.smoothFactor = factor;
    }

    public void setTrajFormType(int formType) {
        this.trajFormType = formType;
    }

    public void setTrajStartLevel(int startLevel) {
        this.trajStartLevel = startLevel;
    }

    public int getTrajStartLevel() {
        return this.trajStartLevel;
    }

    public void setTrajWidth(float width) {
        this.trajWidth = width;
    }

    public float getTrajWidth() {
        return this.trajWidth;
    }

    public void setRibbonWidth(float width) {
        this.ribbonWidth = width;
    }

    public float getRibbonWidth() {
        return this.ribbonWidth;
    }

    public void setZskip(int skip) {
        this.zskip = skip;
    }

    public int getZskip() {
        return this.zskip;
    }

    public boolean getForward() {
        return this.forward;
    }

    public void setForward(boolean forw) {
        this.forward = forw;
    }

    public void setTrajStartPointType(RealTupleType type) {
        this.trajStartPointType = type;
    }

    public RealTupleType getTrajStartPointType() {
        return this.trajStartPointType;
    }

    public void setTrajStartPoints(float[][] pts) {
        this.trajStartPoints = pts;
    }

    public float[][] getTrajStartPoints() {
        return this.trajStartPoints;
    }

    public void setAutoScale(boolean auto) {
        if (this.flowControl != null && auto != this.autoScale) {
            try {
                this.flowControl.setAutoScale(auto);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        this.autoScale = auto;
    }

    @Override
    protected void setScalarMaps(ScalarMapSet maps) throws BadMappingException {
        if (this.flowXMap == null) {
            throw new BadMappingException(this.getClass().getName() + ".setScalarMaps(ScalarMapSet): " + "flowXMap not yet set");
        }
        maps.add(this.flowXMap);
        if (this.flowYMap == null) {
            throw new BadMappingException(this.getClass().getName() + ".setScalarMaps(ScalarMapSet): " + "flowYMap not yet set");
        }
        maps.add(this.flowYMap);
        if (this.get3DFlow()) {
            if (this.flowZMap == null) {
                throw new BadMappingException(this.getClass().getName() + ".setScalarMaps(ScalarMapSet): " + "flowZMap not yet set");
            }
            maps.add(this.flowZMap);
        }
        super.setScalarMapSet(maps);
    }

    public int getSpeedTypeIndex() {
        int index = -1;
        if (!this.isCartesianWind() && this.flowYMap != null && this.flowRealTupleType != null) {
            RealType speedType = (RealType)this.flowYMap.getScalar();
            RealType[] realTypes = this.flowRealTupleType.getRealComponents();
            for (int i = 0; i < realTypes.length; ++i) {
                if (!speedType.equals(realTypes[i])) continue;
                index = i;
            }
        }
        return index;
    }

    protected void setFlowMaps() throws RemoteException, VisADException {
        useFlow1 = !useFlow1;
        RealType[] realTypes = this.flowRealTupleType.getRealComponents();
        Unit[] units = this.flowRealTupleType.getDefaultUnits();
        this.spdIndex = 1;
        if (Unit.canConvert(units[0], CommonUnit.meterPerSecond) && Unit.canConvert(units[1], CommonUnit.meterPerSecond) || units[0] == null && units[1] == null || CommonUnit.dimensionless.equals(units[0]) && CommonUnit.dimensionless.equals(units[1])) {
            this.flowXMap = new ScalarMap(realTypes[0], useFlow1 ? Display.Flow1X : Display.Flow2X);
            this.flowYMap = new ScalarMap(realTypes[1], useFlow1 ? Display.Flow1Y : Display.Flow2Y);
            this.spdIndex = 0;
            if (this.coloredByAnother || this.useSpeedForColor) {
                this.spdIndex = 2;
            }
        } else if (Unit.canConvert(units[0], CommonUnit.degree) && Unit.canConvert(units[1], CommonUnit.meterPerSecond)) {
            this.isCartesian = false;
            this.flowXMap = new ScalarMap(realTypes[0], useFlow1 ? Display.Flow1Azimuth : Display.Flow2Azimuth);
            this.flowXMap.setRange(0.0, 360.0);
            this.flowYMap = new ScalarMap(realTypes[1], useFlow1 ? Display.Flow1Radial : Display.Flow2Radial);
            this.spdIndex = 1;
        } else if (Unit.canConvert(units[0], CommonUnit.meterPerSecond) && Unit.canConvert(units[1], CommonUnit.degree)) {
            this.isCartesian = false;
            this.flowXMap = new ScalarMap(realTypes[1], useFlow1 ? Display.Flow1Azimuth : Display.Flow2Azimuth);
            this.flowXMap.setRange(0.0, 360.0);
            this.flowYMap = new ScalarMap(realTypes[0], useFlow1 ? Display.Flow1Radial : Display.Flow2Radial);
            this.spdIndex = 0;
        } else {
            this.flowXMap = new ScalarMap(realTypes[0], useFlow1 ? Display.Flow1X : Display.Flow2X);
            this.flowYMap = new ScalarMap(realTypes[1], useFlow1 ? Display.Flow1Y : Display.Flow2Y);
            this.spdIndex = 0;
        }
        this.speedUnit = units[this.spdIndex];
        if (this.get3DFlow()) {
            if (Unit.canConvert(units[2], CommonUnit.meterPerSecond)) {
                this.isCartesian = true;
                this.flowZMap = new ScalarMap(realTypes[2], useFlow1 ? Display.Flow1Z : Display.Flow2Z);
            } else {
                this.isCartesian = false;
                this.flowZMap = new ScalarMap(realTypes[2], useFlow1 ? Display.Flow1Elevation : Display.Flow2Elevation);
            }
        }
        if (this.useSpeedForColor && !this.isCartesian) {
            this.setRGBRealType((RealType)this.flowRealTupleType.getComponent(this.spdIndex));
        }
        this.flowYMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    FlowDisplayable.this.flowControl = (FlowControl)FlowDisplayable.this.flowYMap.getControl();
                    FlowDisplayable.this.flowControl.enableStreamlines(FlowDisplayable.this.isStreamlines);
                    FlowDisplayable.this.flowControl.enableTrajectory(FlowDisplayable.this.isTrajectories);
                    FlowDisplayable.this.flowControl.setAutoScale(FlowDisplayable.this.autoScale);
                    FlowDisplayable.this.flowControl.setStreamlineDensity(FlowDisplayable.this.streamlineDensity);
                    FlowDisplayable.this.flowControl.setAdjustFlowToEarth(FlowDisplayable.this.adjustFlow);
                    FlowDisplayable.this.flowControl.setBarbOrientation(FlowDisplayable.this.barborientation);
                    if (FlowDisplayable.this.isTrajectories || FlowDisplayable.this.streamline) {
                        FlowDisplayable.this.resetTrojectories();
                    }
                    FlowDisplayable.this.adjustScale(FlowDisplayable.this.flowscale);
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) {
            }
        });
        ScalarMapSet maps = this.getScalarMapSet();
        maps.add(this.flowXMap);
        maps.add(this.flowYMap);
        if (this.get3DFlow()) {
            maps.add(this.flowZMap);
        }
        this.setFlowRange(this.flowMinValue, this.flowMaxValue);
        this.setScalarMapSet(maps);
    }

    public void setFlowRange(Range flowRange) throws VisADException, RemoteException {
        if (flowRange == null) {
            return;
        }
        this.setFlowRange(flowRange.getMin(), flowRange.getMax());
    }

    public void setFlowRange(double min, double max) throws VisADException, RemoteException {
        this.flowMinValue = min;
        this.flowMaxValue = max;
        if (!Double.isInfinite(this.flowMinValue) && !Double.isInfinite(this.flowMaxValue)) {
            if (this.isCartesianWind() && this.flowXMap != null) {
                this.flowXMap.setRange(this.flowMinValue, this.flowMaxValue);
                this.flowYMap.setRange(this.flowMinValue, this.flowMaxValue);
                if (this.get3DFlow()) {
                    this.flowZMap.setRange(this.flowMinValue, this.flowMaxValue);
                }
            } else if (!this.isCartesianWind() && this.flowYMap != null) {
                this.flowYMap.setRange(0.0, this.flowMaxValue);
            }
        }
    }

    public void setGrid3D(FieldImpl field) throws VisADException, RemoteException {
        this.loadData(field);
    }

    @Override
    public void loadData(FieldImpl field) throws VisADException, RemoteException {
        String oname;
        FieldImpl otherFimpl;
        FieldImpl dirFimpl;
        FieldImpl spdFimpl;
        int threeDDim;
        TupleType tt = GridUtil.getParamType(field);
        RealTupleType rtt = new RealTupleType(tt.getRealComponents());
        RealType rt0 = (RealType)rtt.getComponents()[0];
        RealType rt1 = (RealType)rtt.getComponents()[1];
        int n = threeDDim = this.coloredByAnother || this.ignoreExtraParameters ? 3 : 2;
        if (this.is3D && rtt.getDimension() == 3) {
            RealType rt = (RealType)rtt.getComponents()[2];
            if (rt.getDefaultUnit().isConvertible(CommonUnit.meterPerSecond)) {
                this.set3DFlow(true);
            } else {
                this.set3DFlow(false);
            }
        } else {
            this.set3DFlow(rtt.getDimension() > threeDDim);
        }
        if (rt0.getDefaultUnit().isConvertible(CommonUnit.meterPerSecond) && rt1.getDefaultUnit().isConvertible(CommonUnit.degree)) {
            spdFimpl = DerivedGridFactory.getUComponent(field);
            dirFimpl = DerivedGridFactory.getVComponent(field);
            otherFimpl = null;
            if (this.coloredByAnother && !this.useSpeedForColor) {
                otherFimpl = DerivedGridFactory.getVComponent(field);
                dirFimpl = DerivedGridFactory.getComponent(spdFimpl, 1, true);
                spdFimpl = DerivedGridFactory.getComponent(spdFimpl, 0, true);
            }
            oname = spdFimpl.getType().prettyString();
            FieldImpl uFimpl = GridUtil.setParamType(GridMath.multiply(spdFimpl, (FieldImpl)dirFimpl.sin()), oname + "Uspd");
            FieldImpl vFimpl = GridUtil.setParamType(GridMath.multiply(spdFimpl, (FieldImpl)dirFimpl.cos()), oname + "Vspd");
            field = DerivedGridFactory.createFlowVectors(uFimpl, vFimpl);
            if (this.useSpeedForColor) {
                field = DerivedGridFactory.combineGrids(field, spdFimpl);
            } else if (this.coloredByAnother) {
                field = DerivedGridFactory.combineGrids(field, otherFimpl);
            }
            tt = GridUtil.getParamType(field);
            rtt = new RealTupleType(tt.getRealComponents());
        } else if (rt0.getDefaultUnit().isConvertible(CommonUnit.degree) && rt1.getDefaultUnit().isConvertible(CommonUnit.meterPerSecond)) {
            spdFimpl = DerivedGridFactory.getVComponent(field);
            dirFimpl = DerivedGridFactory.getUComponent(field);
            otherFimpl = null;
            if (this.coloredByAnother && !this.useSpeedForColor) {
                otherFimpl = DerivedGridFactory.getUComponent(field);
                dirFimpl = DerivedGridFactory.getComponent(spdFimpl, 0, true);
                spdFimpl = DerivedGridFactory.getComponent(spdFimpl, 1, true);
            }
            oname = spdFimpl.getType().prettyString();
            FieldImpl uFimpl = GridUtil.setParamType(GridMath.multiply(spdFimpl, (FieldImpl)dirFimpl.sin()), oname + "Uspd");
            FieldImpl vFimpl = GridUtil.setParamType(GridMath.multiply(spdFimpl, (FieldImpl)dirFimpl.cos()), oname + "Vcomp");
            field = DerivedGridFactory.createFlowVectors(uFimpl, vFimpl);
            if (this.useSpeedForColor) {
                field = DerivedGridFactory.combineGrids(field, spdFimpl);
            } else if (this.coloredByAnother) {
                field = DerivedGridFactory.combineGrids(field, otherFimpl);
            }
            tt = GridUtil.getParamType(field);
            rtt = new RealTupleType(tt.getRealComponents());
        } else if ((this.coloredByAnother || this.useSpeedForColor) && rt0.getDefaultUnit().isConvertible(CommonUnit.meterPerSecond) && rt1.getDefaultUnit().isConvertible(CommonUnit.meterPerSecond) && this.useSpeedForColor) {
            FieldImpl uFimpl = DerivedGridFactory.getUComponent(field);
            FieldImpl vFimpl = DerivedGridFactory.getVComponent(field);
            if (!GridUtil.getParamUnits(vFimpl)[0].isConvertible(CommonUnit.meterPerSecond) && GridUtil.getParamUnits(uFimpl).length == 2 && GridUtil.getParamUnits(uFimpl)[0].isConvertible(CommonUnit.meterPerSecond) && GridUtil.getParamUnits(uFimpl)[1].isConvertible(CommonUnit.meterPerSecond)) {
                vFimpl = DerivedGridFactory.getVComponent(uFimpl);
                uFimpl = DerivedGridFactory.getUComponent(uFimpl);
            }
            FieldImpl speedImpl = DerivedGridFactory.createWindSpeed(uFimpl, vFimpl);
            field = DerivedGridFactory.combineGrids(field, speedImpl);
            tt = GridUtil.getParamType(field);
            rtt = new RealTupleType(tt.getRealComponents());
        }
        if (this.useSpeedForColor || this.coloredByAnother) {
            RealType rgbType = (RealType)rtt.getComponent(rtt.getDimension() - 1);
            this.setRGBRealType(rgbType);
        }
        TupleType newParamType = null;
        if (this.isCartesianWind() && !(tt instanceof RealVectorType) && !(tt.getComponent(0) instanceof RealVectorType)) {
            int numBase = this.get3DFlow() ? 3 : 2;
            try {
                if (!this.coloredByAnother || rtt.getDimension() == numBase) {
                    newParamType = new EarthVectorType(rtt.getRealComponents());
                } else {
                    RealType[] reals = rtt.getRealComponents();
                    RealType[] extras = new RealType[reals.length - numBase];
                    System.arraycopy(reals, numBase, extras, 0, extras.length);
                    newParamType = new TupleType(new MathType[]{this.get3DFlow() ? new EarthVectorType(reals[0], reals[1], reals[2]) : new EarthVectorType(reals[0], reals[1]), new RealTupleType(extras)});
                }
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        this.setData(newParamType == null ? field : GridUtil.setParamType(field, newParamType, false));
        this.setType(rtt);
    }

    public void loadTopoData(FieldImpl topo) throws VisADException, RemoteException {
        if (this.flowControl != null) {
            TrajectoryParams tparm = this.flowControl.getTrajectoryParams();
            tparm.setTerrain((GeoGridFlatField)topo.getSample(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColor(Color color) throws VisADException, RemoteException {
        Color oldValue;
        FlowDisplayable flowDisplayable = this;
        synchronized (flowDisplayable) {
            oldValue = this.myColor;
            this.addConstantMaps(new ConstantMap[]{new ConstantMap((double)color.getRed() / 255.0, Display.Red), new ConstantMap((double)color.getGreen() / 255.0, Display.Green), new ConstantMap((double)color.getBlue() / 255.0, Display.Blue)});
            this.myColor = color;
        }
        this.firePropertyChange(COLOR, oldValue, this.myColor);
    }

    protected void setType(RealTupleType rTT) throws RemoteException, VisADException {
        if (!rTT.equals(this.flowRealTupleType)) {
            RealTupleType oldValue = this.flowRealTupleType;
            this.flowRealTupleType = rTT;
            this.setFlowMaps();
            this.firePropertyChange(FLOW_TYPE, oldValue, this.flowRealTupleType);
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return this;
    }

    private void adjustScale(float scale) throws VisADException, RemoteException {
        this.flowControl.setFlowScale(scale);
    }

    private void adjustTrajOffsetLength(float scale) throws VisADException, RemoteException {
        this.flowControl.setFlowScale(scale);
    }

    public boolean isCartesianWind() {
        return this.isCartesian;
    }

    public boolean get3DFlow() {
        return this.is3D;
    }

    public void set3DFlow(boolean threeD) {
        this.is3D = threeD;
    }

    @Override
    protected boolean useDisplayUnitForColor() {
        return !this.coloredByAnother;
    }

    @Override
    public void setColoredByAnother(boolean yesno) {
        this.coloredByAnother = yesno;
    }

    public void setUseSpeedForColor(boolean yesno) {
        this.useSpeedForColor = yesno;
        if (this.useSpeedForColor && !this.isCartesian) {
            try {
                this.setRGBRealType((RealType)this.flowRealTupleType.getComponent(this.spdIndex));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setIgnoreExtraParameters(boolean yesno) {
        this.ignoreExtraParameters = yesno;
    }

    public void setStartPoints(RealTupleType types, float[][] stp) {
        this.trajStartPoints = stp;
        this.trajStartPointType = types;
        if (this.flowControl != null) {
            TrajectoryParams tParm = this.flowControl.getTrajectoryParams();
            tParm.setStartPoints(types, stp);
        }
    }

    public void setStartLevel(int startLevel) {
        if (this.flowControl == null) {
            return;
        }
        TrajectoryParams tParm = this.flowControl.getTrajectoryParams();
        tParm.setZStartIndex(startLevel);
        tParm.setZStartSkip(10);
    }
}

