/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import ucar.visad.display.Displayable;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.VisADException;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java3d.DirectManipulationRendererJ3D;

public class DisplayableDataRef
extends Displayable {
    private boolean isManip;
    private DataReference ref;
    private DataRenderer renderer;
    private boolean refAdded = false;

    public DisplayableDataRef(String name) throws RemoteException, VisADException {
        this(new DataReferenceImpl(name));
    }

    public DisplayableDataRef(DataReference ref) throws RemoteException, VisADException {
        if (ref == null) {
            throw new NullPointerException();
        }
        this.ref = ref;
    }

    public final DataReference getDataReference() {
        return this.ref;
    }

    public void setData(Data d) throws VisADException, RemoteException {
        this.ref.setData(d);
    }

    @Override
    public final synchronized void setManipulable(boolean manipulable) throws VisADException, RemoteException {
        this.isManip = manipulable;
    }

    public final boolean isManipulable() {
        return this.isManip;
    }

    @Override
    public final synchronized void setVisible(boolean visible) throws VisADException, RemoteException {
        super.setVisible(visible);
        if (this.renderer != null) {
            this.renderer.toggle(visible);
        }
    }

    @Override
    protected final synchronized void myAddDataReferences() throws VisADException, RemoteException {
        if (!this.refAdded && this.ref.getData() != null) {
            DisplayImpl display = (DisplayImpl)this.getDisplay();
            this.renderer = this.getDataRenderer(display);
            this.renderer.toggle(this.getVisible());
            display.addReferences(this.renderer, this.ref, this.getConstantMaps());
            this.refAdded = true;
        }
    }

    @Override
    protected final synchronized void myRemoveDataReferences() throws VisADException, RemoteException {
        if (this.refAdded) {
            this.getDisplay().removeReference(this.ref);
            this.refAdded = false;
        }
    }

    @Override
    public final boolean hasDataObject() {
        return true;
    }

    protected DataRenderer getDataRenderer(DisplayImpl display) throws VisADException {
        DisplayRenderer displayRenderer = display.getDisplayRenderer();
        return !this.isManipulable() ? displayRenderer.makeDefaultRenderer() : (displayRenderer.getMode2D() ? new DirectManipulationRendererJ2D() : new DirectManipulationRendererJ3D());
    }

    @Override
    public void setColor(Color color) throws VisADException, RemoteException {
        this.addConstantMap(new ConstantMap((double)color.getRed() / 255.0, Display.Red));
        this.addConstantMap(new ConstantMap((double)color.getGreen() / 255.0, Display.Green));
        this.addConstantMap(new ConstantMap((double)color.getBlue() / 255.0, Display.Blue));
    }

    @Override
    public void setLineWidth(float width) throws VisADException, RemoteException {
        this.addConstantMap(new ConstantMap(width, Display.LineWidth));
    }

    public void setLineStyle(int lineStyle) throws VisADException, RemoteException {
        this.addConstantMap(new ConstantMap(lineStyle, Display.LineStyle));
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        DisplayableDataRef clone = new DisplayableDataRef(this.ref);
        clone.setManipulable(this.isManip);
        return clone;
    }
}

