/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.visad.display.Displayable;
import visad.Action;
import visad.ActionImpl;
import visad.ConstantMap;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.FieldImpl;
import visad.Gridded1DSet;
import visad.RealType;
import visad.ScalarType;
import visad.Set;
import visad.TypeException;
import visad.VisADException;
import visad.VisADRay;
import visad.bom.PickManipulationRendererJ2D;
import visad.bom.PickManipulationRendererJ3D;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java3d.DirectManipulationRendererJ3D;

public class DisplayableData
extends Displayable {
    public static final String MANIPULABLE = "manipulable";
    public static final String VISIBLE = "visible";
    public static String LINE_WIDTH = "lineWidth";
    private boolean pickable = false;
    private boolean manipulable = false;
    private final String name;
    private DataReference reference;
    private ActionImpl changeListener;
    private boolean active = true;
    protected DataRenderer renderer;
    private boolean refAdded = false;
    private Set cachedAnimationSet = null;
    private float myLineWidth = 1.0f;
    private float myPointSize = 1.0f;
    private DragAdapter dragAdapter;

    public DisplayableData(String name) throws VisADException, RemoteException {
        this.name = name;
        this.reference = new DataReferenceImpl(name + "Ref");
        this.changeListener = this.newChangeListener(true);
        this.changeListener.addReference(this.reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayableData(DisplayableData that) throws VisADException, RemoteException {
        super(that);
        DisplayableData displayableData = that;
        synchronized (displayableData) {
            this.manipulable = that.manipulable;
            this.name = that.name;
            this.myLineWidth = that.myLineWidth;
            this.myPointSize = that.myPointSize;
            this.reference = new DataReferenceImpl(this.name + "Ref");
            this.active = that.active;
            this.changeListener = this.newChangeListener(this.active);
            this.changeListener.addReference(this.reference);
        }
    }

    @Override
    public void setUseFastRendering(boolean fastRender) throws VisADException, RemoteException {
        super.setUseFastRendering(fastRender);
        this.addConstantMap(new ConstantMap(fastRender ? -1 : 1, Display.AdjustProjectionSeam));
    }

    @Override
    public void setPointMode(boolean usePoints) throws VisADException, RemoteException {
        super.setPointMode(usePoints);
        this.addConstantMap(new ConstantMap(usePoints ? 1 : -1, Display.PointMode));
    }

    private ActionImpl newChangeListener(boolean enable) {
        ActionImpl changeListener = new ActionImpl(this.getClass().getName() + "ChangeListener"){

            @Override
            public void doAction() {
                try {
                    if (DisplayableData.this.hasData()) {
                        DisplayableData.this.dataChange();
                    }
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".doAction(): " + "Couldn't handle new data: " + e);
                    e.printStackTrace();
                }
            }
        };
        if (!enable) {
            changeListener.disableAction();
        }
        return changeListener;
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new DisplayableData(this);
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setManipulable(boolean manipulable) throws VisADException, RemoteException {
        if (this.manipulable != manipulable) {
            Boolean oldValue;
            DisplayableData displayableData = this;
            synchronized (displayableData) {
                oldValue = new Boolean(this.manipulable);
                this.manipulable = manipulable;
                if (this.renderer != null) {
                    this.removeDataReferences();
                    this.addDataReferences();
                }
            }
            this.firePropertyChange(MANIPULABLE, oldValue, new Boolean(this.manipulable));
        }
    }

    public final boolean isManipulable() {
        return this.manipulable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible) throws RemoteException, VisADException {
        Boolean oldValue;
        DisplayableData displayableData = this;
        synchronized (displayableData) {
            oldValue = new Boolean(this.getVisible());
            super.setVisible(visible);
            if (this.renderer != null) {
                this.renderer.toggle(this.getVisible());
            }
        }
        this.firePropertyChange(VISIBLE, oldValue, new Boolean(this.getVisible()));
    }

    public boolean getActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setActive(boolean active) throws VisADException, RemoteException {
        DisplayableData displayableData = this;
        synchronized (displayableData) {
            if (this.active == active) {
                return;
            }
            this.active = active;
        }
        if (active) {
            this.changeListener.enableAction();
        } else {
            this.changeListener.disableAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void myAddDataReferences() throws VisADException, RemoteException {
        boolean callDataChange = false;
        DisplayableData displayableData = this;
        synchronized (displayableData) {
            if (!this.refAdded && this.hasData()) {
                callDataChange = true;
                this.renderer = this.getDataRenderer();
                this.renderer.toggle(this.getVisible());
                this.getDisplay().addReferences(this.renderer, this.reference, this.getConstantMaps());
                this.refAdded = true;
            }
        }
        if (callDataChange) {
            this.dataChange();
        }
    }

    @Override
    protected final void myRemoveDataReferences() throws VisADException, RemoteException {
        if (this.refAdded) {
            this.getDisplay().removeReference(this.reference);
            this.refAdded = false;
            this.renderer = null;
            this.cachedAnimationSet = null;
            this.dataChange();
        }
    }

    @Override
    protected void myAddConstantMaps(ConstantMap[] newMaps) throws VisADException, RemoteException {
        if (!this.refAdded) {
            return;
        }
        this.setDisplayInactive();
        DataDisplayLink link = (DataDisplayLink)((DisplayImpl)this.getDisplay()).findReference(this.reference);
        link.setConstantMaps(newMaps);
        this.setDisplayActive();
    }

    protected void dataChange() throws VisADException, RemoteException {
        if (this.getDisplayMaster() != null) {
            this.getDisplayMaster().dataChange();
        }
    }

    public final synchronized void setDataReference(DataReference reference) throws TypeException, RemoteException, VisADException {
        if (reference.getData() == null) {
            throw new TypeException(this.getClass().getName() + ".setData(DataReference): Null data");
        }
        if (this.getDisplay() != null) {
            this.removeDataReferences();
        }
        this.changeListener.removeReference(this.reference);
        this.reference = reference;
        this.changeListener.addReference(this.reference);
        if (this.addRefsInvoked()) {
            this.myAddDataReferences();
        }
    }

    @Override
    protected void destroy() throws RemoteException, VisADException {
        if (this.getDestroyed()) {
            return;
        }
        if (this.changeListener != null && this.reference != null) {
            this.changeListener.removeReference(this.reference);
        }
        this.renderer = null;
        this.changeListener = null;
        this.reference = null;
        this.cachedAnimationSet = null;
        super.destroy();
    }

    public final void setData(Data data) throws RemoteException, VisADException {
        if (data == null) {
            throw new NullPointerException();
        }
        this.cachedAnimationSet = null;
        if (this.reference == null) {
            return;
        }
        this.reference.setData(data);
        if (this.addRefsInvoked()) {
            this.myAddDataReferences();
        }
    }

    @Override
    public final boolean hasDataObject() {
        return true;
    }

    @Override
    public final Data getData() throws VisADException, RemoteException {
        return this.reference.getData();
    }

    public final void addAction(Action action) throws VisADException, RemoteException {
        action.addReference(this.reference);
    }

    public final void removeAction(Action action) throws VisADException, RemoteException {
        action.removeReference(this.reference);
    }

    public boolean hasData() throws VisADException, RemoteException {
        if (this.reference == null) {
            return false;
        }
        return this.reference.getData() != null;
    }

    protected DataRenderer getDataRenderer() throws VisADException {
        DisplayRenderer displayRenderer = this.getDisplay().getDisplayRenderer();
        boolean is2d = displayRenderer instanceof DisplayRendererJ2D;
        if (this.isPickable() && this.isManipulable()) {
            throw new IllegalStateException("Displayable:" + this.getClass().getName() + " cannot be both pickable and manipulable");
        }
        if (this.isPickable()) {
            if (is2d) {
                return new PickManipulationRendererJ2D();
            }
            displayRenderer.setPickThreshhold(0.2f);
            return new PickManipulationRendererJ3D(16, 16);
        }
        if (this.isManipulable()) {
            if (is2d) {
                return new DirectManipulationRendererJ2D();
            }
            return new DirectManipulationRendererJ3D(){

                @Override
                public void addPoint(float[] x) throws VisADException {
                    if (DisplayableData.this.dragAdapter != null && !DisplayableData.this.dragAdapter.handleAddPoint(x)) {
                        return;
                    }
                    super.addPoint(x);
                }

                @Override
                public void constrainDragPoint(float[] x) {
                    if (DisplayableData.this.dragAdapter != null && !DisplayableData.this.dragAdapter.constrainDragPoint(x)) {
                        return;
                    }
                }

                @Override
                public synchronized void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
                    if (DisplayableData.this.dragAdapter != null && !DisplayableData.this.dragAdapter.handleDragDirect(ray, first, mouseModifiers)) {
                        return;
                    }
                    super.drag_direct(ray, first, mouseModifiers);
                }
            };
        }
        return displayRenderer.makeDefaultRenderer();
    }

    public String showme() {
        return this.getClass().getName();
    }

    public void setPickable(boolean pickable) throws VisADException, RemoteException {
        this.pickable = pickable;
        if (this.renderer != null) {
            this.removeDataReferences();
            this.addDataReferences();
        }
    }

    public boolean isPickable() {
        return this.pickable;
    }

    @Override
    public Set getAnimationSet(RealType aniType, boolean force) throws VisADException, RemoteException {
        Set overrideSet = super.getAnimationSet(aniType, force);
        if (overrideSet != null) {
            return overrideSet;
        }
        if (this.cachedAnimationSet != null) {
            return this.cachedAnimationSet;
        }
        Set aniSet = null;
        if (this.refAdded && this.hasData() && ScalarType.findScalarType(this.reference.getData().getType(), aniType)) {
            Data d = this.getData();
            if (d instanceof FieldImpl && aniType.equals(RealType.Time) && GridUtil.isTimeSequence((FieldImpl)d)) {
                aniSet = GridUtil.getTimeSet((FieldImpl)d);
                this.cachedAnimationSet = aniSet;
            } else if (d instanceof Gridded1DSet) {
                aniSet = (Gridded1DSet)d;
                this.cachedAnimationSet = aniSet;
            }
        }
        return aniSet;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLineWidth(float lineWidth) throws VisADException, RemoteException {
        DisplayableData displayableData = this;
        synchronized (displayableData) {
            float oldValue = this.myLineWidth;
            this.addConstantMap(new ConstantMap(lineWidth, Display.LineWidth));
            this.myLineWidth = lineWidth;
        }
    }

    public float getLineWidth() {
        return this.myLineWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPointSize(float pointSize) throws VisADException, RemoteException {
        DisplayableData displayableData = this;
        synchronized (displayableData) {
            float oldValue = this.myPointSize;
            this.addConstantMap(new ConstantMap(pointSize, Display.PointSize));
            this.myPointSize = pointSize;
        }
    }

    public float getPointSize() {
        return this.myPointSize;
    }

    public void setDragAdapter(DragAdapter dragAdapter) {
        this.dragAdapter = dragAdapter;
    }

    public static interface DragAdapter {
        public boolean handleDragDirect(VisADRay var1, boolean var2, int var3);

        public boolean handleAddPoint(float[] var1);

        public boolean constrainDragPoint(float[] var1);
    }
}

