/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.visad.Util;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.ConstantMapSet;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.ScalarMapSet;
import visad.BadMappingException;
import visad.ConstantMap;
import visad.Data;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.LocalDisplay;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.Unit;
import visad.VisADException;

public abstract class Displayable {
    static String tab = "";
    private boolean useTimesInAnimation = true;
    private boolean useFastRendering = false;
    private boolean pointMode = false;
    private boolean destroyed = false;
    public static final String DISPLAY = "display";
    public static final String SCALAR_MAP_SET = "scalarMapSet";
    private ConstantMapSet constantMaps = new ConstantMapSet();
    private volatile PropertyChangeSupport propertyListeners;
    private LocalDisplay display;
    private ScalarMapSet scalarMapSet;
    private ScalarMapSet prevScalarMapSet;
    private Unit displayUnit = null;
    private Unit colorUnit = null;
    private boolean visible = true;
    private boolean addRefsInvoked = false;
    protected CompositeDisplayable parent;
    private DisplayMaster displayMaster;
    private Set animationSet = null;

    protected Displayable() throws RemoteException, VisADException {
        this((LocalDisplay)null);
    }

    protected Displayable(LocalDisplay display) throws RemoteException, VisADException {
        this.scalarMapSet = new ScalarMapSet();
        this.prevScalarMapSet = new ScalarMapSet();
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Displayable(Displayable that) throws RemoteException, VisADException {
        Displayable displayable = that;
        synchronized (displayable) {
            this.visible = that.visible;
            this.displayUnit = that.displayUnit;
            this.colorUnit = that.colorUnit;
            this.constantMaps = (ConstantMapSet)that.constantMaps.clone();
            this.scalarMapSet = new ScalarMapSet(that.scalarMapSet);
            this.prevScalarMapSet = new ScalarMapSet(that.prevScalarMapSet);
        }
    }

    public void toFront() throws RemoteException, VisADException {
        if (this.displayMaster != null && this.parent == null) {
            DisplayMaster myMaster = this.displayMaster;
            myMaster.removeDisplayable(this);
            myMaster.addDisplayable(this);
        }
    }

    public DisplayMaster getDisplayMaster() {
        if (this.displayMaster == null && this.parent != null) {
            return this.parent.getDisplayMaster();
        }
        return this.displayMaster;
    }

    protected void setDisplayMaster(DisplayMaster master) throws VisADException, RemoteException {
        this.displayMaster = master;
    }

    public void setUseFastRendering(boolean fastRender) throws VisADException, RemoteException {
        this.useFastRendering = fastRender;
    }

    public boolean getUseFastRendering() {
        return this.useFastRendering;
    }

    public void setPointMode(boolean usePoints) throws VisADException, RemoteException {
        this.pointMode = usePoints;
    }

    public boolean getPointMode() {
        return this.pointMode;
    }

    protected void setParent(CompositeDisplayable parent) {
        this.parent = parent;
    }

    public void setConstantPosition(double value, DisplayRealType type) throws VisADException, RemoteException {
        this.addConstantMap(new ConstantMap(value, type));
    }

    public void setDisplayInactive() throws RemoteException, VisADException {
        DisplayMaster master = this.getDisplayMaster();
        if (master != null) {
            master.setDisplayInactive();
        }
    }

    public void setDisplayActive() throws RemoteException, VisADException {
        final DisplayMaster master = this.getDisplayMaster();
        if (master != null) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    try {
                        master.setDisplayActive();
                    }
                    catch (Exception exc) {
                        Displayable.this.logException("Setting display master active", exc);
                    }
                }
            });
        }
    }

    public boolean isActive() throws RemoteException, VisADException {
        DisplayMaster master = this.getDisplayMaster();
        if (master == null) {
            return false;
        }
        return master.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplay(LocalDisplay display) throws RemoteException, VisADException {
        LocalDisplay oldDisplay;
        if (display == null) {
            throw new DisplayException(this.getClass().getName() + ".setDisplay(LocalDisplay): " + "Display is null");
        }
        Displayable displayable = this;
        synchronized (displayable) {
            this.removeDataReferences();
            oldDisplay = this.display;
            this.display = display;
        }
        this.firePropertyChange(DISPLAY, oldDisplay, this.display);
    }

    public final LocalDisplay getDisplay() {
        return this.display;
    }

    public final ScalarMapSet getScalarMapSet() {
        return this.scalarMapSet;
    }

    protected final boolean addRefsInvoked() {
        return this.addRefsInvoked;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyListeners().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.getPropertyListeners().addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.removePropertyChangeListener(name, listener);
        }
    }

    public synchronized ConstantMap addConstantMap(ConstantMap constantMap) throws RemoteException, VisADException {
        ConstantMap prev = this.constantMaps.put(constantMap);
        if (this.addRefsInvoked && (prev == null || !constantMap.equals(prev))) {
            this.myAddConstantMaps(this.getConstantMaps());
        }
        return prev;
    }

    public synchronized void addConstantMaps(ConstantMap[] maps) throws RemoteException, VisADException {
        boolean haveNew = false;
        if (maps.length > 0) {
            for (int i = 0; i < maps.length; ++i) {
                ConstantMap prev = this.constantMaps.put(maps[i]);
                if (prev != null && maps[i].equals(prev)) continue;
                haveNew = true;
            }
            if (this.addRefsInvoked && haveNew) {
                this.myAddConstantMaps(this.getConstantMaps());
            }
        }
    }

    public ConstantMap removeConstantMap(DisplayRealType displayRealType) {
        return this.constantMaps.remove(displayRealType);
    }

    public void setRangeForColor(double low, double hi) throws VisADException, RemoteException {
    }

    public void setRangeForColor(Range r) throws VisADException, RemoteException {
        this.setRangeForColor(r.getMin(), r.getMax());
    }

    public void setSelectedRange(Range r) throws VisADException, RemoteException {
        this.setSelectedRange(r.getMin(), r.getMax());
    }

    public void setSelectedRange(double low, double hi) throws VisADException, RemoteException {
    }

    public void setColorPalette(float[][] c) throws RemoteException, VisADException {
    }

    public void setContourInfo(ContourInfo contourInfo) throws VisADException, RemoteException {
    }

    public void setColorPalette(ColorTable colorTable) throws RemoteException, VisADException {
        this.setColorPalette(colorTable.getColorTable());
    }

    public void setColor(Color c) throws RemoteException, VisADException {
    }

    public void setPointSize(float size) throws RemoteException, VisADException {
    }

    public void setLineWidth(float size) throws RemoteException, VisADException {
    }

    public void setVisible(boolean visible) throws RemoteException, VisADException {
        this.visible = visible;
    }

    public void setManipulable(boolean manipulable) throws VisADException, RemoteException {
    }

    public boolean getVisible() {
        return this.visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final void addDataReferences() throws DisplayException, VisADException, RemoteException {
        if (this.display == null) {
            throw new DisplayException("Display not set");
        }
        this.myAddDataReferences();
        this.addRefsInvoked = true;
    }

    public final synchronized void removeDataReferences() throws DisplayException, VisADException, RemoteException {
        if (this.display != null) {
            this.myRemoveDataReferences();
            this.addRefsInvoked = false;
        }
    }

    protected abstract void myAddDataReferences() throws VisADException, RemoteException;

    protected abstract void myRemoveDataReferences() throws VisADException, RemoteException;

    protected void myAddConstantMaps(ConstantMap[] newMaps) throws VisADException, RemoteException {
        this.removeDataReferences();
        this.addDataReferences();
    }

    public void destroyDisplayable() throws RemoteException, VisADException {
        if (!this.destroyed) {
            this.destroy();
        }
    }

    public boolean getDestroyed() {
        return this.destroyed;
    }

    protected void destroy() throws RemoteException, VisADException {
        this.destroyed = true;
        this.display = null;
        this.parent = null;
        this.displayMaster = null;
        this.propertyListeners = null;
    }

    public void setScalarMapSet(ScalarMapSet maps) {
        this.scalarMapSet = maps;
        this.fireScalarMapSetChange();
    }

    public boolean hasDataObject() {
        return false;
    }

    public Data getData() throws VisADException, RemoteException {
        return null;
    }

    protected void addScalarMaps(ScalarMapSet maps) throws BadMappingException {
        this.scalarMapSet.add(maps);
        this.fireScalarMapSetChange();
    }

    protected void addScalarMap(ScalarMap map) throws BadMappingException {
        this.scalarMapSet.add(map);
    }

    protected ScalarMap getScalarMap(ScalarMap template) {
        return this.scalarMapSet.get(template);
    }

    protected void removeScalarMap(ScalarMap map) {
        this.scalarMapSet.remove(map);
    }

    protected synchronized void replaceScalarMap(ScalarMap oldMap, ScalarMap newMap) throws BadMappingException {
        if (oldMap != null) {
            this.scalarMapSet.remove(oldMap);
        }
        this.scalarMapSet.add(newMap);
    }

    protected static ScalarMap getScalarMap(LocalDisplay display, ScalarType scalarType, DisplayRealType displayRealType) throws VisADException, RemoteException {
        ScalarMap map = null;
        Iterator iter = display.getMapVector().iterator();
        while (!(!iter.hasNext() || (map = (ScalarMap)iter.next()).getScalar().equals(scalarType) && map.getDisplayScalar().equals(displayRealType))) {
        }
        return map;
    }

    protected static ScalarMap getScalarMap(LocalDisplay display, ScalarMap template) throws VisADException, RemoteException {
        return Displayable.getScalarMap(display, template.getScalar(), template.getDisplayScalar());
    }

    protected void firePropertyChange(final PropertyChangeEvent event) {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                Displayable.this.firePropertyChangeInThread(event);
            }
        });
    }

    private void firePropertyChangeInThread(PropertyChangeEvent event) {
        if (this.propertyListeners != null) {
            this.propertyListeners.firePropertyChange(event);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners != null) {
            this.propertyListeners.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeSupport getPropertyListeners() {
        if (this.propertyListeners == null) {
            Displayable displayable = this;
            synchronized (displayable) {
                if (this.propertyListeners == null) {
                    this.propertyListeners = new PropertyChangeSupport(this);
                }
            }
        }
        return this.propertyListeners;
    }

    public ConstantMap[] getConstantMaps() {
        return this.constantMaps.getConstantMaps();
    }

    public abstract Displayable cloneForDisplay() throws RemoteException, VisADException;

    protected ConstantMap[] combineConstantMaps(ConstantMapSet maps) {
        return ConstantMapSet.combine(this.constantMaps, maps).getConstantMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireScalarMapSetChange() {
        ScalarMapSet previous;
        Displayable displayable = this;
        synchronized (displayable) {
            previous = this.prevScalarMapSet;
            this.prevScalarMapSet = new ScalarMapSet(this.scalarMapSet);
        }
        this.firePropertyChange(SCALAR_MAP_SET, previous, this.scalarMapSet);
    }

    public void logException(String msg, Exception exc) {
        LogUtil.logException(msg, exc);
    }

    public void setDisplayUnit(Unit unit) throws RemoteException, VisADException {
        this.displayUnit = unit;
    }

    public Unit getDisplayUnit() throws RemoteException, VisADException {
        return this.displayUnit;
    }

    public void setColorUnit(Unit unit) throws RemoteException, VisADException {
        this.colorUnit = unit;
    }

    public Unit getColorUnit() throws RemoteException, VisADException {
        return this.colorUnit;
    }

    public void setAdjustFlow(boolean adjust) throws RemoteException, VisADException {
    }

    protected boolean isUnitCompatible(RealType realType, Unit unit) {
        if (unit == null || realType == null) {
            return true;
        }
        return Unit.canConvert(unit, realType.getDefaultUnit());
    }

    protected void checkUnit(RealType realType, Unit unit) throws VisADException, RemoteException {
        if (!this.isUnitCompatible(realType, unit)) {
            throw new VisADException("Unit: " + unit + " not compatible with data units " + realType.getDefaultUnit());
        }
    }

    protected void applyDisplayUnit(ScalarMap map, RealType realType) throws VisADException, RemoteException {
        if (map == null || realType == null) {
            return;
        }
        if (!this.isUnitCompatible(realType, this.displayUnit)) {
            this.displayUnit = null;
        }
        if (this.displayUnit == null) {
            map.setOverrideUnit(realType.getDefaultUnit());
            return;
        }
        map.setOverrideUnit(this.displayUnit);
    }

    protected void applyColorUnit(ScalarMap map, RealType realType) throws VisADException, RemoteException {
        if (map == null || realType == null) {
            return;
        }
        if (!this.isUnitCompatible(realType, this.colorUnit)) {
            this.colorUnit = null;
        }
        if (this.colorUnit == null) {
            map.setOverrideUnit(realType.getDefaultUnit());
            return;
        }
        map.setOverrideUnit(this.colorUnit);
    }

    public Set getAnimationSet(RealType aniType, boolean force) throws VisADException, RemoteException {
        return this.animationSet;
    }

    public void setOverrideAnimationSet(Set set) {
        this.animationSet = set;
    }

    public void setOverrideAnimationSet(List times) throws RemoteException, VisADException {
        this.animationSet = times == null || times.size() == 0 ? null : Util.makeTimeSet(times);
    }

    public void setUseTimesInAnimation(boolean value) throws RemoteException, VisADException {
        this.useTimesInAnimation = value;
        if (this.getDisplayMaster() != null) {
            this.getDisplayMaster().dataChange();
        }
    }

    public boolean getUseTimesInAnimation() {
        return this.useTimesInAnimation;
    }
}

