/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.Counter;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationWidget;
import ucar.visad.display.Displayable;
import ucar.visad.display.EventMap;
import ucar.visad.display.ScalarMapSet;
import visad.ConstantMap;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.Gridded1DDoubleSet;
import visad.KeyboardBehavior;
import visad.LocalDisplay;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public abstract class DisplayMaster {
    public static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DisplayMaster.class.getName());
    public static String POINT_MODE = "pointMode";
    private boolean isDestroyed = false;
    private DisplayImpl display;
    private Displayables displayables;
    private PropertyChangeSupport changeListeners;
    private volatile VetoableChangeSupport vetoableListeners;
    private JPanel jPanel;
    private boolean active = false;
    private boolean settingActive = false;
    private boolean haveInitialized = false;
    private int inactiveCount = 0;
    private Object INACTIVE_MUTEX = new Object();
    private ScalarMaps myScalarMaps = new ScalarMaps();
    private double[] myAspect = new double[]{1.0, 1.0, 1.0};
    private Dimension offscreenDimension;
    private Component offscreenComponent;
    private AnimationWidget animationWidget;
    protected KeyboardBehavior behavior;
    public static final int[][][] defaultMouseFunctions = EventMap.IDV_MOUSE_FUNCTIONS;
    private int[][] wheelEventMap = EventMap.IDV_WHEEL_FUNCTIONS;
    private int[][][] mouseFunctionMap;
    private final SimpleBackedScalarMaps displayableScalarMaps = new SimpleBackedScalarMaps(){

        @Override
        protected synchronized void populate() {
            Iterator iter = DisplayMaster.this.displayables.iterator();
            while (iter.hasNext()) {
                this.set.add(((Displayable)iter.next()).getScalarMapSet());
            }
            this.isDirty = false;
        }
    };
    private final SimpleBackedScalarMaps displayScalarMaps = new SimpleBackedScalarMaps(){

        @Override
        protected synchronized void populate() {
            this.set.add(DisplayMaster.this.display.getMapVector());
            this.isDirty = false;
        }
    };
    private final BackedScalarMaps desiredScalarMaps = new BackedScalarMaps(){

        @Override
        public boolean isDirty() {
            return DisplayMaster.this.displayableScalarMaps.isDirty() || DisplayMaster.this.myScalarMaps.isDirty();
        }

        @Override
        protected synchronized void populate() {
            this.set.add(DisplayMaster.this.displayableScalarMaps.asScalarMapSet());
            this.set.add(DisplayMaster.this.myScalarMaps.asScalarMapSet());
        }
    };
    private PropertyChangeListener displayableScalarMapsListener;
    private PropertyChangeListener displayableDisplayListener;
    private Animation animation = null;
    static Counter counter = new Counter();
    static int cnt = 0;
    int myCnt = cnt++;
    private Object IMAGE_SAVE_MUTEX = new Object();

    public void setWheelEventMap(int[][] map) {
        this.wheelEventMap = map;
    }

    public DisplayMaster() {
    }

    public DisplayMaster(DisplayImpl display) throws VisADException, RemoteException {
        this(display, 1);
    }

    public DisplayMaster(DisplayImpl display, int initialCapacity) throws VisADException, RemoteException {
        this(display, initialCapacity, null);
    }

    public DisplayMaster(DisplayImpl display, int initialCapacity, Dimension offscreenDimension) throws VisADException, RemoteException {
        this.setOffscreenDimension(offscreenDimension);
        this.init(display, initialCapacity);
    }

    public void init(DisplayImpl display, int initialCapacity) throws VisADException, RemoteException {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BoxLayout(this.jPanel, 0));
        this.displayables = new Displayables(initialCapacity);
        this.display = display;
        Component displayComp = display.getComponent();
        if (displayComp != null) {
            this.jPanel.add(displayComp);
            displayComp.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    DisplayMaster.this.handleMouseWheelMoved(e);
                }
            });
        } else {
            this.jPanel.add(this.getOffscreenComponent());
        }
        this.saveProjection();
        this.jPanel.setAlignmentX(0.5f);
        this.jPanel.setAlignmentY(0.5f);
        this.resetMouseFunctions();
        this.displayableScalarMapsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    DisplayMaster.this.displayableScalarMaps.setDirty();
                    DisplayMaster.this.rebuildDisplay();
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't handle change to ScalarMap-s of " + event.getSource() + ": " + e);
                    e.printStackTrace();
                }
            }
        };
        this.displayableDisplayListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ((LocalDisplay)event.getNewValue() != DisplayMaster.this.display) {
                    DisplayMaster.this.releaseDisplayable((Displayable)event.getSource());
                }
            }
        };
        this.changeListeners = new PropertyChangeSupport(this);
        this.vetoableListeners = new VetoableChangeSupport(this);
    }

    protected void setOffscreenDimension(Dimension dim) {
        this.offscreenDimension = dim;
    }

    protected Dimension getOffscreenDimension() {
        return this.offscreenDimension;
    }

    private Component getOffscreenComponent() {
        if (this.offscreenComponent == null) {
            this.offscreenComponent = new JPanel();
            if (this.offscreenDimension == null) {
                this.offscreenDimension = new Dimension(600, 400);
            }
            this.offscreenComponent.setSize(this.offscreenDimension);
        }
        return this.offscreenComponent;
    }

    public Component getDisplayComponent() {
        Component comp = this.display.getComponent();
        if (comp == null) {
            comp = this.getOffscreenComponent();
        }
        return comp;
    }

    public Rectangle getScreenBounds() {
        return this.getDisplayComponent().getBounds();
    }

    public boolean getDestroyed() {
        return this.isDestroyed;
    }

    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        if (this.jPanel != null) {
            GuiUtils.invokeInSwingThread(new Runnable(){

                @Override
                public void run() {
                    DisplayMaster.this.jPanel.removeAll();
                    if (DisplayMaster.this.jPanel.getParent() != null) {
                        DisplayMaster.this.jPanel.getParent().remove(DisplayMaster.this.jPanel);
                    }
                    DisplayMaster.this.jPanel = null;
                }
            });
        }
        Iterator iter = this.displayables.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.removePropertyChangeListener("scalarMapSet", this.displayableScalarMapsListener);
            displayable.removePropertyChangeListener("display", this.displayableDisplayListener);
            try {
                displayable.destroy();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.displayables.removeAll();
        this.myScalarMaps.removeAll();
        this.displayables = null;
        this.myScalarMaps = null;
        this.changeListeners = null;
        this.vetoableListeners = null;
        this.displayableScalarMapsListener = null;
        this.displayableDisplayListener = null;
        try {
            this.display.destroy();
        }
        catch (Exception e) {
            System.err.println("DisplayMaster.destroy:");
            e.printStackTrace();
        }
        this.display = null;
        this.animationWidget = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public Component getComponent() {
        return this.jPanel;
    }

    protected synchronized void reDisplayAll() {
        if (this.display != null) {
            this.display.reDisplayAll();
        }
    }

    public void reScale() {
        if (this.display != null) {
            this.display.reAutoScale();
        }
    }

    public synchronized void rebuildDisplay() throws VisADException, RemoteException {
        if (!this.active) {
            return;
        }
        if (!this.desiredScalarMaps.isDirty()) {
            this.addDataReferences();
        } else {
            ScalarMapSet oldMaps = ScalarMapSet.subtract(this.displayScalarMaps.asScalarMapSet(), this.desiredScalarMaps.asScalarMapSet());
            ScalarMapSet newMaps = ScalarMapSet.subtract(this.desiredScalarMaps.asScalarMapSet(), this.displayScalarMaps.asScalarMapSet());
            boolean rebuild = false;
            if (oldMaps.size() > 0 && !this.removeOldScalarMaps(oldMaps)) {
                rebuild = true;
            }
            if (!rebuild && newMaps.size() > 0) {
                Iterator iter = newMaps.iterator();
                while (iter.hasNext()) {
                    if (!(iter.next() instanceof ConstantMap)) continue;
                    rebuild = true;
                    break;
                }
                if (!rebuild && !this.addNewScalarMaps(newMaps)) {
                    rebuild = true;
                }
            }
            if (rebuild) {
                this.rebuild();
            } else {
                this.addDataReferences();
            }
            this.myScalarMaps.setClean();
        }
    }

    protected synchronized void rebuild() throws VisADException, RemoteException {
        this.display.disableAction();
        this.removeDataReferences();
        this.removeScalarMaps();
        try {
            this.addScalarMaps();
            this.addDataReferences();
        }
        finally {
            this.display.enableAction();
        }
    }

    public void setAnimation(Animation animation, AnimationWidget animationWidget) throws VisADException, RemoteException {
        this.addDisplayable(animation);
        this.animationWidget = animationWidget;
    }

    public final LocalDisplay getDisplay() {
        return this.display;
    }

    public final int getDisplayableCount() {
        return this.displayables.size();
    }

    public final synchronized void addDisplayable(Displayable displayable) throws RemoteException, VisADException {
        this.setDisplayables(this.getDisplayableCount(), displayable);
    }

    public final synchronized void setDisplayables(int index, Displayable displayable) throws VisADException, RemoteException {
        Displayable prev;
        this.setDisplayInactive();
        if (index >= 0 && index < this.getDisplayableCount() && (prev = this.displayables.get(index)) != null) {
            this.removeDisplayable(prev);
        }
        displayable.setDisplayMaster(this);
        if (displayable instanceof Animation) {
            this.animation = (Animation)displayable;
        }
        this.displayables.add(index, displayable);
        displayable.setDisplay(this.getDisplay());
        displayable.addPropertyChangeListener("scalarMapSet", this.displayableScalarMapsListener);
        displayable.addPropertyChangeListener("display", this.displayableDisplayListener);
        if (displayable.getScalarMapSet().size() != 0) {
            this.displayableScalarMaps.setDirty();
        }
        this.setDisplayActive();
        if (this.active) {
            displayable.addDataReferences();
        }
    }

    public final synchronized void setDisplayables(Displayable[] displayables) throws VisADException, RemoteException {
        this.setDisplayInactive();
        for (int i = 0; i < displayables.length; ++i) {
            this.setDisplayables(i, displayables[i]);
        }
        this.setDisplayActive();
    }

    public synchronized boolean removeDisplayable(Displayable displayable) throws VisADException, RemoteException {
        if (displayable == null) {
            return false;
        }
        boolean existed = this.releaseDisplayable(displayable);
        if (existed) {
            displayable.removeDataReferences();
            ScalarMapSet maps = displayable.getScalarMapSet();
            if (maps.size() > 0) {
                if (displayable instanceof Animation) {
                    this.animation = null;
                }
                this.displayableScalarMaps.setDirty();
                this.rebuildDisplay();
            }
        }
        return existed;
    }

    public synchronized void removeDisplayables() throws VisADException, RemoteException {
        this.setDisplayInactive();
        int i = this.displayables.size();
        while (--i >= 0) {
            this.removeDisplayable(this.displayables.get(i));
        }
        this.setDisplayActive();
    }

    public void setBackground(Color color) {
        try {
            float[] rgb = color.getRGBComponents(null);
            this.getDisplay().getDisplayRenderer().getRendererControl().setBackgroundColor(rgb[0], rgb[1], rgb[2]);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Color getBackground() {
        float[] rgb = this.getDisplay().getDisplayRenderer().getRendererControl().getBackgroundColor();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public Color getForeground() {
        float[] rgb = this.getDisplay().getDisplayRenderer().getRendererControl().getCursorColor();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public void setForeground(Color color) {
        try {
            float[] rgb = color.getRGBComponents(null);
            this.getDisplay().getDisplayRenderer().getRendererControl().setForegroundColor(rgb[0], rgb[1], rgb[2]);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public final Displayable getDisplayables(int index) {
        return this.displayables.get(index);
    }

    public final Displayable[] getDisplayables() {
        return this.displayables.toArray();
    }

    public int indexOf(Displayable displayable) {
        return this.displayables.indexOf(displayable);
    }

    public void setPointMode(boolean usePoints) throws VisADException, RemoteException {
        GraphicsModeControl gmc = this.display.getGraphicsModeControl();
        Boolean oldPointMode = new Boolean(gmc.getPointMode());
        gmc.setPointMode(usePoints);
        this.firePropertyChange(POINT_MODE, oldPointMode, new Boolean(usePoints));
    }

    public boolean isPointMode() {
        return this.display.getGraphicsModeControl().getPointMode();
    }

    public void saveProjection() {
        this.display.getProjectionControl().saveProjection();
    }

    public void setDisplayAspect(double[] newAspect) throws VisADException, RemoteException {
        if (!this.is3D()) {
            newAspect = new double[]{newAspect[0], newAspect[1]};
        }
        this.display.getProjectionControl().setAspect(newAspect);
        this.myAspect = newAspect;
    }

    protected boolean is3D() {
        return this.display instanceof DisplayImplJ3D;
    }

    public double[] getDisplayAspect() {
        return this.myAspect;
    }

    public double[] getProjectionMatrix() {
        return this.display.getProjectionControl().getMatrix();
    }

    public double getScale() {
        double[] currentMatrix = this.getProjectionMatrix();
        double[] trans = new double[]{0.0, 0.0, 0.0};
        double[] rot = new double[]{0.0, 0.0, 0.0};
        double[] scale = new double[]{0.0, 0.0, 0.0};
        this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, currentMatrix);
        return scale[0];
    }

    public double[] getRotation() {
        double[] currentMatrix = this.getProjectionMatrix();
        double[] trans = new double[]{0.0, 0.0, 0.0};
        double[] rot = new double[]{0.0, 0.0, 0.0};
        double[] scale = new double[]{0.0, 0.0, 0.0};
        this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, currentMatrix);
        return rot;
    }

    public void setProjectionMatrix(double[] newMatrix) throws VisADException, RemoteException {
        this.display.getProjectionControl().setMatrix(newMatrix);
    }

    public double[] getSavedProjectionMatrix() {
        return this.display.getProjectionControl().getSavedProjectionMatrix();
    }

    public void resetProjection() throws VisADException, RemoteException {
        this.display.getProjectionControl().resetProjection();
    }

    public void addKeyboardBehavior(KeyboardBehavior behavior) {
    }

    protected void setKeyboardBehavior(KeyboardBehavior behavior) {
        this.behavior = behavior;
    }

    public void setKeyboardEventMap(int[][] map) {
        DisplayMaster.setKeyboardEventMap(map, this.behavior);
    }

    public static void setKeyboardEventMap(int[][] map, KeyboardBehavior behavior) {
        if (behavior == null) {
            return;
        }
        for (int i = 0; i < map.length; ++i) {
            int[] settings = map[i];
            behavior.mapKeyToFunction(settings[0], settings[1], settings[2]);
        }
    }

    public void setMouseFunctions(int[][][] map) throws VisADException {
        this.mouseFunctionMap = map;
        this.getMouseBehavior().getMouseHelper().setFunctionMap(map);
    }

    public int[][][] getMouseFunctionMap() {
        return this.mouseFunctionMap;
    }

    public MouseBehavior getMouseBehavior() {
        return this.getDisplay().getDisplayRenderer().getMouseBehavior();
    }

    public void rotateX(double angle) {
        this.rotate(angle, 0.0, 0.0);
    }

    public void rotateY(double angle) {
        this.rotate(0.0, angle, 0.0);
    }

    public void rotateZ(double angle) {
        this.rotate(0.0, 0.0, angle);
    }

    protected void handleMouseWheelMoved(MouseWheelEvent e) {
        int shift;
        int rot = e.getWheelRotation();
        double rotd = e.getPreciseWheelRotation();
        double degrees = 1.0;
        int control = e.isControlDown() ? 1 : 0;
        int func = this.wheelEventMap[control][shift = e.isShiftDown() ? 1 : 0];
        if (func == EventMap.WHEEL_ROTATEZ) {
            if (rot < 0) {
                this.rotateZ(degrees);
            } else {
                this.rotateZ(-degrees);
            }
        } else if (func == EventMap.WHEEL_ROTATEX) {
            if (rot < 0 || rotd < 0.0) {
                this.rotateX(degrees);
            } else {
                this.rotateX(-degrees);
            }
        } else if (func == EventMap.WHEEL_ROTATEY) {
            if (rot < 0) {
                this.rotateY(degrees);
            } else {
                this.rotateY(-degrees);
            }
        } else if (func == EventMap.WHEEL_ZOOMIN) {
            if (rot < 0) {
                this.zoom(0.9);
            } else if (rotd < 0.0) {
                this.zoom(0.95);
            } else if ((double)rot == 0.0) {
                this.zoom(1.05);
            } else {
                this.zoom(1.1);
            }
        } else if (func == EventMap.WHEEL_ZOOMOUT) {
            if (rot < 0) {
                this.zoom(1.1);
            } else {
                this.zoom(0.9);
            }
        }
    }

    public void zoom(double factor) {
        this.zoom(factor, factor, factor);
    }

    public void zoom(double xfactor, double yfactor, double zfactor) {
        double[] scaleMatrix = this.getMouseBehavior().make_matrix(0.0, 0.0, 0.0, xfactor, yfactor, zfactor, 0.0, 0.0, 0.0);
        double[] currentMatrix = this.getProjectionMatrix();
        scaleMatrix = this.getMouseBehavior().multiply_matrix(scaleMatrix, currentMatrix);
        try {
            this.setProjectionMatrix(scaleMatrix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float getDisplayScale() {
        if (this.display != null) {
            ProjectionControl pc = this.display.getProjectionControl();
            double[] init_matrix = pc.getSavedProjectionMatrix();
            double[] rot_a = new double[3];
            double[] trans_a = new double[3];
            double[] scale_a = new double[1];
            MouseBehavior mouse = this.display.getMouseBehavior();
            mouse.instance_unmake_matrix(rot_a, scale_a, trans_a, init_matrix);
            double init_zoom = scale_a[0];
            double[] matrix = pc.getMatrix();
            mouse.instance_unmake_matrix(rot_a, scale_a, trans_a, matrix);
            return (float)(init_zoom / scale_a[0]);
        }
        return 1.0f;
    }

    public void translate(double xFactor, double yFactor) {
        try {
            double[] currentMatrix = this.getProjectionMatrix();
            double[] translateMatrix = this.getMouseBehavior().make_translate(xFactor, yFactor);
            translateMatrix = this.getMouseBehavior().multiply_matrix(translateMatrix, currentMatrix);
            this.setProjectionMatrix(translateMatrix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rotate(double anglex, double angley, double anglez) {
        double[] t1 = this.getMouseBehavior().make_matrix(anglex, angley, anglez, 1.0, 0.0, 0.0, 0.0);
        double[] currentMatrix = this.getProjectionMatrix();
        t1 = this.getMouseBehavior().multiply_matrix(t1, currentMatrix);
        try {
            this.setProjectionMatrix(t1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetMouseFunctions() throws VisADException {
        DisplayMaster.setDefaultMouseFunctions(this.display);
    }

    public static void setDefaultMouseFunctions(DisplayImpl display) throws VisADException {
        display.getDisplayRenderer().getMouseBehavior().getMouseHelper().setFunctionMap(defaultMouseFunctions);
    }

    public void setWaitMessageVisible(boolean visible) {
        this.getDisplay().getDisplayRenderer().setWaitMessageVisible(visible);
    }

    public boolean getWaitMessageVisible() {
        return this.getDisplay().getDisplayRenderer().getWaitMessageVisible();
    }

    public void setAnimationStringVisible(boolean visible) {
        this.getDisplay().getDisplayRenderer().setAnimationStringVisible(visible);
    }

    public boolean getAnimationStringVisible() {
        return this.getDisplay().getDisplayRenderer().getAnimationStringVisible();
    }

    public boolean getStereoAvailable() {
        return false;
    }

    public void setEyePosition(double position) {
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableListeners.addVetoableChangeListener(listener);
    }

    public void addVetoableChangeListener(String name, VetoableChangeListener listener) {
        this.vetoableListeners.addVetoableChangeListener(name, listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableListeners.removeVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener listener) {
        this.vetoableListeners.removeVetoableChangeListener(name, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeListeners.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeListeners.removePropertyChangeListener(name, listener);
    }

    public synchronized void draw() throws VisADException, RemoteException {
        this.haveInitialized = true;
        this.setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object obj) {
        boolean equals;
        if (!(obj instanceof DisplayMaster)) {
            equals = false;
        } else {
            DisplayMaster that;
            DisplayMaster displayMaster = that = (DisplayMaster)obj;
            synchronized (displayMaster) {
                equals = this == that || this.display.equals(that.display) && this.displayables.equals(that.displayables) && this.changeListeners.equals(that.changeListeners) && this.vetoableListeners.equals(that.vetoableListeners) && this.myScalarMaps.equals(that.myScalarMaps);
            }
        }
        return equals;
    }

    public synchronized int hashCode() {
        return this.display.hashCode() ^ this.displayables.hashCode() ^ this.changeListeners.hashCode() ^ this.vetoableListeners.hashCode();
    }

    public void addDisplayListener(DisplayListener listener) {
        this.getDisplay().addDisplayListener(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.changeListeners.firePropertyChange(event);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeListeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    private synchronized void removeDataReferences() throws VisADException, RemoteException {
        int i = this.displayables.size();
        while (--i >= 0) {
            this.displayables.get(i).removeDataReferences();
        }
    }

    private synchronized void removeScalarMaps() throws VisADException, RemoteException {
        this.display.clearMaps();
        if (this.displayScalarMaps.size() != 0) {
            this.displayScalarMaps.setDirty();
        }
    }

    protected synchronized void addScalarMap(ScalarMap map) throws VisADException, RemoteException {
        ScalarMapSet set = new ScalarMapSet();
        set.add(map);
        this.addScalarMaps(set);
    }

    protected synchronized void addScalarMaps(ScalarMapSet mapSet) throws VisADException, RemoteException {
        this.myScalarMaps.add(mapSet);
        this.rebuildDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean addNewScalarMaps(ScalarMapSet mapSet) throws VisADException, RemoteException {
        boolean success = false;
        if (mapSet.size() == 0) {
            success = true;
        } else {
            this.setDisplayInactive();
            try {
                Iterator mapIter = mapSet.iterator();
                while (mapIter.hasNext()) {
                    this.display.addMap((ScalarMap)mapIter.next());
                    this.displayScalarMaps.setDirty();
                }
                success = true;
            }
            catch (DisplayException ex) {
                System.err.println(ex);
                success = false;
            }
            finally {
                this.setDisplayActive();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean removeOldScalarMaps(ScalarMapSet mapSet) throws VisADException, RemoteException {
        boolean success = false;
        if (mapSet.size() == 0) {
            success = true;
        } else {
            this.setDisplayInactive();
            try {
                Iterator mapIter = mapSet.iterator();
                while (mapIter.hasNext()) {
                    this.display.removeMap((ScalarMap)mapIter.next());
                    this.displayScalarMaps.setDirty();
                }
                success = true;
            }
            catch (DisplayException ex) {
                System.err.println(ex);
                success = false;
            }
            finally {
                this.setDisplayActive();
            }
        }
        return success;
    }

    protected synchronized void removeScalarMaps(ScalarMapSet mapSet) throws VisADException, RemoteException {
        this.myScalarMaps.remove(mapSet);
        this.rebuildDisplay();
    }

    protected synchronized boolean removeScalarMap(ScalarMap map) throws VisADException, RemoteException {
        boolean existed = this.myScalarMaps.remove(map);
        this.rebuildDisplay();
        return existed;
    }

    protected synchronized void replaceScalarMap(ScalarMap oldMap, ScalarMap newMap) throws VisADException, RemoteException {
        this.setDisplayInactive();
        this.removeScalarMap(oldMap);
        this.addScalarMap(newMap);
        this.setDisplayActive();
    }

    private synchronized void addScalarMaps() throws VisADException, RemoteException {
        if (this.desiredScalarMaps.size() > 0) {
            this.setDisplayInactive();
            Iterator iter = this.desiredScalarMaps.iterator();
            while (iter.hasNext()) {
                this.display.addMap((ScalarMap)iter.next());
            }
            this.myScalarMaps.setClean();
            this.displayScalarMaps.setDirty();
            this.setDisplayActive();
        }
    }

    private synchronized void addDataReferences() throws VisADException, RemoteException {
        Iterator iter = this.displayables.iterator();
        while (iter.hasNext()) {
            ((Displayable)iter.next()).addDataReferences();
        }
    }

    public synchronized void setRebuildNecessary() {
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    private boolean doTrace() {
        if (this.myCnt == 0) {
            // empty if block
        }
        return false;
    }

    public void printMe() {
        System.err.println(this.myCnt + " active?" + this.active + " cnt=" + this.inactiveCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayInactive() {
        try {
            boolean shouldCall = false;
            Object object = this.INACTIVE_MUTEX;
            synchronized (object) {
                if (this.settingActive) {
                    if (this.doTrace()) {
                        Trace.msg(this.myCnt + " ***** DisplayMaster.setDisplayActive - is setting active");
                    }
                    return;
                }
                if (this.doTrace()) {
                    Trace.call1(this.myCnt + " DisplayMaster.setDisplayInActive", " count=" + this.inactiveCount);
                    Misc.printStack("setDisplayInactive", 4, null);
                }
                ++this.inactiveCount;
                shouldCall = this.inactiveCount == 1;
            }
            if (shouldCall) {
                this.setActive(false);
            }
            if (this.doTrace()) {
                Trace.call2(this.myCnt + " DisplayMaster.setDisplayInActive", " count=" + this.inactiveCount);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayActive() throws RemoteException, VisADException {
        boolean shouldCall = false;
        Object object = this.INACTIVE_MUTEX;
        synchronized (object) {
            if (this.settingActive) {
                if (this.doTrace()) {
                    Trace.msg(this.myCnt + " ***** DisplayMaster.setDisplayActive -  is settingActive");
                }
                return;
            }
            if (this.doTrace()) {
                Trace.call1(this.myCnt + " DisplayMaster.setDisplayActive", " count=" + this.inactiveCount);
                Misc.printStack("setDisplayActive", 4, null);
            }
            this.inactiveCount = Math.max(0, this.inactiveCount - 1);
            shouldCall = this.inactiveCount == 0;
        }
        if (shouldCall) {
            this.setActive(true);
        }
        if (this.doTrace()) {
            Trace.call2(this.myCnt + " DisplayMaster.setDisplayActive", " count=" + this.inactiveCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean newActiveValue) throws RemoteException, VisADException {
        Object object = this.INACTIVE_MUTEX;
        synchronized (object) {
            if (this.active == newActiveValue) {
                return;
            }
            if (this.settingActive) {
                return;
            }
            this.settingActive = true;
            if (newActiveValue) {
                this.inactiveCount = 0;
            }
            if (this.haveInitialized) {
                this.active = newActiveValue;
            }
        }
        if (this.haveInitialized) {
            if (this.active) {
                this.rebuildDisplay();
            }
            this.display.setEnabled(this.active);
        }
        this.settingActive = false;
    }

    public synchronized boolean ensureInactive() {
        boolean prev = this.active;
        try {
            this.setActive(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prev;
    }

    private synchronized boolean releaseDisplayable(Displayable displayable) {
        ScalarMapSet scalarMapSet = displayable.getScalarMapSet();
        if (scalarMapSet != null && scalarMapSet.size() > 0) {
            this.displayableScalarMaps.setDirty();
        }
        displayable.removePropertyChangeListener("scalarMapSet", this.displayableScalarMapsListener);
        displayable.removePropertyChangeListener("display", this.displayableDisplayListener);
        return this.displayables.remove(displayable);
    }

    public void saveCurrentDisplay(File toFile) {
        this.saveCurrentDisplay(toFile, false, false);
    }

    protected Set getAnimationSetFromDisplayables() throws VisADException, RemoteException {
        Set aniSet = null;
        if (this.animation == null) {
            return aniSet;
        }
        RealType aniType = this.animation.getAnimationRealType();
        Iterator iter = this.displayables.iterator();
        while (iter.hasNext()) {
            Set set;
            Displayable displayable = (Displayable)iter.next();
            if (displayable == null || !displayable.getUseTimesInAnimation() || (set = displayable.getAnimationSet(aniType, false)) == null || set == null) continue;
            aniSet = aniSet == null ? set : aniSet.merge1DSets(set);
        }
        return aniSet;
    }

    protected Set buildAnimationSet() throws VisADException, RemoteException {
        if (this.animationWidget != null && this.animationWidget.getAnimationSetInfo().getActive()) {
            return this.animationWidget.getAnimationSetInfo().makeTimeSet(this);
        }
        return this.getAnimationSetFromDisplayables();
    }

    private boolean animationSetsEquals(Set set1, Set set2) throws VisADException, RemoteException {
        if (set1 == null || set2 == null) {
            return false;
        }
        if (!(set1 instanceof Gridded1DDoubleSet) || !(set2 instanceof Gridded1DDoubleSet)) {
            return Misc.equals(set1, set2);
        }
        Gridded1DDoubleSet g1 = (Gridded1DDoubleSet)set1;
        Gridded1DDoubleSet g2 = (Gridded1DDoubleSet)set2;
        double[][] v1 = g1.getDoubles(false);
        double[][] v2 = g2.getDoubles(false);
        return Misc.arraysEquals(v1, v2);
    }

    protected void dataChange() throws VisADException, RemoteException {
        Set set;
        if (this.animation != null && !this.animationSetsEquals(set = this.buildAnimationSet(), this.animation.getSet())) {
            this.animation.setSet(set, true);
        }
    }

    public void saveCurrentDisplay(File toFile, boolean doSync, boolean block) {
        this.saveCurrentDisplay(toFile, doSync, block, 1.0f);
    }

    public void saveCurrentDisplay(File toFile, final boolean doSync, boolean block, final float quality) {
        final File saveFile = toFile;
        try {
            Runnable captureImage = new Runnable(){

                @Override
                public void run() {
                    BufferedImage image;
                    LocalDisplay display = DisplayMaster.this.getDisplay();
                    DisplayRenderer renderer = display.getDisplayRenderer();
                    Thread thread = Thread.currentThread();
                    if (display instanceof DisplayImpl) {
                        renderer.setWaitMessageVisible(false);
                        image = ((DisplayImpl)display).getImage(doSync);
                        renderer.setWaitMessageVisible(true);
                    } else {
                        image = display.getImage();
                    }
                    try {
                        ImageUtils.writeImageToFile(image, saveFile.toString(), quality);
                    }
                    catch (Exception err) {
                        LogUtil.logException("Problem saving image", err);
                    }
                }
            };
            Thread t = new Thread(captureImage);
            if (block) {
                t.run();
            } else {
                t.start();
            }
        }
        catch (Exception exp) {
            LogUtil.logException("Problem saving image", exp);
        }
    }

    public BufferedImage getImage(boolean doSync) throws Exception {
        BufferedImage image;
        LocalDisplay display = this.getDisplay();
        DisplayRenderer renderer = display.getDisplayRenderer();
        if (display instanceof DisplayImpl) {
            renderer.setWaitMessageVisible(false);
            image = ((DisplayImpl)display).getImage(doSync);
            renderer.setWaitMessageVisible(true);
        } else {
            image = display.getImage();
        }
        return image;
    }

    public void printMatrix(String name, double[] matrix) {
        MouseBehavior behavior = this.getDisplay().getDisplayRenderer().getMouseBehavior();
        behavior.getMouseHelper().print_matrix(name, matrix);
    }

    private static class Displayables {
        private final List<Displayable> list;

        public Displayables(int count) {
            this.list = Collections.synchronizedList(new ArrayList(count));
        }

        public Iterator iterator() {
            return new ArrayList<Displayable>(this.list).iterator();
        }

        public int size() {
            return this.list.size();
        }

        public Displayable get(int index) {
            return this.list.get(index);
        }

        public void add(int index, Displayable displayable) {
            this.list.add(index, displayable);
        }

        public Displayable[] toArray() {
            return this.list.toArray(new Displayable[this.list.size()]);
        }

        public int indexOf(Displayable displayable) {
            return this.list.indexOf(displayable);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Displayables)) {
                return false;
            }
            return this.list.equals(((Displayables)obj).list);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public boolean remove(Displayable displayable) {
            return this.list.remove(displayable);
        }

        public void removeAll() {
            this.list.clear();
        }
    }

    private static class ScalarMaps {
        private boolean isDirty = true;
        private final ScalarMapSet set = new ScalarMapSet();

        public synchronized void add(ScalarMapSet that) {
            int size = this.size();
            this.set.add(that);
            if (size != this.size()) {
                this.isDirty = true;
            }
        }

        public synchronized boolean remove(ScalarMap map) {
            boolean existed = this.set.remove(map);
            if (existed) {
                this.isDirty = true;
            }
            return existed;
        }

        public synchronized void remove(ScalarMapSet that) {
            int size = this.size();
            this.set.remove(that);
            if (size != this.size()) {
                this.isDirty = true;
            }
        }

        public synchronized void removeAll() {
            int size = this.size();
            this.set.removeAll();
            if (size != this.size()) {
                this.isDirty = true;
            }
        }

        public synchronized int size() {
            return this.set.size();
        }

        public ScalarMapSet asScalarMapSet() {
            return this.set;
        }

        public synchronized void setClean() {
            this.isDirty = false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ScalarMaps)) {
                return false;
            }
            return this.set.equals(((ScalarMaps)obj).set);
        }

        public int hashCode() {
            return this.set.hashCode();
        }

        public synchronized boolean isDirty() {
            return this.isDirty;
        }

        public synchronized String toString() {
            return this.set.toString();
        }
    }

    private static abstract class SimpleBackedScalarMaps
    extends BackedScalarMaps {
        protected boolean isDirty = true;

        private SimpleBackedScalarMaps() {
        }

        public synchronized void setDirty() {
            if (!this.isDirty) {
                this.set.clear();
            }
            this.isDirty = true;
        }

        @Override
        public synchronized boolean isDirty() {
            return this.isDirty;
        }
    }

    private static abstract class BackedScalarMaps {
        protected final ScalarMapSet set = new ScalarMapSet();

        public synchronized int size() {
            this.sync();
            return this.set.size();
        }

        public synchronized Iterator iterator() {
            this.sync();
            return this.set.iterator();
        }

        public synchronized boolean equals(Object obj) {
            this.sync();
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BackedScalarMaps)) {
                return false;
            }
            return this.set.equals(((BackedScalarMaps)obj).set);
        }

        public synchronized int hashCode() {
            this.sync();
            return this.set.hashCode();
        }

        public ScalarMapSet asScalarMapSet() {
            this.sync();
            return this.set;
        }

        public synchronized String toString() {
            this.sync();
            return this.set.toString();
        }

        private synchronized void sync() {
            if (this.isDirty()) {
                this.set.clear();
                this.populate();
            }
        }

        public abstract boolean isDirty();

        protected abstract void populate();
    }
}

