/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import ucar.visad.ShapeUtility;
import ucar.visad.display.Displayable;
import ucar.visad.display.ProfileLine;
import ucar.visad.display.SelectorDisplayable;
import ucar.visad.display.SelectorPoint;
import visad.ActionImpl;
import visad.ConstantMap;
import visad.Display;
import visad.DisplayRealType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.VisADException;
import visad.VisADGeometryArray;

public class CrossSectionSelector
extends SelectorDisplayable {
    public static final String PROPERTY_STARTPOINT = "SelectorDisplay.startpoint";
    public static final String PROPERTY_ENDPOINT = "SelectorDisplay.endpoint";
    public static final String PROPERTY_MIDPOINT = "SelectorDisplay.midpoint";
    private static final Real TWO = new Real(2.0);
    private ProfileLine line;
    private boolean beenInitialized = false;
    private SelectorPoint startSp;
    private SelectorPoint endSp;
    private SelectorPoint midSp;
    private RealTuple startPoint;
    private RealTuple endPoint;
    private RealTuple midPoint;
    private RealTupleType tupleType;
    private RealTuple ZERO2D;
    private RealTuple ZERO3D;
    private boolean amMoving = false;
    public static final int POINT_START = 0;
    public static final int POINT_END = 1;
    public static final int POINT_MID = 2;
    private boolean interpolateLinePoints = false;

    public CrossSectionSelector() throws VisADException, RemoteException {
        this(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{-1.0, 0.0}), new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{1.0, 0.0}));
    }

    public CrossSectionSelector(RealTuple startPoint, RealTuple endPoint) throws VisADException, RemoteException {
        this(startPoint, endPoint, Color.white);
    }

    public CrossSectionSelector(RealTuple startPoint, RealTuple endPoint, Color color) throws VisADException, RemoteException {
        this.tupleType = (RealTupleType)startPoint.getType();
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        this.midPoint = this.calculateMidpoint();
        this.startSp = this.makeSelectorPoint(0, "Start", startPoint);
        this.endSp = this.makeSelectorPoint(1, "End", endPoint);
        this.midSp = this.makeSelectorPoint(2, "Middle", this.midPoint);
        this.line = this.makeLine();
        this.ZERO2D = new RealTuple(RealTupleType.SpatialEarth2DTuple, new double[]{0.0, 0.0});
        this.ZERO3D = new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{0.0, 0.0, 0.0});
        this.setColor(color);
        this.beenInitialized = true;
    }

    public SelectorPoint getStartSelectorPoint() {
        return this.startSp;
    }

    public SelectorPoint getEndSelectorPoint() {
        return this.endSp;
    }

    public SelectorPoint getMiddleSelectorPoint() {
        return this.midSp;
    }

    public void dontShowStartPoint() throws VisADException, RemoteException {
        this.removeDisplayable(this.startSp);
    }

    public void dontShowMiddlePoint() throws VisADException, RemoteException {
        this.removeDisplayable(this.midSp);
    }

    public void dontShowEndPoint() throws VisADException, RemoteException {
        this.removeDisplayable(this.endSp);
    }

    public CrossSectionSelector(CrossSectionSelector that) throws VisADException, RemoteException {
        super(that);
        this.positionHasChanged();
    }

    private ProfileLine makeLine() throws VisADException, RemoteException {
        this.line = new ProfileLine("CrossSectionLine");
        this.setLineData();
        this.addDisplayable(this.line);
        return this.line;
    }

    private void setLineData() throws VisADException, RemoteException {
        RealTuple startRt = this.startSp.getPoint();
        RealTuple endRt = this.endSp.getPoint();
        int numPoints = this.interpolateLinePoints ? 100 : 2;
        int length = startRt.getDimension();
        float[][] values = new float[length][numPoints];
        for (int i = 0; i < length; ++i) {
            float start = (float)((Real)startRt.getComponent(i)).getValue();
            float end = (float)((Real)endRt.getComponent(i)).getValue();
            values[i][0] = start;
            values[i][numPoints - 1] = end;
            for (int j = 1; j < numPoints - 1; ++j) {
                double percent = (double)j / (double)numPoints;
                values[i][j] = start + (float)(percent * (double)(end - start));
            }
        }
        GriddedSet lineData = length == 2 ? new Gridded2DSet((MathType)this.tupleType, values, numPoints) : new Gridded3DSet((MathType)this.tupleType, values, numPoints);
        if (!((Object)lineData).equals(this.line.getData())) {
            this.line.setData(lineData);
        }
    }

    @Override
    public void setPointSize(float size) throws VisADException, RemoteException {
        super.setPointSize(size);
        this.midSp.setPointSize(size + 0.02f);
    }

    @Override
    public void setColor(Color newColor) throws VisADException, RemoteException {
        super.setColor(newColor);
        this.midSp.setColor(newColor.darker());
    }

    @Override
    public void setAutoSize(boolean yesorno) throws VisADException, RemoteException {
        this.startSp.setAutoSize(yesorno);
        this.midSp.setAutoSize(yesorno);
        this.endSp.setAutoSize(yesorno);
        super.setAutoSize(yesorno);
    }

    public void setZValue(double zValue) throws VisADException, RemoteException {
        this.startSp.addConstantMap(new ConstantMap(zValue, Display.ZAxis));
        this.endSp.addConstantMap(new ConstantMap(zValue, Display.ZAxis));
        this.midSp.addConstantMap(new ConstantMap(zValue, Display.ZAxis));
        this.line.addConstantMap(new ConstantMap(zValue, Display.ZAxis));
    }

    @Override
    public void setConstantPosition(double value, DisplayRealType type) throws VisADException, RemoteException {
        this.setZValue(value);
    }

    private RealTuple calculateMidpoint() throws VisADException, RemoteException {
        return (RealTuple)this.startPoint.add(this.endPoint).divide(TWO);
    }

    public void setStartPtFixed(boolean value) throws VisADException, RemoteException {
        this.startSp.setManipulable(value);
    }

    public void setStartPointFixed(boolean value) throws VisADException, RemoteException {
        this.startSp.setManipulable(value);
    }

    public void setEndPointFixed(boolean value) throws VisADException, RemoteException {
        this.endSp.setManipulable(value);
    }

    public void setStartPointVisible(boolean value) throws VisADException, RemoteException {
        this.startSp.setVisible(value);
    }

    public void setEndPointVisible(boolean value) throws VisADException, RemoteException {
        this.endSp.setVisible(value);
    }

    public void setMidPointVisible(boolean value) throws VisADException, RemoteException {
        this.midSp.setVisible(value);
    }

    public void setStartPoint(RealTuple point) throws VisADException, RemoteException {
        this.setPoint(0, point);
    }

    public RealTuple getStartPoint() {
        return this.startPoint;
    }

    public void setMidPoint(RealTuple point) throws VisADException, RemoteException {
        this.startPoint = this.startSp.getPoint();
        this.endPoint = this.endSp.getPoint();
        this.midPoint = this.calculateMidpoint();
        this.midSp.setPoint(this.midPoint);
    }

    public RealTuple getMidPoint() {
        return this.midSp.getPoint();
    }

    public void setEndPoint(RealTuple point) throws VisADException, RemoteException {
        this.setPoint(1, point);
    }

    public RealTuple getEndPoint() {
        return this.endPoint;
    }

    public void setPoint(int which, RealTuple point) throws VisADException, RemoteException {
        if (which == 0) {
            this.startSp.setPoint(point);
        } else if (which == 1) {
            this.endSp.setPoint(point);
        }
        this.moveEndpoint(which);
    }

    public void setPosition(RealTuple[] position) throws VisADException, RemoteException {
        this.setPosition(position[0], position[1]);
    }

    public RealTuple[] getPosition() throws VisADException, RemoteException {
        return new RealTuple[]{this.getStartPoint(), this.getEndPoint()};
    }

    public void setPosition(RealTuple startPosition, RealTuple endPosition) throws VisADException, RemoteException {
        this.startSp.setPoint(startPosition);
        this.endSp.setPoint(endPosition);
        this.moveEndpoint(2);
    }

    private SelectorPoint makeSelectorPoint(final int which, String name, RealTuple initialPoint) throws VisADException, RemoteException {
        VisADGeometryArray marker;
        if (which == 0) {
            marker = ShapeUtility.makeShape("PLUS");
            marker = ShapeUtility.setSize(marker, 0.03f);
        } else if (which == 1) {
            marker = SelectorPoint.reduce(ShapeUtility.makeShape("CUBE"));
        } else {
            marker = ShapeUtility.makeShape("FILLED_TRIANGLE");
            marker = ShapeUtility.setSize(marker, 0.03f);
        }
        SelectorPoint point = new SelectorPoint(name, marker, initialPoint);
        if (which == 0) {
            point.addConstantMaps(new ConstantMap[]{new ConstantMap(2.0, Display.LineWidth)});
        }
        point.setManipulable(true);
        point.setPointSize(this.getPointSize());
        this.addDisplayable(point);
        point.addAction(new ActionImpl(name + " Point Selector Listener"){

            @Override
            public void doAction() throws VisADException, RemoteException {
                if (CrossSectionSelector.this.amMoving) {
                    return;
                }
                CrossSectionSelector.this.amMoving = true;
                try {
                    if (which == 2) {
                        CrossSectionSelector.this.moveMidpoint();
                    } else {
                        CrossSectionSelector.this.moveEndpoint(which);
                    }
                }
                catch (Exception exc) {
                    System.err.println("Error moving points: " + exc);
                }
                CrossSectionSelector.this.amMoving = false;
            }
        });
        return point;
    }

    private synchronized void moveEndpoint(int which) throws VisADException, RemoteException {
        if (!this.beenInitialized) {
            return;
        }
        if (this.startPoint.equals(this.startSp.getPoint()) && this.endPoint.equals(this.endSp.getPoint())) {
            return;
        }
        boolean wasMoving = this.amMoving;
        this.amMoving = true;
        this.startPoint = this.startSp.getPoint();
        this.endPoint = this.endSp.getPoint();
        this.midPoint = this.calculateMidpoint();
        this.midSp.setPoint(this.midPoint);
        this.positionHasChanged();
        this.firePropertyChange(which == 0 ? PROPERTY_STARTPOINT : PROPERTY_ENDPOINT, null, null);
        this.amMoving = wasMoving;
    }

    private synchronized void moveMidpoint() throws VisADException, RemoteException {
        if (!this.beenInitialized) {
            return;
        }
        if (this.midPoint.equals(this.midSp.getPoint())) {
            return;
        }
        RealTuple delta = (RealTuple)this.midSp.getPoint().subtract(this.midPoint);
        if (delta.equals(this.ZERO2D) || delta.equals(this.ZERO3D)) {
            return;
        }
        this.startPoint = (RealTuple)this.startSp.getPoint().add(delta);
        this.endPoint = (RealTuple)this.endSp.getPoint().add(delta);
        this.midPoint = this.midSp.getPoint();
        boolean wasMoving = this.amMoving;
        this.amMoving = true;
        this.startSp.setPoint(this.startPoint);
        this.endSp.setPoint(this.endPoint);
        this.positionHasChanged();
        this.firePropertyChange(PROPERTY_MIDPOINT, null, null);
        this.amMoving = wasMoving;
    }

    protected void positionHasChanged() throws VisADException, RemoteException {
        this.setLineData();
        this.notifyListenersOfMove();
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new CrossSectionSelector(this);
    }

    public void addStartPropertyChangeListener(PropertyChangeListener action) {
        super.addPropertyChangeListener(PROPERTY_STARTPOINT, action);
    }

    public void removeStartPropertyChangeListener(PropertyChangeListener action) {
        super.removePropertyChangeListener(PROPERTY_STARTPOINT, action);
    }

    public void addEndPropertyChangeListener(PropertyChangeListener action) {
        super.addPropertyChangeListener(PROPERTY_ENDPOINT, action);
    }

    public void removeEndPropertyChangeListener(PropertyChangeListener action) {
        super.removePropertyChangeListener(PROPERTY_ENDPOINT, action);
    }

    public void addMidPropertyChangeListener(PropertyChangeListener action) {
        super.addPropertyChangeListener(PROPERTY_MIDPOINT, action);
    }

    public void removeMidPropertyChangeListener(PropertyChangeListener action) {
        super.removePropertyChangeListener(PROPERTY_MIDPOINT, action);
    }

    public void setInterpolateLinePoints(boolean value) throws VisADException, RemoteException {
        this.interpolateLinePoints = value;
        if (this.line != null) {
            this.setLineData();
        }
    }
}

