/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.visad.display.Displayable;
import ucar.visad.display.PolarLineDrawing;
import visad.CommonUnit;
import visad.Gridded2DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.SampledSet;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;

public class CrossHair
extends PolarLineDrawing {
    public CrossHair(String name, RealTupleType polarType) throws RemoteException, VisADException {
        super(name, polarType);
    }

    protected CrossHair(CrossHair that) throws RemoteException, VisADException {
        super(that);
    }

    public void setHairs(Real maximum) throws VisADException, RemoteException {
        SampledSet[] hairs = new SampledSet[2];
        float[][] samples = new float[2][];
        float max = (float)maximum.getValue(this.getRangeType().getDefaultUnit());
        samples[this.getRangeIndex()] = new float[]{-max, max};
        float[] bearings = new float[2];
        Unit bearingUnit = this.getBearingType().getDefaultUnit();
        samples[this.getBearingIndex()] = bearings;
        Arrays.fill(bearings, (float)bearingUnit.toThis(0.0, CommonUnit.degree));
        hairs[0] = new Gridded2DSet((MathType)this.getPolarType(), (float[][])samples, bearings.length);
        Arrays.fill(bearings, (float)bearingUnit.toThis(90.0, CommonUnit.degree));
        hairs[1] = new Gridded2DSet((MathType)this.getPolarType(), (float[][])samples, bearings.length);
        this.setData(new UnionSet((MathType)this.getPolarType(), hairs));
    }

    public void setHairs(CrossHair crossHair) throws VisADException, RemoteException {
        this.setData(crossHair.getData());
    }

    @Override
    public boolean equals(Object obj) {
        CrossHair that;
        boolean equals = !(obj instanceof CrossHair) ? false : (that = (CrossHair)obj) == this || super.equals(that);
        return equals;
    }

    public void addScalarMaps(LocalDisplay display) {
    }

    @Override
    public synchronized Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new CrossHair(this);
    }
}

