/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.unidata.util.ContourInfo;
import ucar.visad.display.ContourLevels;
import ucar.visad.display.IrregularContourLevels;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.RegularContourLevels;
import ucar.visad.display.ScalarMapSet;
import visad.BadMappingException;
import visad.ContourControl;
import visad.Display;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Unit;
import visad.VisADException;

public abstract class ContourLines
extends LineDrawing {
    public static final String CONTOUR_LEVELS = "contourLevels";
    public static final String LABELING = "labeling";
    public static final String CONTOUR_REAL_TYPE = "contourRealType";
    public static final String COLOR_FILL = "colorFill";
    private volatile ContourLevels contourLevels;
    private volatile boolean labeling = false;
    private volatile ScalarMap contourMap;
    private volatile ContourControl contourControl;
    private volatile RealType contourRealType;
    private volatile float rangeMinimum = Float.NaN;
    private volatile float rangeMaximum = Float.NaN;
    private volatile boolean colorFill = false;
    private volatile int dashedStyle = 1;
    private static final double DEFAULT_SIZE = 12.0;
    private volatile double labelFactor = 1.0;
    private volatile int labelFreq = 1;
    private volatile int labelSkip = 2;
    private volatile Object labelFont = null;
    private boolean alignLabels = true;
    private static ContourLevels defaultContourLevels = new IrregularContourLevels(new float[0]);

    public ContourLines(String name, RealType contourRealType) throws VisADException, RemoteException {
        super(name);
        this.contourLevels = defaultContourLevels;
        this.contourRealType = contourRealType;
        if (contourRealType != null) {
            this.setContourMap();
        }
    }

    public ContourLines(ContourLines that) throws VisADException, RemoteException {
        super(that);
        this.contourLevels = that.contourLevels;
        this.labeling = that.labeling;
        this.contourRealType = that.contourRealType;
        this.rangeMinimum = that.rangeMinimum;
        this.rangeMaximum = that.rangeMaximum;
        if (this.contourRealType != null) {
            this.setContourMap();
        }
    }

    protected void setContourRealType(RealType realType) throws RemoteException, VisADException {
        if (!realType.equals(this.contourRealType)) {
            RealType oldValue = this.contourRealType;
            this.contourRealType = realType;
            this.setContourMap();
            this.firePropertyChange(CONTOUR_REAL_TYPE, oldValue, this.contourRealType);
        }
    }

    public RealType getContourRealType() {
        return this.contourRealType;
    }

    protected void setRange(float min, float max) throws RemoteException, VisADException {
        this.rangeMinimum = min;
        this.rangeMaximum = max;
        if (this.contourControl != null) {
            this.setContourLevels();
        }
    }

    public final void setContourLevels(ContourLevels contourLevels) throws RemoteException, VisADException {
        if (!contourLevels.equals(this.contourLevels)) {
            ContourLevels oldValue = this.contourLevels;
            this.contourLevels = contourLevels;
            if (this.contourControl != null) {
                this.setContourLevels();
            }
            this.firePropertyChange(CONTOUR_LEVELS, oldValue, this.contourLevels);
        }
    }

    public final void setContourInterval(float inter, float base, float min, float max) throws RemoteException, VisADException {
        this.setContourInterval(inter, base, min, max, false);
    }

    public final void setContourInterval(float inter, float base, float min, float max, boolean dash) throws RemoteException, VisADException {
        this.setContourLevels(new RegularContourLevels(inter, base, min, max, dash));
    }

    protected void setScalarMaps(ScalarMapSet maps) throws BadMappingException {
        if (this.contourMap == null) {
            throw new BadMappingException(this.getClass().getName() + ".setScalarMaps(ScalarMapSet): " + "Contour parameter not yet set");
        }
        maps.add(this.contourMap);
        super.setScalarMapSet(maps);
    }

    public final ContourLevels getContourLevels() {
        return this.contourLevels;
    }

    public final float[] getContourValues() throws VisADException {
        return this.contourLevels.getLevels(this.rangeMinimum, this.rangeMaximum);
    }

    @Override
    public void setContourInfo(ContourInfo contourInfo) throws VisADException, RemoteException {
        if (contourInfo == null) {
            return;
        }
        this.setActive(false);
        this.setContourLevels(new IrregularContourLevels(contourInfo.getContourLevels(), contourInfo.getBase(), contourInfo.getDashOn()));
        this.setLabeling(contourInfo.getIsLabeled());
        this.setLabelFreq(contourInfo.getLabelFreq());
        this.setLabelSkip(contourInfo.getLabelLineSkip());
        this.setLineWidth(contourInfo.getLineWidth());
        this.setDashedStyle(contourInfo.getDashedStyle());
        this.setFont(contourInfo.getFont(), contourInfo.getLabelSize(), contourInfo.getAlignLabels());
        this.setActive(true);
    }

    public void setColorFill(boolean yesorno) throws VisADException, RemoteException {
        if (yesorno != this.colorFill) {
            Boolean oldValue = new Boolean(this.colorFill);
            this.colorFill = yesorno;
            if (this.contourControl != null) {
                this.contourControl.setContourFill(this.colorFill);
            }
            this.firePropertyChange(LABELING, oldValue, new Boolean(this.colorFill));
        }
    }

    public boolean getColorFillEnabled() {
        return this.colorFill;
    }

    public final void setLabeling(boolean on) throws VisADException, RemoteException {
        if (on != this.labeling) {
            Boolean oldValue = new Boolean(this.labeling);
            this.labeling = on;
            if (this.contourControl != null) {
                this.contourControl.enableLabels(this.labeling);
            }
            this.firePropertyChange(LABELING, oldValue, new Boolean(this.labeling));
        }
    }

    public final boolean isLabeling() {
        return this.labeling;
    }

    @Override
    public void setDisplayUnit(Unit unit) throws VisADException, RemoteException {
        this.checkUnit(this.contourRealType, unit);
        super.setDisplayUnit(unit);
        this.applyDisplayUnit(this.contourMap, this.contourRealType);
    }

    private void setContourLevels() throws VisADException, RemoteException {
        if (this.contourLevels != defaultContourLevels) {
            if (this.rangeMinimum != this.rangeMinimum || this.rangeMaximum != this.rangeMaximum) {
                this.contourLevels.setControl(this.contourControl);
            } else {
                this.contourLevels.setControl(this.contourControl, this.rangeMinimum, this.rangeMaximum);
            }
        }
    }

    public void setLabelFreq(int freq) throws RemoteException, VisADException {
        if (freq != this.labelFreq) {
            this.labelFreq = freq;
            if (this.contourControl != null) {
                this.contourControl.setLabelFreq(this.labelFreq);
            }
        }
    }

    public void setLabelSkip(int skip) throws RemoteException, VisADException {
        if (skip != this.labelSkip) {
            this.labelSkip = skip;
            if (this.contourControl != null) {
                this.contourControl.setEveryNth(this.labelSkip);
            }
        }
    }

    public void setDashedStyle(int style) throws RemoteException, VisADException {
        if (style != this.dashedStyle) {
            this.dashedStyle = style;
            if (this.contourControl != null) {
                this.contourControl.setDashedStyle(this.dashedStyle);
            }
        }
    }

    public void setFont(Object font, int size, boolean align) throws RemoteException, VisADException {
        double factor = (double)size / 12.0;
        if (font != this.labelFont || factor != this.labelFactor || align != this.alignLabels) {
            this.labelFont = font;
            this.labelFactor = factor;
            this.alignLabels = align;
            if (this.contourControl != null) {
                this.contourControl.setLabelFont(font);
                this.contourControl.setLabelSize(factor);
                this.contourControl.setAlignLabels(align);
            }
        }
    }

    public int getDashedStyle() {
        return this.dashedStyle;
    }

    private void setContourMap() throws RemoteException, VisADException {
        ScalarMap oldContourMap = this.contourMap;
        this.contourMap = new ScalarMap(this.contourRealType, Display.IsoContour);
        this.contourMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                int id = event.getId();
                if (id == 3 || id == 5) {
                    ContourLines.this.contourControl = (ContourControl)ContourLines.this.contourMap.getControl();
                    if (ContourLines.this.contourControl != null) {
                        ContourLines.this.setContourLevels();
                        ContourLines.this.contourControl.enableLabels(ContourLines.this.labeling);
                        ContourLines.this.contourControl.setContourFill(ContourLines.this.colorFill);
                        ContourLines.this.contourControl.setDashedStyle(ContourLines.this.dashedStyle);
                        ContourLines.this.contourControl.setLabelFont(ContourLines.this.labelFont);
                        ContourLines.this.contourControl.setLabelSize(ContourLines.this.labelFactor);
                        ContourLines.this.contourControl.setLabelFreq(ContourLines.this.labelFreq);
                        ContourLines.this.contourControl.setEveryNth(ContourLines.this.labelSkip);
                        ContourLines.this.contourControl.setAlignLabels(ContourLines.this.alignLabels);
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) {
            }
        });
        this.applyDisplayUnit(this.contourMap, this.contourRealType);
        this.replaceScalarMap(oldContourMap, this.contourMap);
        this.fireScalarMapSetChange();
    }
}

