/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.visad.display.ContourLines;
import ucar.visad.display.Displayable;
import ucar.visad.display.GridDisplayable;
import visad.BaseColorControl;
import visad.Display;
import visad.Field;
import visad.FieldImpl;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Unit;
import visad.VisADException;

public class Contour2DDisplayable
extends ContourLines
implements GridDisplayable {
    public static final String RGB_REAL_TYPE = "rgbRealType";
    private Field field;
    private RealType rgbRealType;
    private float[][] colorPalette = null;
    private volatile ScalarMap colorMap;
    private volatile BaseColorControl colorControl;
    private double lowRange = Double.NaN;
    private double highRange = Double.NaN;
    private boolean alphaFlag = false;
    private boolean coloredByAnother = false;

    public Contour2DDisplayable(String name) throws VisADException, RemoteException {
        this(name, false);
    }

    public Contour2DDisplayable(String name, boolean alphaFlag) throws VisADException, RemoteException {
        this(name, null, (float[][])null, alphaFlag);
    }

    public Contour2DDisplayable(String name, boolean alphaFlag, boolean colorFill) throws VisADException, RemoteException {
        this(name, null, (float[][])null, alphaFlag);
        if (colorFill) {
            this.setColorFill(true);
        }
    }

    public Contour2DDisplayable(String name, RealType c2dRealType, float[][] colorPalette, float[] rangeLimits) throws VisADException, RemoteException {
        this(name, c2dRealType, colorPalette);
        this.colorPalette = colorPalette;
        if (c2dRealType != null) {
            this.setContourRealType(c2dRealType);
            this.setRGBRealType(c2dRealType);
        }
    }

    public Contour2DDisplayable(String name, RealType c2dRealType, float[][] colorPalette) throws VisADException, RemoteException {
        this(name, c2dRealType, colorPalette, false);
    }

    public Contour2DDisplayable(String name, RealType c2dRealType, float[][] colorPalette, boolean alphaFlag) throws VisADException, RemoteException {
        super(name, null);
        this.alphaFlag = alphaFlag;
        this.colorPalette = colorPalette;
        if (c2dRealType != null) {
            this.setContourRealType(c2dRealType);
            this.setRGBRealType(c2dRealType);
        }
    }

    protected Contour2DDisplayable(Contour2DDisplayable that) throws VisADException, RemoteException {
        super(that);
        this.colorPalette = that.colorPalette;
        this.field = that.field;
        if (that.getContourRealType() != null) {
            this.setContourRealType(that.getContourRealType());
        }
        if (that.rgbRealType != null) {
            this.setRGBRealType(that.getRGBRealType());
        }
    }

    protected boolean useDisplayUnitForColor() {
        return !this.coloredByAnother;
    }

    public void setC2DRealType(RealType realType) throws RemoteException, VisADException {
        this.setContourRealType(realType);
        this.setRGBRealType(realType);
        this.fireScalarMapSetChange();
    }

    public void setColorPalette() throws RemoteException, VisADException {
        if (this.colorControl != null) {
            this.colorControl.initVis5D();
            this.colorPalette = this.colorControl.getTable();
        }
    }

    @Override
    public void setColor(Color color) throws RemoteException, VisADException {
        this.colorPalette = new float[][]{{(float)color.getRed() / 255.0f}, {(float)color.getGreen() / 255.0f}, {(float)color.getBlue() / 255.0f}};
        if (this.colorControl != null) {
            this.colorControl.setTable(this.colorPalette);
        }
    }

    @Override
    public void setColorPalette(float[][] colorPalette) throws RemoteException, VisADException {
        if (this.colorControl != null) {
            this.colorControl.setTable(colorPalette);
        }
        this.colorPalette = colorPalette;
    }

    @Override
    public void setRangeForColor(double low, double high) throws VisADException, RemoteException {
        this.lowRange = low;
        this.highRange = high;
        if (this.colorMap != null && this.hasRange()) {
            this.colorMap.setRange(low, high);
        }
    }

    public double[] getRangeforColor() {
        return this.getRangeForColor();
    }

    public double[] getRangeForColor() {
        return new double[]{this.lowRange, this.highRange};
    }

    public float[][] getColorPalette() {
        return this.colorPalette;
    }

    public void setGrid2D(FieldImpl field) throws RemoteException, VisADException {
        this.loadData(field);
    }

    @Override
    public void loadData(FieldImpl field) throws VisADException, RemoteException {
        RealType[] realTypes = GridUtil.getParamType(field).getRealComponents();
        RealType contourType = realTypes[0];
        this.setContourRealType(contourType);
        RealType rgbType = contourType;
        if (this.coloredByAnother) {
            if (realTypes.length > 1) {
                rgbType = realTypes[1];
            } else if (GridUtil.hasEnsemble(field)) {
                rgbType = GridUtil.ENSEMBLE_TYPE;
            }
        }
        this.setRGBRealType(rgbType);
        super.setData(field);
    }

    protected void setRGBRealType(RealType realType) throws RemoteException, VisADException {
        if (!realType.equals(this.rgbRealType)) {
            RealType oldValue = this.rgbRealType;
            this.rgbRealType = realType;
            if (this.useDisplayUnitForColor()) {
                if (!this.isUnitCompatible(this.rgbRealType, this.getDisplayUnit())) {
                    this.setDisplayUnit(null);
                }
            } else if (!this.isUnitCompatible(this.rgbRealType, this.getColorUnit())) {
                this.setColorUnit(null);
            }
            this.setColorMaps();
            this.firePropertyChange(RGB_REAL_TYPE, oldValue, this.rgbRealType);
        }
    }

    @Override
    public void setColorFill(boolean yesorno) throws VisADException, RemoteException {
        if (this.getContourRealType() != null) {
            this.setRGBRealType(this.getContourRealType());
        }
        super.setColorFill(yesorno);
    }

    public RealType getRGBRealType() {
        return this.rgbRealType;
    }

    public void setContourLevels(float interval, float base, float min, float max) throws VisADException, RemoteException {
        this.setContourLevels(interval, base, min, max, false);
    }

    public void setContourLevels(float interval, float base, float min, float max, boolean dash) throws VisADException, RemoteException {
        this.setRange(min, max);
        super.setContourInterval(interval, base, min, max, dash);
    }

    public boolean hasRange() {
        return !Double.isNaN(this.lowRange) && !Double.isNaN(this.highRange);
    }

    @Override
    public void setDisplayUnit(Unit unit) throws VisADException, RemoteException {
        super.setDisplayUnit(unit);
        if (this.useDisplayUnitForColor()) {
            this.checkUnit(this.rgbRealType, unit);
            this.applyUnit(this.colorMap, this.rgbRealType);
        }
    }

    @Override
    public void setColorUnit(Unit unit) throws VisADException, RemoteException {
        if (!this.useDisplayUnitForColor()) {
            this.checkUnit(this.rgbRealType, unit);
        }
        super.setColorUnit(unit);
        if (!this.useDisplayUnitForColor()) {
            this.applyUnit(this.colorMap, this.rgbRealType);
        }
    }

    private void applyUnit(ScalarMap colorMap, RealType rgbRealType) throws VisADException, RemoteException {
        if (this.useDisplayUnitForColor()) {
            this.applyDisplayUnit(colorMap, rgbRealType);
        } else {
            this.applyColorUnit(colorMap, rgbRealType);
        }
    }

    private void setColorMaps() throws RemoteException, VisADException {
        ScalarMap oldColorMap = this.colorMap;
        this.colorMap = !this.alphaFlag ? new ScalarMap(this.rgbRealType, Display.RGB) : new ScalarMap(this.rgbRealType, Display.RGBA);
        if (this.hasRange()) {
            this.colorMap.setRange(this.lowRange, this.highRange);
        }
        this.colorMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                int id = event.getId();
                if (id == 3 || id == 5) {
                    Contour2DDisplayable.this.colorControl = (BaseColorControl)Contour2DDisplayable.this.colorMap.getControl();
                    if (Contour2DDisplayable.this.colorControl != null) {
                        if (Contour2DDisplayable.this.colorPalette != null) {
                            Contour2DDisplayable.this.colorControl.setTable(Contour2DDisplayable.this.colorPalette);
                        } else {
                            Contour2DDisplayable.access$202(Contour2DDisplayable.this, Contour2DDisplayable.this.colorControl.getTable());
                        }
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
                if (event.getId() == 1 && Contour2DDisplayable.this.hasRange()) {
                    Contour2DDisplayable.this.colorMap.setRange(Contour2DDisplayable.this.lowRange, Contour2DDisplayable.this.highRange);
                }
            }
        });
        this.applyDisplayUnit(this.colorMap, this.rgbRealType);
        this.replaceScalarMap(oldColorMap, this.colorMap);
        this.fireScalarMapSetChange();
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new Contour2DDisplayable(this);
    }

    @Override
    public void setColoredByAnother(boolean yesno) {
        this.coloredByAnother = yesno;
    }

    static /* synthetic */ float[][] access$202(Contour2DDisplayable x0, float[][] x1) {
        x0.colorPalette = x1;
        return x1;
    }
}

