/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.util.Comparator;
import java.util.TreeMap;
import visad.ConstantMap;
import visad.DisplayRealType;

public class ConstantMapSet {
    private TreeMap maps;

    public synchronized ConstantMap put(ConstantMap map) {
        if (this.maps == null) {
            this.maps = new TreeMap(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((DisplayRealType)o1).getName().compareTo(((DisplayRealType)o2).getName());
                }

                public boolean equals(Object o1, Object o2) {
                    return this.compare(o1, o2) == 0;
                }
            });
        }
        return this.maps.put(map.getDisplayScalar(), map);
    }

    public synchronized ConstantMap remove(DisplayRealType type) {
        return this.maps == null ? (ConstantMap)null : (ConstantMap)this.maps.remove(type);
    }

    public synchronized void removeAll() {
        this.maps.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantMapSet combine(ConstantMapSet set1, ConstantMapSet set2) {
        ConstantMapSet set = new ConstantMapSet();
        ConstantMapSet constantMapSet = set1;
        synchronized (constantMapSet) {
            ConstantMapSet constantMapSet2 = set2;
            synchronized (constantMapSet2) {
                if (set1.size() > 0 || set2.size() > 0) {
                    set.maps = new TreeMap();
                }
                if (set1.size() > 0) {
                    set.maps.putAll(set1.maps);
                }
                if (set2.size() > 0) {
                    set.maps.putAll(set2.maps);
                }
            }
        }
        return set;
    }

    public int size() {
        return this.maps == null ? 0 : this.maps.size();
    }

    public synchronized ConstantMap[] getConstantMaps() {
        ConstantMap[] mapArray = new ConstantMap[this.size()];
        if (mapArray.length > 0) {
            this.maps.values().toArray(mapArray);
        }
        for (int i = 0; i < mapArray.length; ++i) {
            mapArray[i] = (ConstantMap)mapArray[i].clone();
        }
        return mapArray;
    }

    public Object clone() {
        ConstantMapSet clone = new ConstantMapSet();
        return ConstantMapSet.combine(clone, this);
    }

    public String toString() {
        return this.maps == null ? "No constant maps" : this.maps.toString();
    }
}

