/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import ucar.visad.display.ConstantMapSet;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.ScalarMapSet;
import visad.ConstantMap;
import visad.DisplayRealType;
import visad.LocalDisplay;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.Unit;
import visad.VisADException;

public class CompositeDisplayable
extends Displayable {
    private Object MUTEX = new Object();
    private List displayables = new ArrayList();
    private ConstantMapSet constantMaps = new ConstantMapSet();
    private volatile List listDataListeners;
    public String label = "LABEL";
    public static int cnt = 0;
    int mycnt = cnt++;

    public CompositeDisplayable() throws RemoteException, VisADException {
        this((LocalDisplay)null);
    }

    public CompositeDisplayable(String lbl) throws RemoteException, VisADException {
        this((LocalDisplay)null);
        this.label = lbl;
    }

    public CompositeDisplayable(LocalDisplay display) throws RemoteException, VisADException {
        super(display);
    }

    protected CompositeDisplayable(CompositeDisplayable that) throws VisADException, RemoteException {
        super(that);
        Iterator iter = that.iterator();
        while (iter.hasNext()) {
            this.addDisplayable(((Displayable)iter.next()).cloneForDisplay());
        }
        this.constantMaps = (ConstantMapSet)that.constantMaps.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ListDataListener listener) {
        if (this.listDataListeners == null) {
            CompositeDisplayable compositeDisplayable = this;
            synchronized (compositeDisplayable) {
                if (this.listDataListeners == null) {
                    this.listDataListeners = Collections.synchronizedList(new ArrayList());
                }
            }
        }
        this.listDataListeners.add(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.listDataListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisplayable(Displayable displayable) throws RemoteException, VisADException {
        Object object = this.MUTEX;
        synchronized (object) {
            this.setDisplayable(this.displayableCount(), displayable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayable(int index, Displayable displayable) throws RemoteException, VisADException {
        Object object = this.MUTEX;
        synchronized (object) {
            if (index < this.displayables.size()) {
                this.removeDisplayable(index);
            }
            displayable.setParent(this);
            ConstantMap[] maps = this.constantMaps.getConstantMaps();
            for (int i = 0; i < maps.length; ++i) {
                displayable.addConstantMap(maps[i]);
            }
            this.addScalarMaps(displayable.getScalarMapSet());
            displayable.addPropertyChangeListener("scalarMapSet", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    try {
                        ScalarMapSet maps = (ScalarMapSet)event.getNewValue();
                        if (maps != null && maps.size() > 0) {
                            Iterator iter = maps.iterator();
                            while (iter.hasNext()) {
                                CompositeDisplayable.this.addScalarMap((ScalarMap)iter.next());
                            }
                        }
                    }
                    catch (Exception exc) {
                        System.err.println("Error adding maps:" + exc);
                        exc.printStackTrace();
                    }
                    PropertyChangeEvent newEvent = new PropertyChangeEvent(CompositeDisplayable.this, "scalarMapSet", event.getOldValue(), event.getNewValue());
                    newEvent.setPropagationId(event.getPropagationId());
                    CompositeDisplayable.this.firePropertyChange(newEvent);
                }
            });
            if (this.getDisplay() != null) {
                displayable.setDisplay(this.getDisplay());
            }
            if (this.addRefsInvoked()) {
                displayable.addDataReferences();
            }
            this.displayables.add(index, displayable);
        }
        this.fireListDataIntervalAdded(index, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Displayable getDisplayable(int index) throws IndexOutOfBoundsException {
        Object object = this.MUTEX;
        synchronized (object) {
            List<Displayable> displayables = this.getDisplayables();
            if (index < 0 || index >= displayables.size()) {
                return null;
            }
            return displayables.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDisplayable(Displayable displayable) throws VisADException, RemoteException {
        boolean existed;
        if (displayable == null) {
            return false;
        }
        Object object = this.MUTEX;
        synchronized (object) {
            displayable.setParent(null);
            int index = this.displayables.indexOf(displayable);
            if (index < 0) {
                existed = false;
            } else {
                this.removeDisplayable(index);
                existed = true;
            }
        }
        return existed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroy() throws RemoteException, VisADException {
        Object object = this.MUTEX;
        synchronized (object) {
            if (this.displayables != null) {
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    ((Displayable)iter.next()).destroy();
                }
                this.displayables = null;
            }
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Displayable removeDisplayable(int index) throws RemoteException, VisADException {
        Displayable displayable;
        Object object = this.MUTEX;
        synchronized (object) {
            displayable = (Displayable)this.displayables.remove(index);
            displayable.removeDataReferences();
            ScalarMapSet newSet = new ScalarMapSet();
            for (int i = 0; i < this.displayables.size(); ++i) {
                ScalarMapSet mapSet = ((Displayable)this.displayables.get(i)).getScalarMapSet();
                if (mapSet == null || mapSet.size() <= 0) continue;
                newSet.add(mapSet);
            }
            this.setScalarMapSet(newSet);
        }
        this.fireListDataIntervalRemoved(index, index);
        return displayable;
    }

    public Iterator iterator() {
        if (this.displayables == null) {
            return new ArrayList().iterator();
        }
        return new ArrayList(this.displayables).iterator();
    }

    @Override
    public void setDisplay(LocalDisplay display) throws RemoteException, VisADException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((Displayable)iter.next()).setDisplay(display);
        }
        super.setDisplay(display);
    }

    @Override
    protected void setDisplayMaster(DisplayMaster master) throws VisADException, RemoteException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((Displayable)iter.next()).setDisplayMaster(master);
        }
        super.setDisplayMaster(master);
    }

    @Override
    protected final void myAddDataReferences() throws VisADException, RemoteException {
        if (!this.isActive()) {
            return;
        }
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((Displayable)iter.next()).addDataReferences();
        }
    }

    @Override
    protected final void myRemoveDataReferences() throws VisADException, RemoteException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((Displayable)iter.next()).removeDataReferences();
        }
    }

    @Override
    public ConstantMap addConstantMap(ConstantMap map) throws VisADException, RemoteException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((Displayable)iter.next()).addConstantMap((ConstantMap)map.clone());
        }
        this.constantMaps.put(map);
        return map;
    }

    public void debug() {
        System.err.println(this.label + " composite size=" + this.displayables.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible) throws RemoteException, VisADException {
        super.setVisible(visible);
        Object object = this.MUTEX;
        synchronized (object) {
            for (Displayable displayable : this.getDisplayables()) {
                if (displayable == null) continue;
                displayable.setVisible(visible);
            }
        }
    }

    @Override
    public void setManipulable(boolean manipulable) throws VisADException, RemoteException {
        super.setManipulable(manipulable);
        for (Displayable displayable : this.getDisplayables()) {
            if (displayable == null) continue;
            displayable.setManipulable(manipulable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible, int lowerIndex, int upperIndex) throws RemoteException, VisADException {
        Object object = this.MUTEX;
        synchronized (object) {
            for (int index = lowerIndex; index <= upperIndex; ++index) {
                Displayable displayable = this.getDisplayable(index);
                if (displayable == null) continue;
                displayable.setVisible(visible);
            }
        }
    }

    @Override
    public void setUseFastRendering(boolean fastRender) throws VisADException, RemoteException {
        super.setUseFastRendering(fastRender);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setUseFastRendering(fastRender);
        }
    }

    @Override
    public void setPointMode(boolean usePoints) throws VisADException, RemoteException {
        super.setPointMode(usePoints);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setPointMode(usePoints);
        }
    }

    @Override
    public void setConstantPosition(double value, DisplayRealType type) throws VisADException, RemoteException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setConstantPosition(value, type);
        }
    }

    @Override
    public void toFront() throws RemoteException, VisADException {
        super.toFront();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.toFront();
        }
    }

    @Override
    public void setColor(Color c) throws RemoteException, VisADException {
        this.setDisplayInactive();
        super.setColor(c);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setColor(c);
        }
        this.setDisplayActive();
    }

    @Override
    public void setUseTimesInAnimation(boolean value) throws RemoteException, VisADException {
        this.setDisplayInactive();
        super.setUseTimesInAnimation(value);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setUseTimesInAnimation(value);
        }
        this.setDisplayActive();
    }

    @Override
    public void setAdjustFlow(boolean adjust) throws RemoteException, VisADException {
        this.setDisplayInactive();
        super.setAdjustFlow(adjust);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setAdjustFlow(adjust);
        }
        this.setDisplayActive();
    }

    @Override
    public void setDisplayUnit(Unit unit) throws RemoteException, VisADException {
        this.setDisplayInactive();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setDisplayUnit(unit);
        }
        this.setDisplayActive();
    }

    @Override
    public void setSelectedRange(double low, double hi) throws RemoteException, VisADException {
        this.setDisplayInactive();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setSelectedRange(low, hi);
        }
        this.setDisplayActive();
    }

    @Override
    public void setColorUnit(Unit unit) throws RemoteException, VisADException {
        super.setColorUnit(unit);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setColorUnit(unit);
        }
    }

    @Override
    public void setPointSize(float size) throws RemoteException, VisADException {
        super.setPointSize(size);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setPointSize(size);
        }
    }

    @Override
    public void setLineWidth(float width) throws RemoteException, VisADException {
        super.setLineWidth(width);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setLineWidth(width);
        }
    }

    @Override
    public void setColorPalette(float[][] c) throws RemoteException, VisADException {
        super.setColorPalette(c);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Displayable displayable = (Displayable)iter.next();
            displayable.setColorPalette(c);
        }
    }

    public void setVisible(boolean visible, int index) throws RemoteException, VisADException {
        this.setVisible(visible, index, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDisplayables() throws RemoteException, VisADException {
        for (int i = 0; i < this.displayables.size(); ++i) {
            this.removeDisplayable((Displayable)this.displayables.get(i));
        }
        Object object = this.MUTEX;
        synchronized (object) {
            this.displayables.clear();
        }
    }

    public void destroyAll() throws RemoteException, VisADException {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Displayable lastDisplayable() {
        Object object = this.MUTEX;
        synchronized (object) {
            int count = this.displayableCount();
            return count == 0 ? null : (Displayable)this.displayables.get(count - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int displayableCount() {
        Object object = this.MUTEX;
        synchronized (object) {
            return this.displayables.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Displayable displayable) {
        Object object = this.MUTEX;
        synchronized (object) {
            return this.displayables.indexOf(displayable);
        }
    }

    @Override
    public Set getAnimationSet(RealType aniType, boolean force) throws RemoteException, VisADException {
        Set aniSet = null;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Set set;
            Displayable displayable = (Displayable)iter.next();
            if (displayable == null || !force && !displayable.getUseTimesInAnimation() || (set = displayable.getAnimationSet(aniType, force)) == null) continue;
            aniSet = aniSet == null ? set : aniSet.merge1DSets(set);
        }
        return aniSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Displayable> getDisplayables() {
        Object object = this.MUTEX;
        synchronized (object) {
            return new ArrayList<Displayable>(this.displayables);
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new CompositeDisplayable(this);
    }

    protected void fireListDataContentsChanged(int index0, int index1) {
        if (this.listDataListeners != null) {
            ListDataEvent event = new ListDataEvent(this, 0, index0, index1);
            ListDataListener[] listeners = this.listDataListeners.toArray(new ListDataListener[0]);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].contentsChanged(event);
            }
        }
    }

    protected void fireListDataIntervalAdded(int index0, int index1) {
        if (this.listDataListeners != null) {
            ListDataEvent event = new ListDataEvent(this, 1, index0, index1);
            ListDataListener[] listeners = this.listDataListeners.toArray(new ListDataListener[0]);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].intervalAdded(event);
            }
        }
    }

    protected void fireListDataIntervalRemoved(int index0, int index1) {
        if (this.listDataListeners != null) {
            ListDataEvent event = new ListDataEvent(this, 2, index0, index1);
            ListDataListener[] listeners = this.listDataListeners.toArray(new ListDataListener[0]);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].intervalRemoved(event);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CompositeDisplayable:");
        sb.append("\n");
        int i = 1;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            sb.append("Displayable ");
            sb.append(Integer.toString(i));
            sb.append(":");
            sb.append("\n");
            sb.append(((Displayable)iter.next()).toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

