/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.StringUtil;
import ucar.visad.display.ColorScale;
import visad.Unit;

public class ColorScaleInfo {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 0;
    public static final String TOP = "Top";
    public static final String BOTTOM = "Bottom";
    public static final String LEFT = "Left";
    public static final String RIGHT = "Right";
    private String name;
    private int orient = 1;
    private String placement = "Top";
    private float x;
    private float y;
    private Color labelColor = null;
    private float[][] colorPalette = null;
    private Font labelFont = null;
    private int labelSide = 0;
    private static Color defaultColor = Color.lightGray;
    private boolean isVisible = false;
    private boolean labelVisible = true;
    private boolean useAlpha = false;
    private boolean dirty = true;
    private Unit unit;
    private boolean unitVisible;

    public ColorScaleInfo() {
        this("ColorScaleInfo");
    }

    public ColorScaleInfo(String name) {
        this.name = name;
    }

    public ColorScaleInfo(String name, int orient) {
        this(name, orient, ColorScaleInfo.getDefaultPlace(orient));
    }

    public ColorScaleInfo(String name, int orient, String placement) {
        this(name, orient, placement, null, null);
    }

    public ColorScaleInfo(String name, int orient, float[][] palette) {
        this(name, orient, ColorScaleInfo.getX(orient, ColorScaleInfo.getDefaultPlace(orient)), ColorScaleInfo.getY(orient, ColorScaleInfo.getDefaultPlace(orient)), null, palette);
    }

    public ColorScaleInfo(String name, int orient, float x, float y, Font labelFont, float[][] colorPalette) {
        this(name, orient, x, y, labelFont, colorPalette, null);
    }

    public ColorScaleInfo(String name, int orient, String placement, Font labelFont, float[][] colorPalette) {
        this(name, orient, ColorScaleInfo.getX(orient, placement), ColorScaleInfo.getY(orient, placement), labelFont, colorPalette, null);
    }

    public ColorScaleInfo(String name, int orient, float x, float y, Font labelFont, float[][] colorPalette, Color labelColor) {
        this(name, orient, x, y, labelFont, colorPalette, labelColor, false);
    }

    public ColorScaleInfo(String name, int orient, float x, float y, Font labelFont, float[][] colorPalette, Color labelColor, boolean useAlpha) {
        this.name = name;
        this.orient = orient;
        this.x = x;
        this.y = y;
        this.labelFont = labelFont;
        this.colorPalette = colorPalette;
        this.labelColor = labelColor;
        this.useAlpha = useAlpha;
    }

    public ColorScaleInfo(ColorScaleInfo that) {
        that.checkState();
        this.name = that.name;
        this.orient = that.orient;
        this.placement = that.placement;
        this.x = that.x;
        this.y = that.y;
        this.labelFont = that.labelFont;
        this.colorPalette = that.colorPalette;
        this.labelColor = that.labelColor;
        this.labelSide = that.labelSide;
        this.isVisible = that.isVisible;
        this.labelVisible = that.labelVisible;
        this.useAlpha = that.useAlpha;
        this.unit = that.unit;
        this.unitVisible = that.unitVisible;
    }

    public ColorScaleInfo(String params, boolean isParamString) {
        this.dirty = true;
        List<String> toks = StringUtil.split(params, ";", true, true);
        for (String pair : toks) {
            List<String> subToks = StringUtil.split(pair, "=");
            if (subToks.size() != 2) {
                throw new IllegalArgumentException("Bad color scale info info format: " + params);
            }
            String name = subToks.get(0).toString().trim();
            String value = subToks.get(1).toString().trim();
            if (name.equals("visible")) {
                this.isVisible = new Boolean(value);
                continue;
            }
            if (name.equals("labelvisible")) {
                this.labelVisible = new Boolean(value);
                continue;
            }
            if (name.equals("name")) {
                this.name = name;
                continue;
            }
            if (name.equals("color")) {
                this.labelColor = GuiUtils.decodeColor(value, this.labelColor);
                continue;
            }
            if (name.equals("orientation")) {
                if (value.equals("horizontal")) {
                    this.orient = 1;
                    continue;
                }
                if (value.equals("vertical")) {
                    this.orient = 0;
                    continue;
                }
                throw new IllegalArgumentException("Unknown orientation:" + value);
            }
            if (name.equals("placement")) {
                if (value.equals("top")) {
                    this.placement = TOP;
                    continue;
                }
                if (value.equals("bottom")) {
                    this.placement = BOTTOM;
                    continue;
                }
                if (value.equals("left")) {
                    this.placement = LEFT;
                    continue;
                }
                if (value.equals("right")) {
                    this.placement = RIGHT;
                    continue;
                }
                throw new IllegalArgumentException("Unknown placement:" + value);
            }
            throw new IllegalArgumentException("Unknown ColorScaleInfo:" + name);
        }
    }

    public static String getParamStringFormat() {
        return "visible=true|false;color=somecolor;orientation=horizontal|vertical;placement=top|left|bottom|right;labelvisible=true";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOrientation(int orient) {
        this.dirty = true;
        this.orient = orient;
    }

    public int getOrientation() {
        this.checkState();
        return this.orient;
    }

    public void setPlacement(String place) {
        this.placement = place;
        this.dirty = true;
    }

    private void checkState() {
        if (this.dirty) {
            this.orient = ColorScale.getDefaultOrient(this.placement);
            this.x = ColorScaleInfo.getX(this.orient, this.placement);
            this.y = ColorScaleInfo.getY(this.orient, this.placement);
            this.labelSide = this.placement.equals(RIGHT) || this.placement.equals(BOTTOM) ? 1 : 0;
        }
        this.dirty = false;
    }

    public String getPlacement() {
        return this.placement;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        this.checkState();
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        this.checkState();
        return this.y;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setColorPalette(float[][] colorPalette) {
        this.colorPalette = colorPalette;
    }

    public float[][] getColorPalette() {
        return this.colorPalette;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelSide(int side) {
        this.labelSide = side;
    }

    public int getLabelSide() {
        this.checkState();
        return this.labelSide;
    }

    public void setIsVisible(boolean show) {
        this.isVisible = show;
    }

    public boolean getIsVisible() {
        return this.isVisible;
    }

    public void setLabelVisible(boolean show) {
        this.labelVisible = show;
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public boolean getUseAlpha() {
        return this.useAlpha;
    }

    public void setUseAlpha(boolean useAlpha) {
        this.useAlpha = useAlpha;
    }

    private static String getDefaultPlace(int orient) {
        return ColorScale.getDefaultPlace(orient);
    }

    private static float getX(int orient, String placement) {
        return ColorScale.getX(orient, placement);
    }

    private static float getY(int orient, String placement) {
        return ColorScale.getY(orient, placement);
    }

    public String toString() {
        return "placement:" + this.placement + " orient:" + this.orient + " label side: " + this.labelSide + " x/y:" + this.x + "/" + this.y;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean isUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean unitVisible) {
        this.unitVisible = unitVisible;
    }
}

